@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('auth/user.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('auth/user.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('users.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $user->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($user,['route' => ['users.update',$user->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form']) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('auth/user.entry_name') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('auth/user.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('email', __('auth/user.entry_email') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('auth/user.entry_email'),'required']) !!}
                                        @if ($errors->has('email'))
                                            <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('password') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('password', __('auth/user.entry_password') . ' <span class="required text-danger">*</span> <i class="fa fa-info-circle text-info" data-toggle="tooltip" data-placement="top" title="'.__('auth/user.help_password').'"></i>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::password('password', ['class' => 'form-control', 'placeholder' => __('auth/user.entry_password')]) !!}
                                        @if ($errors->has('password'))
                                            <span class="help-block"><small>{{ $errors->first('password') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('password_confirmation', __('auth/user.entry_password_confirmation') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::password('password_confirmation', ['class' => 'form-control', 'placeholder' => __('auth/user.entry_password_confirmation')]) !!}
                                        @if ($errors->has('password_confirmation'))
                                            <span class="help-block"><small>{{ $errors->first('password_confirmation') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('sys_customer_id') ? ' has-error' : '' }}">
                                    @php
                                        $tmp_sys_customers = [];
                                        if(!empty(old('sys_customer_id',$user->sys_customer_id))){
                                            $tmp_sys_customers = \App\Models\System\SysCustomer::where('id','=',old('sys_customer_id',$user->sys_customer_id))->get()->pluck('text_select2','id');
                                        }
                                    @endphp
                                    {!! html_entity_decode(Form::label('sys_customer_id', __('auth/user.entry_sys_customer_id')  . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::select('sys_customer_id', $tmp_sys_customers,old('sys_customer_id',$user->sys_customer_id), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-info btn-sys-customer-search"><i class="fa fa-search"></i></button>
                                            </span>
                                        </div>
                                        @if ($errors->has('sys_customer_id'))
                                            <span class="help-block"><small>{{ $errors->first('sys_customer_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('expiry_date') ? ' has-error' : '' }} hidden">
                                    {!! html_entity_decode(Form::label('expiry_date', __('auth/user.entry_expiry_date') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                        {!! Form::text('expiry_date', old('expiry_date',$user->expiry_date ? \App\Helpers\Helper::convertSqlToDateTime($user->expiry_date) : ''), ['class' => 'form-control', 'placeholder' => __('auth/user.entry_expiry_date'),'autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('expiry_date'))
                                            <span class="help-block"><small>{{ $errors->first('expiry_date') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @if(Auth::user()->superadmin)
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('distributor', __('auth/user.entry_distributor') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                        <div class="col-md-6 col-xs-12">
                                            <label>
                                                {!! Form::checkbox('distributor', '1',(!empty(old('distributor',$user->distributor)) ? true : false),['class' => 'js-switch']); !!}
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group form-group-sm{{ $errors->has('available_folio') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('available_folio', __('auth/user.entry_available_folio') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                        <div class="col-md-6 col-xs-12">
                                            {!! Form::number('available_folio', old('available_folio'), ['class' => 'form-control', 'placeholder' => __('auth/user.entry_available_folio')]) !!}
                                            @if ($errors->has('available_folio'))
                                                <span class="help-block"><small>{{ $errors->first('available_folio') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('send_access', __('auth/user.entry_send_access'). ' <i class="fa fa-info-circle text-info" data-toggle="tooltip" data-placement="top" title="'.__('auth/user.help_send_access').'"></i>' , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('send_access', '1',(!empty(old('send_access',0)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('status', __('auth/user.entry_status') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('status', '1',(!empty(old('status',$user->status)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('', __('auth/user.text_permission') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        &nbsp;
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_customers', __('auth/user.entry_p_customers') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_customers', '1',(!empty(old('p_customers',$user->p_customers)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_products', __('auth/user.entry_p_products') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_products', '1',(!empty(old('p_products',$user->p_products)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_customer_quotations', __('auth/user.entry_p_customer_quotations') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_customer_quotations', '1',(!empty(old('p_customer_quotations',$user->p_customer_quotations)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_customer_remissions', __('auth/user.entry_p_customer_remissions') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_customer_remissions', '1',(!empty(old('p_customer_remissions',$user->p_customer_remissions)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_cfdis', __('auth/user.entry_p_cfdis') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_cfdis', '1',(!empty(old('p_cfdis',$user->p_cfdis)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_payrolls', __('auth/user.entry_p_payrolls') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_payrolls', '1',(!empty(old('p_payrolls',$user->p_payrolls)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_tax_mailbox', __('auth/user.entry_p_tax_mailbox') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_tax_mailbox', '1',(!empty(old('p_tax_mailbox',$user->p_tax_mailbox)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_cfdi_downloads', __('auth/user.entry_p_cfdi_downloads') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_cfdi_downloads', '1',(!empty(old('p_cfdi_downloads',$user->p_cfdi_downloads)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_bank_reconciliations', __('auth/user.entry_p_bank_reconciliations') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_bank_reconciliations', '1',(!empty(old('p_bank_reconciliations',$user->p_bank_reconciliations)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_report_income_expenses', __('auth/user.entry_p_report_income_expenses') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_report_income_expenses', '1',(!empty(old('p_report_income_expenses',$user->p_report_income_expenses)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_catalogs', __('auth/user.entry_p_catalogs') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_catalogs', '1',(!empty(old('p_catalogs',$user->p_catalogs)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_branch_offices', __('auth/user.entry_p_branch_offices') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_branch_offices', '1',(!empty(old('p_branch_offices',$user->p_branch_offices)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_companies', __('auth/user.entry_p_companies') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_companies', '1',(!empty(old('p_companies',$user->p_companies)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_add_companies', __('auth/user.entry_p_add_companies') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_add_companies', '1',(!empty(old('p_add_companies',$user->p_add_companies)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_edit_companies', __('auth/user.entry_p_edit_companies') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_edit_companies', '1',(!empty(old('p_edit_companies',$user->p_edit_companies)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_settings', __('auth/user.entry_p_settings') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_settings', '1',(!empty(old('p_settings',$user->p_settings)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_admin', __('auth/user.entry_p_admin') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_admin', '1',(!empty(old('p_admin',$user->p_admin)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('p_users', __('auth/user.entry_p_users') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('p_users', '1',(!empty(old('p_users',$user->p_users)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('users.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='expiry_date']").daterangepicker({
                singleDatePicker: true,
                timePicker: true,
                timePicker24Hour: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('datetime_picker_format','DD-MM-YYYY HH:mm:ss') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='expiry_date']").val(chosen_date.format("{{ setting('datetime_picker_format','DD-MM-YYYY HH:mm:ss') }}"));
            });

            /* Configura select2 para buscar cliente sistema*/
            $("#form select[name='sys_customer_id']").select2({
                ajax: {
                    url: "{{route('sys-customers/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });

            /*Modal para buscar clientes sistema*/
            $(".btn-sys-customer-search").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('sys-customers/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_sys_customer_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar cliente sistema*/
            $(document).on("click", '#form_modal_sys_customer_search #sys_customers .btn-select-sys-customer', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-name'), $(this).attr('data-id'), false, true);
                $("#form select[name='sys_customer_id']").append(option).trigger('change');
                $("#modal_sys_customer_search").modal("hide");
            });

        });

    </script>
@endsection
