@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('auth/user.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('auth/user.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('users.create',request()->except('page'))}}"
                               class="btn btn-sm btn-success">@lang('general.button_add')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_list')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->
                            <div class="filter-data">
                                {!! Form::open(['route' => 'users.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-8 col-xs-4 text-left">
                                        <div class="form-inline">
                                            <span>
                                                <span class="hidden-xs">@lang('general.text_item_per_page')</span>
                                                {!! Form::select('limit', $limits,request()->input('limit',setting('list_limit','100')), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'onchange' => 'this.form.submit()']) !!}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xs-8 text-right">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('filter_search', request()->input('filter_search'), ['class' => 'form-control', 'placeholder' => __('general.text_search') . '...']) !!}
                                            <span class="input-group-btn">
                                                    {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-default']) !!}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th class="text-left">@sortablelink('name', __('auth/user.column_name'))
                                        </th>
                                        <th class="text-center">@sortablelink('email',
                                            __('auth/user.column_email'))
                                        </th>
                                        @if(Auth::user()->superadmin)
                                        <th class="text-center">@sortablelink('distributor',
                                            __('auth/user.column_distributor'))
                                        </th>
                                        @endif
                                        <th class="text-center">@sortablelink('available_folio',
                                            __('auth/user.column_available_folio'))
                                        </th>
                                        <th class="text-left">@sortablelink('sysCustomer.name',
                                            __('auth/user.column_sys_customer'))
                                        </th>
                                        <th class="text-center">@sortablelink('last_login',
                                            __('auth/user.column_last_login'))
                                        </th>
                                        <th class="text-center">@sortablelink('status',
                                            __('auth/user.column_status'))
                                        </th>
                                        <th class="text-center" width="8%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="{{ (!$result->status ? 'text-muted' : '') }}">
                                            <td class="text-left">
                                                <a href="{{ route('users.edit',array_merge(['id' => $result->id],request()->except('page'))) }}">{{$result->name}}</a>
                                            </td>
                                            <td class="text-center">{{$result->email}}</td>
                                            @if(Auth::user()->superadmin)
                                                <td class="text-center">
                                                @if($result->distributor)
                                                    <i class="fa fa-check"></i>
                                                @endif
                                                </td>
                                            @endif
                                            <td class="text-center">
                                                @if($result->distributor)
                                                {{\App\Helpers\Helper::numberFormat($result->available_folio,0)}}
                                                @endif
                                            </td>
                                            <td class="text-left">{{$result->sysCustomer->name ?? ''}}
                                                @if($result->sysCustomer ?? '')
                                                    @if($result->sysCustomer->status == 0)
                                                    <br/>
                                                    <label class="label label-warning">{{ __('general.text_tenant_suspended') }}</label>
                                                    @endif
                                                @endif
                                            </td>
                                            <td class="text-center">{{ $result->last_login ? \App\Helpers\Helper::convertSqlToDateTime($result->last_login) : '' }}</td>
                                            <td class="text-center">
                                                @if($result->status)
                                                    <label class="label label-success">{{ \App\Helpers\Helper::statusTenant($result->status) }}</label>
                                                @else
                                                    <label class="label label-default">{{ \App\Helpers\Helper::statusTenant($result->status) }}</label>
                                                @endif
                                            </td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <!-- form -->
                                            {!! Form::open(['route' => ['users.destroy', $result->id],'method' => 'DELETE','class' => 'hidden','role' => 'form','id' => 'form' . $result->id ]) !!}
                                            {!! Form::close() !!}
                                            <!-- /form -->
                                                <div class="btn-group btn-group-xs text-nowrap" role="group">
                                                    <!--<a href="{{ route('users/reset-link-email',['id' => $result->id]) }}"
                                                       class="btn btn-xs btn-primary"
                                                       title="@lang('general.button_reset_password')">
                                                        <i class="fa fa-envelope"></i>
                                                    </a>-->
                                                    <a href="{{ route('users.edit',array_merge(['id' => $result->id],request()->except('page'))) }}"
                                                       class="btn btn-xs btn-info"
                                                       title="@lang('general.button_edit')">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                    <a href="javascript:;" class="btn btn-xs btn-danger"
                                                       onclick="$('#form{{$result->id}}').submit();"
                                                       title="@lang('general.button_delete')">
                                                        <i class="fa fa-trash-o"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="11"
                                                class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->
        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection
