<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$bank_reconciliation->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 110px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($bank_reconciliation->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($bank_reconciliation->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -87px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ __('base/bank_reconciliation.document_title') }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px;">
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($bank_reconciliation->company_id) }}" class="invoice-logo" width="170px"/>
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span class="text-primary">{{ $bank_reconciliation->name }}</span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">

            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($bank_reconciliation->status == \App\Models\Base\BankReconciliation::CANCEL)
<section class="watermark" style="bottom: 640px !important;">
    <span>@lang('general.text_canceled')</span>
</section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        @foreach($bank_reconciliation->bankReconciliationLines as $result)
        <thead>
        <tr>
            <th width="10%" class="text-center" style="font-size: 110%;">{{$result->sort_order}}</th>
            <th width="45%">{{ mb_strtoupper(__('base/bank_reconciliation.text_cfdi_downloads')) }}</th>
            <th width="45%">{{ mb_strtoupper(__('base/bank_reconciliation.text_bank_moves')) }}</th>
        </tr>
        </thead>
        <tbody>
            <tr>
                <td></td>
                <td class="text-center">
                    @foreach($result->bankMoveReconcileds as $bank_move_reconciled)
                        {{ \App\Helpers\Helper::date(\App\Helpers\Helper::createDateTimeFromSql($bank_move_reconciled->reconciled->date)) }} / {{$bank_move_reconciled->reconciled->name}} / {{$bank_move_reconciled->reconciled->currency->code ?? ''}} / {{money($bank_move_reconciled->amount_reconciled,$bank_move_reconciled->reconciled->currency->code ?? 'MXN',true)}}<br/>
                        <span class="text-muted">{{$bank_move_reconciled->reconciled->type_name}}-{{$bank_move_reconciled->reconciled->cfdiType->name ?? ''}}</span><br>
                    @endforeach
                </td>
                <td class="text-center">
                    @foreach($result->bankMoves as $bank_move)
                        {{ \App\Helpers\Helper::date(\App\Helpers\Helper::createDateTimeFromSql($bank_move->date)) }} / {{$bank_move->reference}} / {{$bank_move->currency->code ?? ''}} / {{money(abs($bank_move->amount),$bank_move->currency->code ?? 'MXN',true)}}<br/>
                        <span class="text-muted">
                            @if($bank_move->amount > 0)
                                {{__('base/bank_reconciliation.column_credit')}}
                            @else
                                {{__('base/bank_reconciliation.column_debit')}}
                            @endif
                        </span><br>
                    @endforeach
                </td>
            </tr>
            <tr>
                <td>&nbsp;</td>
                <td class="text-center">
                    <b>{{money($result->amount_reconciled,'MXN',true)}}</b>
                </td>
                <td class="text-center">
                    <b>{{money($result->amount_reconciled,'MXN',true)}}</b>
                </td>
            </tr>
        </tbody>
        @endforeach
        <tfoot>

        </tfoot>
    </table>
    </div>
</section>
</body>
</html>
