@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/branch_office.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/branch_office.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('branch-offices.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $branch_office->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                        {!! Form::model($branch_office,['route' => ['branch-offices.update',$branch_office->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form','files' => true]) !!}
                        <!-- input hidden -->
                        {!! Form::hidden('logo_docs', old('logo_docs')) !!}
                        <!-- /.input hidden -->
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_general" id="general-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('general.tab_general')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_address" id="address-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('general.tab_address')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade active in" id="tab_general"
                                         aria-labelledby="general-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('name', __('base/branch_office.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_name'),'required','autofocus']) !!}
                                                    @if ($errors->has('name'))
                                                        <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('email', __('base/branch_office.entry_email') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_email')]) !!}
                                                    @if ($errors->has('email'))
                                                        <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('phone', __('base/branch_office.entry_phone') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('phone', old('phone'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_phone')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('phone_mobile', __('base/branch_office.entry_phone_mobile') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('phone_mobile', old('phone_mobile'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_phone_mobile')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! Form::label('sort_order', __('base/branch_office.entry_sort_order'), ['class' => 'control-label']) !!}
                                                    {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_sort_order')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="row">
                                                    <div class="col-md-12 col-xs-12">
                                                    {!! html_entity_decode(Form::label('logo_docs', __('base/branch_office.entry_logo_docs') . ' ', ['class' => 'control-label'])) !!}
                                                    </div>
                                                    <div class="col-md-55 col-xs-12">
                                                        <div class="thumbnail" style="margin-bottom: 5px;">
                                                            <div class="image view view-first">
                                                                <img style="width: 100%; display: block; height: 100%;"
                                                                     class="img-responsive"
                                                                     src="{{!empty($branch_office->logo_docs) ? $branch_office->pathLogoDocs() : asset('img/no_imagen_340x150.png')}}"
                                                                     data-placeholder="{{asset('img/no_imagen_340x150.png')}}"
                                                                     alt="@lang('base/branch_office.entry_logo_docs')"
                                                                     id="img_logo_docs"/>
                                                                <div class="mask">
                                                                    <p>&nbsp;</p>
                                                                    <div class="tools tools-bottom">
                                                                        <a href="#" id="btn_edit_logo_docs"
                                                                           title="@lang('general.button_edit')"><i
                                                                                class="fa fa-pencil"></i></a>
                                                                        <a href="{{!empty($branch_office->logo_docs) ? $branch_office->pathLogoDocs() : asset('img/no_imagen_340x150.png')}}"
                                                                           id="btn_view_logo_docs"
                                                                           title="@lang('general.button_view')" data-fancybox><i
                                                                                class="fa fa-search"></i></a>
                                                                        <a href="#" id="btn_delete_logo_docs"
                                                                           title="@lang('general.button_delete')"><i
                                                                                class="fa fa-trash-o"></i></a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('file_logo_docs') ? ' has-error' : '' }}">
                                                    {!! Form::file('file_logo_docs', ['class'=> 'hidden']) !!}
                                                    <small class="text-muted">@lang('base/branch_office.help_logo_docs')</small>
                                                    @if ($errors->has('file_logo_docs'))
                                                        <span class="help-block"><small>{{ $errors->first('file_logo_docs') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('comment', __('base/branch_office.entry_comment') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::textarea('comment', old('comment'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_comment'),'rows' => '2']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('status', __('base/branch_office.entry_status') , ['class' => 'control-label'])) !!}
                                                    <br/>
                                                    <label>
                                                        {!! Form::checkbox('status', '1',(!empty(old('status',$branch_office->status)) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_address"
                                         aria-labelledby="address-tab">
                                        <div class="row">
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_1', __('base/branch_office.entry_address_1') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_1', old('address_1'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_1')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_2', __('base/branch_office.entry_address_2') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_2', old('address_2'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_2')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_3', __('base/branch_office.entry_address_3') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_3', old('address_3'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_3')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_4', __('base/branch_office.entry_address_4') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_4', old('address_4'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_4')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_5', __('base/branch_office.entry_address_5') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_5', old('address_5'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_5')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-8 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_6', __('base/branch_office.entry_address_6') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_6', old('address_6'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_6')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('country_id', __('base/branch_office.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('state_id', __('base/branch_office.entry_state_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('state_id', [],old('state_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('city_id', __('base/branch_office.entry_city_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('city_id', [],old('city_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('postcode') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('postcode', __('base/branch_office.entry_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('postcode', old('postcode'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_postcode'),'required']) !!}
                                                    @if ($errors->has('postcode'))
                                                        <span class="help-block"><small>{{ $errors->first('postcode') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                    &nbsp;&nbsp;&nbsp;
                                    <a href="{{route('branch-offices.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });

            /* Selecciona pais */
            $("#form select[name='country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{old('state_id',$branch_office->state_id)}}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");

            /* Selecciona estado */
            $("#form select[name='state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{old('city_id',$branch_office->city_id)}}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            $("#form #btn_edit_logo_docs").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_logo_docs']").trigger('click');
            });
            $("#form #btn_delete_logo_docs").on("click", function (e) {
                e.preventDefault();
                $("#form #img_logo_docs").attr('src', $("#form #img_logo_docs").attr('data-placeholder'));
                $("#form input[name='logo_docs']").val('');
            });
            $("#form input[name='file_logo_docs']").on("change", function () { //Precarga imagen para visualizar
                if ($(this)[0].files && $(this)[0].files[0]) {
                    let reader = new FileReader();
                    reader.onload = function (e) {
                        $("#form #img_logo_docs").attr("src", e.target.result);
                    };
                    reader.readAsDataURL($(this)[0].files[0]);
                }
            });

        });

    </script>
@endsection
