@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/cfdi_download.document_title_cfdi_download'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/cfdi_download.document_title_cfdi_download')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('cfdi-downloads/reset-sat-login')}}"
                               class="btn btn-sm btn-success">@lang('general.button_login_sat')
                            </a>
                            &nbsp;
                            <a href="{{route('cfdi-downloads.index')}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('base/cfdi_download.text_step_2')</h2>
                            <div class="clearfix"></div>
                            <p>@lang('base/cfdi_download.help_step_2')</p>
                        </div>
                        <div class="x_content">
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="{{old('type',request()->input('type',1)) == '1' ? 'active' : ''}}">
                                        <a href="#tab_received" id="received-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/cfdi_download.tab_received')</a>
                                    </li>
                                    <li role="presentation" class="{{old('type',request()->input('type')) == '2' ? 'active' : ''}}">
                                        <a href="#tab_issued" id="issued-tab" role="tab"
                                           data-toggle="tab"
                                           aria-expanded="false">@lang('base/cfdi_download.tab_issued')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade {{old('type',request()->input('type',1)) == '1' ? 'active in' : ''}}" id="tab_received" aria-labelledby="received-tab">
                                        {!! Form::open(['route' => 'cfdi-downloads/cfdi-download-request','method' => 'GET','class' => '','role' => 'form','id'=>'form_received']) !!}
                                        {!! Form::hidden('type', 1) !!}
                                        <div class="row">
                                            <div class="col-md-1 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('year', __('base/cfdi_download.entry_year') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('year', $years,request()->input('year',\Date::now()->format('Y')), ['class' => 'form-control']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-1 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('month', __('base/cfdi_download.entry_month') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('month', $months,request()->input('month',(int)\Date::now()->format('m')), ['class' => 'form-control']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-1 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('day', __('base/cfdi_download.entry_day') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('day', $days,request()->input('day'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('start_time_hour', __('base/cfdi_download.entry_start_time') , ['class' => 'control-label'])) !!}
                                                    <div class="row">
                                                        <div class="col-xs-6 pr-1">
                                                            {!! Form::select('start_time_hour', $hours,request()->input('start_time_hour'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                        <div class="col-xs-6">
                                                            {!! Form::select('start_time_minute', $minutes,request()->input('start_time_minute'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('end_time_hour', __('base/cfdi_download.entry_end_time') , ['class' => 'control-label'])) !!}
                                                    <div class="row">
                                                        <div class="col-xs-6 pr-1">
                                                        {!! Form::select('end_time_hour', $hours,request()->input('end_time_hour'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                        <div class="col-xs-6">
                                                        {!! Form::select('end_time_minute', $minutes,request()->input('end_time_minute'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('rfc_emisor', __('base/cfdi_download.entry_rfc_emisor') , ['class' => 'control-label'])) !!}
                                                    {!! Form::text('rfc_emisor', request()->input('rfc_emisor'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_rfc_emisor')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('uuid', __('base/cfdi_download.entry_uuid') , ['class' => 'control-label'])) !!}
                                                    {!! Form::text('uuid', request()->input('uuid'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_uuid')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-1 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('status', __('base/cfdi_download.entry_status') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('status', $sat_status,request()->input('status'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12 text-right ">
                                                {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                            </div>
                                            <!--<div class="col-md-4 col-xs-12 text-right">
                                                {!! html_entity_decode(Form::label('', '&nbsp;' , ['class' => 'control-label'])) !!}<br>
                                                {!! Form::button(__('general.button_download_selected'),['type' => 'button', 'class' => 'btn btn-sm btn-primary','onclick' => '$(\'#form_download_received\').submit();']) !!}
                                            </div>-->
                                        </div>
                                        {!! Form::close() !!}

                                        {{-- Lista XML recibidos consultados --}}
                                        {!! Form::open(['route' => 'cfdi-downloads/cfdi-download','method' => 'POST','class' => '','role' => 'form','id'=>'form_download_received']) !!}
                                        {!! Form::hidden('year_f', request()->input('year',\Date::now()->format('Y'))) !!}
                                        {!! Form::hidden('month_f', request()->input('month',\Date::now()->format('m'))) !!}
                                        {!! Form::hidden('type', 1) !!}
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped mt-4" style="min-width: 1400px;" id="table_received">
                                                        <thead>
                                                        <tr>
                                                            <th class="text-center">
                                                                #
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_url_xml')}}<br/>
                                                                <input type="checkbox" onclick="$('#form_download_received input[name*=\'xml\']').prop('checked', this.checked);" checked/>
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_url_pdf')}}<br/>
                                                                <input type="checkbox" onclick="$('#form_download_received input[name*=\'pdf\']').prop('checked', this.checked);" checked/>
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_url_acuse')}}<br/>
                                                                <input type="checkbox" onclick="$('#form_download_received input[name*=\'acuse\']').prop('checked', this.checked);" checked/>
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_cfdi_type')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_date')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_uuid')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_rfc_emisor')}}
                                                            </th>
                                                            <th class="text-left">
                                                                {{__('base/cfdi_download.column_emisor')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_amount_total')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_date_certification')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_rfc_pac')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_status')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_is_cancelable')}}
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ln_solid"></div>
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12 text-right footer-form">
                                                {!! Form::button(__('general.button_download_selected'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                            </div>
                                        </div>
                                        {!! Form::close() !!}
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade {{old('type',request()->input('type')) == '2' ? 'active in' : ''}}" id="tab_issued" aria-labelledby="issued-tab">
                                        {!! Form::open(['route' => 'cfdi-downloads/cfdi-download-request','method' => 'GET','class' => '','role' => 'form','id'=>'form_issued']) !!}
                                        {!! Form::hidden('type', 2) !!}
                                        <div class="row">
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('filter_date_from', __('general.text_date_from') . '', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('filter_date_from', request()->input('filter_date_from',\App\Helpers\Helper::date(Date::parse('first day of this month'))), ['class' => 'form-control', 'placeholder' => __('general.text_date_from'),'autocomplete'=>'off']) !!}
                                                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('start_time_hour2', __('base/cfdi_download.entry_start_time') , ['class' => 'control-label'])) !!}
                                                    <div class="row">
                                                        <div class="col-xs-6 pr-1">
                                                            {!! Form::select('start_time_hour2', $hours,request()->input('start_time_hour2'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                        <div class="col-xs-6">
                                                            {!! Form::select('start_time_minute2', $minutes,request()->input('start_time_minute2'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('filter_date_to', __('general.text_date_to') . '', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('filter_date_to', request()->input('filter_date_to',\App\Helpers\Helper::date(Date::parse('last day of this month'))), ['class' => 'form-control', 'placeholder' => __('general.text_date_to'),'autocomplete'=>'off']) !!}
                                                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('end_time_hour2', __('base/cfdi_download.entry_end_time') , ['class' => 'control-label'])) !!}
                                                    <div class="row">
                                                        <div class="col-xs-6 pr-1">
                                                        {!! Form::select('end_time_hour2', $hours,request()->input('end_time_hour2'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                        <div class="col-xs-6">
                                                        {!! Form::select('end_time_minute2', $minutes,request()->input('end_time_minute2'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('rfc_receptor', __('base/cfdi_download.entry_rfc_receptor') , ['class' => 'control-label'])) !!}
                                                    {!! Form::text('rfc_receptor', request()->input('rfc_receptor'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_rfc_receptor')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-1 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('uuid', __('base/cfdi_download.entry_uuid') , ['class' => 'control-label'])) !!}
                                                    {!! Form::text('uuid', request()->input('uuid'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_uuid')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-1 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('status', __('base/cfdi_download.entry_status') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('status', $sat_status,request()->input('status'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                </div>
                                            </div>
                                            <!--<div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('year', __('base/cfdi_download.entry_year') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('year', $years,request()->input('year',\Date::now()->format('Y')), ['class' => 'form-control']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('month', __('base/cfdi_download.entry_month') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('month', $months,request()->input('month',(int)\Date::now()->format('m')), ['class' => 'form-control']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('day', __('base/cfdi_download.entry_day') , ['class' => 'control-label'])) !!}
                                                    {!! Form::select('day', $days,request()->input('day'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                                </div>
                                            </div>-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12 text-right ">
                                                {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                            </div>
                                            <!--<div class="col-md-4 col-xs-12 text-right">
                                                {!! html_entity_decode(Form::label('', '&nbsp;' , ['class' => 'control-label'])) !!}<br>
                                                {!! Form::button(__('general.button_download_selected'),['type' => 'button', 'class' => 'btn btn-sm btn-primary','onclick' => '$(\'#form_download_issued\').submit();']) !!}
                                            </div>-->
                                        </div>
                                        {!! Form::close() !!}

                                        {{-- Lista XML emitidos consultados --}}
                                        {!! Form::open(['route' => 'cfdi-downloads/cfdi-download','method' => 'POST','class' => '','role' => 'form','id'=>'form_download_issued']) !!}
                                        {!! Form::hidden('type', 2) !!}
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped mt-4" style="min-width: 1400px;" id="table_issued">
                                                        <thead>
                                                        <tr>
                                                            <th class="text-center">
                                                                #
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_url_xml')}}<br/>
                                                                <input type="checkbox" onclick="$('#form_download_issued input[name*=\'xml\']').prop('checked', this.checked);" checked/>
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_url_pdf')}}<br/>
                                                                <input type="checkbox" onclick="$('#form_download_issued input[name*=\'pdf\']').prop('checked', this.checked);" checked/>
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_url_acuse')}}<br/>
                                                                <input type="checkbox" onclick="$('#form_download_issued input[name*=\'acuse\']').prop('checked', this.checked);" checked/>
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_cfdi_type')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_date')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_uuid')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_rfc_receptor')}}
                                                            </th>
                                                            <th class="text-left">
                                                                {{__('base/cfdi_download.column_receptor')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_amount_total')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_date_certification')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_rfc_pac')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_status')}}
                                                            </th>
                                                            <th class="text-center">
                                                                {{__('base/cfdi_download.column_is_cancelable')}}
                                                            </th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ln_solid"></div>
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12 text-right footer-form">
                                                {!! Form::button(__('general.button_download_selected'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                            </div>
                                        </div>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                            </div>

                            <!-- Footer form -->
                            <!-- /Footer form -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        function trLoading(colspan, message)
        {
            return '<tr><td class="tr-loading text-center mt-5 mb-5" colspan="' + colspan + '"><img src="/img/loading.gif" style="width: 200px;"><br/><div class="block mb-3 text-primary"><b>' + message + '</b></div></td></tr>'
        }

        function searchXmls(form, container)
        {
            $(container + " thead").removeClass("hidden")
            $(container + " tbody").html(trLoading(14, "Buscando..."));
            $.ajax({
                url: form.attr('action'),
                type: "POST",
                global: false,
                dataType: "JSON",
                data: form.serialize(),
                success: function (data) {
                    if (data) {
                        $(container + " tbody").html(data.html);
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    $(container + " tbody").html("");
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        }

        function downloadXmls(form, container)
        {
            var formData = form.serialize()
            $(container + " tbody").html(trLoading(14, "Descargando..."));
            $.ajax({
                url: form.attr('action'),
                type: "POST",
                global: false,
                dataType: "JSON",
                data: formData,
                success: function (data) {
                    if (data) {
                        $(container + " tbody").html("");
                        $("#general_messages").html(alertMessage("success", data.message));
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    $(container + " tbody").html('');
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        }

        $(function () {
            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form_issued input[name='filter_date_from']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form_issued input[name='filter_date_from']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form_issued input[name='filter_date_to']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form_issued input[name='filter_date_to']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });

            $("#form_received").submit( function (e) {
                e.preventDefault();
                searchXmls($(this), "#table_received")
            })
            $("#form_issued").submit( function (e) {
                e.preventDefault();
                searchXmls($(this), "#table_issued")
            })

            $("#form_download_received").submit( function (e) {
                e.preventDefault();
                downloadXmls($(this), "#table_received")
            })
            $("#form_download_issued").submit( function (e) {
                e.preventDefault();
                downloadXmls($(this), "#table_issued")
            })
        });

    </script>
@endsection
