@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/cfdi_download.document_title_cfdi_download'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/cfdi_download.document_title_cfdi_download')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('cfdi-downloads/reset-sat-login')}}"
                               class="btn btn-sm btn-success">@lang('general.button_login_sat')
                            </a>
                            &nbsp;
                            <a href="{{route('cfdi-downloads.index')}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('base/cfdi_download.text_step_2')</h2>
                            <div class="clearfix"></div>
                            <p>{!! __('base/cfdi_download.help_step_2_fiel') !!}</p>
                            <p>{!! __('base/cfdi_download.help_step_2_fiel_2') !!}</p>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'cfdi-downloads/create-cfdi-download-fiel','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                            <div class="row">
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('filter_date_from', __('general.text_date_from') . '', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('filter_date_from', request()->input('filter_date_from',\App\Helpers\Helper::date(Date::parse('first day of this month'))), ['class' => 'form-control', 'placeholder' => __('general.text_date_from'),'autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('filter_date_to', __('general.text_date_to') . '', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('filter_date_to', request()->input('filter_date_to',\App\Helpers\Helper::date(Date::parse('last day of this month'))), ['class' => 'form-control', 'placeholder' => __('general.text_date_to'),'autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('filter_type', __('base/cfdi_download.entry_type') , ['class' => 'control-label'])) !!}
                                        {!! Form::select('filter_type', ['1' => __('base/cfdi_download.tab_received'),'2' => __('base/cfdi_download.tab_issued')],request()->input('filter_type'), ['class' => 'form-control', 'placeholder' => __('general.text_select'), 'required']) !!}
                                    </div>
                                </div>
                                <div class="col-md-2 col-xs-12">
                                    {!! html_entity_decode(Form::label('', '&nbsp;' , ['class' => 'control-label'])) !!}<br>
                                    {!! Form::button(__('general.button_download_request'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                </div>
                            </div>
                        {!! Form::close() !!}

                        <!-- Datos -->
                            <div class="table-responsive table-data mt-3">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th class="text-center">@sortablelink('date',
                                            __('base/cfdi_download_request.column_date'))
                                        </th>
                                        <th class="text-center">@sortablelink('folio',
                                            __('base/cfdi_download_request.column_folio'))
                                        </th>
                                        <th class="text-center">@sortablelink('type',
                                            __('base/cfdi_download_request.column_type'))
                                        </th>
                                        <th class="text-center">@sortablelink('date_start',
                                            __('base/cfdi_download_request.column_date_start'))
                                        </th>
                                        <th class="text-center">@sortablelink('date_end',
                                            __('base/cfdi_download_request.column_date_end'))
                                        </th>
                                        <th class="text-center">@sortablelink('qty',
                                            __('base/cfdi_download_request.column_qty'))
                                        </th>
                                        <th class="text-center" width="8%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="{{ (!$result->status ? 'text-muted' : '') }}">
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDateTime($result->date) }}</td>
                                            <td class="text-center">{{$result->folio}}</td>
                                            <td class="text-center">{{$result->type_name}}</td>
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDateTime($result->date_start) }}</td>
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDateTime($result->date_end) }}</td>
                                            <td class="text-center">
                                                <span id="col_qty_{{$result->id}}">{{ \App\Helpers\Helper::numberFormat($result->qty) }}</span>
                                            </td>
                                            <td class="text-center">
                                                @if($result->qty < 1)
                                                    <a href="#" class="btn btn-xs btn-warning btn-verify" data-id="{{$result->id}}" data-url="{{route('cfdi-downloads/request-verify',['id' => $result->id])}}">
                                                        {{__('general.button_request_verify')}}
                                                    </a>
                                                    <a href="{{route('cfdi-downloads/request-download',['id' => $result->id])}}" class="btn btn-xs btn-info hidden" id="btn_download_{{$result->id}}">
                                                        {{__('general.button_request_download')}}
                                                    </a>
                                                @elseif($result->qty > 0 && !$result->completed)
                                                    <a href="{{route('cfdi-downloads/request-download',['id' => $result->id])}}" class="btn btn-xs btn-info" id="btn_download_{{$result->id}}">
                                                        {{__('general.button_request_download')}}
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                            <!-- Footer form -->
                            <!-- /Footer form -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='filter_date_from']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='filter_date_from']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form input[name='filter_date_to']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='filter_date_to']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });

            /*Modal para editar*/
            $(".btn-verify").on("click", function () {
                let id = $(this).attr('data-id');
                let url = $(this).attr('data-url');
                let btn_verify = $(this);
                if (id && url) {
                    Pace.track(function () {
                        $.ajax({
                            url: url,
                            type: "GET",
                            dataType: "JSON",
                            data: "id=" + id ,
                            success: function (data) {
                                $("#col_qty_" + id).html(data.qty);
                                if(data.response) {
                                    $("#btn_download_" + id).removeClass("hidden");
                                    btn_verify.addClass("hidden");
                                }
                            },
                            error: function (error, textStatus, errorThrown) {
                                if (error.status == 422) {
                                    var message = error.responseJSON.error;
                                    $("#general_messages").html(alertMessage("danger", message));
                                } else if (error.status == 403 || error.status == 401) {
                                    location.href = "{{ route('login') }}";
                                } else {
                                    alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                                }
                            }
                        });
                    });
                }
            });
        });

    </script>
@endsection
