@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/cfdi_download.document_title_cfdi_download'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/cfdi_download.document_title_cfdi_download')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('cfdi-downloads.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('base/cfdi_download.text_step_1')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'cfdi-downloads/sat-login','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form','files' => true]) !!}
                            <!-- input hidden -->
                            {!! Form::hidden('token_session', old('token_session', $token_session)) !!}
                            {!! Form::hidden('login_type', old('login_type',$login_type)) !!}
                            <!-- /.input hidden -->
                            @if($login_type == 'login_password')
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('rfc') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('rfc', __('base/cfdi_download.entry_rfc') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('rfc', old('rfc',$company->taxid), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_rfc'),'required','readonly']) !!}
                                        @if ($errors->has('rfc'))
                                            <span class="help-block"><small>{{ $errors->first('rfc') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('password') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('password', __('base/cfdi_download.entry_password') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::password('password', ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_password'),'required','autofocus']) !!}
                                        @if ($errors->has('password'))
                                            <span class="help-block"><small>{{ $errors->first('password') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('', '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <img style="height:60px" src="data:image/jpeg;base64,{{$captcha}}" />
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('captcha') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('captcha', __('base/cfdi_download.entry_captcha') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('captcha', old('captcha'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_captcha'),'required']) !!}
                                        @if ($errors->has('captcha'))
                                            <span class="help-block"><small>{{ $errors->first('captcha') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="">
                                <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                    {!! Form::button(__('general.button_login_2'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('cfdi-downloads/create-sat-login',['login_type' => 'efirma'])}}"
                                       class="btn btn-sm btn-info">@lang('general.button_e_firma')
                                    </a>
                                    &nbsp;&nbsp;
                                    <a href="{{route('cfdi-downloads.index')}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')
                                    </a>
                                </div>
                            </div>
                            @endif
                            @if($login_type == 'efirma')
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('rfc') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('rfc', __('base/cfdi_download.entry_rfc') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('rfc', old('rfc',$company->taxid), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_rfc'),'required','readonly']) !!}
                                        @if ($errors->has('rfc'))
                                            <span class="help-block"><small>{{ $errors->first('rfc') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('file_file_cer_ext') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('file_file_cer', __('base/company.entry_file_cer') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                    <div class="input-group input-group-sm">
                                        {!! Form::text('input_file_cer', old(''), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'readonly','autocomplete'=>'off']) !!}
                                        <span class="input-group-btn">
                                            <a href="#" class="btn btn-sm btn-info" id="btn_edit_file_cer">{{__('general.button_search')}}</a>
                                        </span>
                                    </div>
                                    {!! Form::file('file_file_cer', ['class'=> 'hidden', 'accept' => '.cer']) !!}
                                    @if ($errors->has('file_file_cer_ext'))
                                        <span class="help-block"><small>{{ $errors->first('file_file_cer_ext') }}</small></span>
                                    @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('file_file_key') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('file_file_key', __('base/company.entry_file_key') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                    <div class="input-group input-group-sm">
                                        {!! Form::text('input_file_key', old(''), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'readonly','autocomplete'=>'off']) !!}
                                        <span class="input-group-btn">
                                            <a href="#" class="btn btn-sm btn-info" id="btn_edit_file_key">{{__('general.button_search')}}</a>
                                        </span>
                                    </div>
                                    {!! Form::file('file_file_key', ['class'=> 'hidden', 'accept' => '.key']) !!}
                                    @if ($errors->has('file_file_key'))
                                        <span class="help-block"><small>{{ $errors->first('file_file_key') }}</small></span>
                                    @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('fiel_password') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('fiel_password', __('base/cfdi_download.entry_fiel_password') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::password('fiel_password', ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_fiel_password'),'required']) !!}
                                        @if ($errors->has('fiel_password'))
                                            <span class="help-block"><small>{{ $errors->first('fiel_password') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="">
                                <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                    {!! Form::button(__('general.button_login_2'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('cfdi-downloads/create-sat-login',['login_type' => 'login_password'])}}"
                                       class="btn btn-sm btn-info">@lang('general.button_password')
                                    </a>
                                    &nbsp;&nbsp;
                                    <a href="{{route('cfdi-downloads.index')}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')
                                    </a>
                                </div>
                            </div>
                            @endif
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*File de cer*/
            $("#form #btn_edit_file_cer").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_file_cer']").trigger('click');
            });
            $("#form #btn_delete_file_cer").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_cer']").val('');
                $("#form input[name='input_file_cer']").val('');
            });
            $("#form input[name='file_file_cer']").on("change", function () {
                if ($(this)[0].files && $(this)[0].files[0]) {
                    $("#form input[name='input_file_cer']").val($(this)[0].files[0].name);
                }
            });

            /*File de key*/
            $("#form #btn_edit_file_key").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_file_key']").trigger('click');
            });
            $("#form #btn_delete_file_key").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_key']").val('');
                $("#form input[name='input_file_key']").val('');
            });
            $("#form input[name='file_file_key']").on("change", function () {
                if ($(this)[0].files && $(this)[0].files[0]) {
                    $("#form input[name='input_file_key']").val($(this)[0].files[0].name);
                }
            });
        });

    </script>
@endsection
