@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/company.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/company.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            @if(!empty(setting('multi_taxid')))
                                <a href="{{route('companies.index',request()->except('page'))}}"
                                   class="btn btn-sm btn-default">@lang('general.button_discard')
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                        {!! Form::open(['route' => 'companies.store','method' => 'POST','class' => '','role' => 'form','id' => 'form','files' => true]) !!}
                        <!-- input hidden -->
                        {!! Form::hidden('image', old('image')) !!}
                        {!! Form::hidden('file_cer', old('file_cer')) !!}
                        {!! Form::hidden('file_key', old('file_key')) !!}
                        {!! Form::hidden('file_pfx', old('file_pfx')) !!}
                        <!-- /.input hidden -->
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_general" id="general-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('general.tab_general')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_address" id="address-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('general.tab_address')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_files_sat" id="files-sat-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('base/company.tab_files_sat')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_bank_accounts" id="bank-accounts-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('general.tab_bank_accounts')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade active in" id="tab_general"
                                         aria-labelledby="general-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="row">
                                                    <div class="col-md-55 col-xs-12">
                                                        <div class="thumbnail">
                                                            <div class="image view view-first">
                                                                <img style="width: 100%; display: block; height: 100%;"
                                                                     class="img-responsive"
                                                                     src="{{asset('img/no_imagen_340x150.png')}}"
                                                                     data-placeholder="{{asset('img/no_imagen_340x150.png')}}"
                                                                     alt="@lang('base/company.entry_image')"
                                                                     id="img_image"/>
                                                                <div class="mask">
                                                                    <p>&nbsp;</p>
                                                                    <div class="tools tools-bottom">
                                                                        <a href="#" id="btn_edit_image"
                                                                           title="@lang('general.button_edit')"><i
                                                                                    class="fa fa-pencil"></i></a>
                                                                        <a href="#" id="btn_delete_image"
                                                                           title="@lang('general.button_delete')"><i
                                                                                    class="fa fa-trash-o"></i></a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('file_image') ? ' has-error' : '' }}">
                                                    <div class="col-md-12 col-md-offset-3">
                                                        {!! Form::file('file_image', ['class'=> 'hidden']) !!}
                                                        @if ($errors->has('file_image'))
                                                            <span class="help-block"><small>{{ $errors->first('file_image') }}</small></span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-8 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('name', __('base/company.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_name'),'required','autofocus']) !!}
                                                    @if ($errors->has('name'))
                                                        <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('comercial_name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('comercial_name', __('base/company.entry_comercial_name') . ' ', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('comercial_name', old('comercial_name'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_comercial_name')]) !!}
                                                    @if ($errors->has('comercial_name'))
                                                        <span class="help-block"><small>{{ $errors->first('comercial_name') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('tax_regimen_id', __('base/company.entry_tax_regimen_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('tax_regimen_id', $tax_regimens,old('tax_regimen_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('tax_regimen_id'))
                                                        <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id2') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('tax_regimen_id2', __('base/company.entry_tax_regimen_id2') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('tax_regimen_id2', $tax_regimens,old('tax_regimen_id2'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('tax_regimen_id2'))
                                                        <span class="help-block"><small>{{ $errors->first('tax_regimen_id2') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('taxid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('taxid', __('base/company.entry_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('taxid', old('taxid'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/company.entry_taxid'),'required']) !!}
                                                    @if ($errors->has('taxid'))
                                                        <span class="help-block"><small>{{ $errors->first('taxid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('curp') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('curp', __('base/company.entry_curp') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('curp', old('curp'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/company.entry_curp')]) !!}
                                                    @if ($errors->has('curp'))
                                                        <span class="help-block"><small>{{ $errors->first('curp') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('employer_register') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('employer_register', __('base/company.entry_employer_register') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('employer_register', old('employer_register'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/company.entry_employer_register')]) !!}
                                                    @if ($errors->has('employer_register'))
                                                        <span class="help-block"><small>{{ $errors->first('employer_register') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('email', __('base/company.entry_email') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_email')]) !!}
                                                    @if ($errors->has('email'))
                                                        <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('phone', __('base/company.entry_phone') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('phone', old('phone'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_phone')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('phone_mobile', __('base/company.entry_phone_mobile') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('phone_mobile', old('phone_mobile'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_phone_mobile')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('comment', __('base/company.entry_comment') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::textarea('comment', old('comment'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_comment'),'rows' => '2']) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_address"
                                         aria-labelledby="address-tab">
                                        <div class="row">
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_1', __('base/company.entry_address_1') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_1', old('address_1'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_1')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_2', __('base/company.entry_address_2') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_2', old('address_2'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_2')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_3', __('base/company.entry_address_3') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_3', old('address_3'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_3')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_4', __('base/company.entry_address_4') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_4', old('address_4'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_4')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_5', __('base/company.entry_address_5') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_5', old('address_5'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_5')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-8 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('address_6', __('base/company.entry_address_6') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('address_6', old('address_6'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_6')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('country_id', __('base/company.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('state_id', __('base/company.entry_state_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('state_id', [],old('state_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('city_id', __('base/company.entry_city_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('city_id', [],old('city_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('postcode') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('postcode', __('base/company.entry_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('postcode', old('postcode'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_postcode'),'required']) !!}
                                                    @if ($errors->has('postcode'))
                                                        <span class="help-block"><small>{{ $errors->first('postcode') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_files_sat"
                                         aria-labelledby="files-sat-tab">
                                        <div class="row">
                                            <div class="col-md-6 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('file_file_cer_ext') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('file_file_cer', __('base/company.entry_file_cer') . '', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('input_file_cer', old(''), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'readonly','autocomplete'=>'off']) !!}
                                                        <span class="input-group-btn">
                                                            <a href="#" class="btn btn-sm btn-info"
                                                               id="btn_edit_file_cer" title="Editar"><i
                                                                        class="fa fa-pencil"></i></a>
                                                            <a href="#" class="btn btn-sm btn-danger"
                                                               id="btn_delete_file_cer" title="Eliminar"><i
                                                                        class="fa fa-trash-o"></i></a>
                                                        </span>
                                                    </div>
                                                    {!! Form::file('file_file_cer', ['class'=> 'hidden', 'accept' => '.cer']) !!}
                                                    @if ($errors->has('file_file_cer_ext'))
                                                        <span class="help-block"><small>{{ $errors->first('file_file_cer_ext') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('file_file_key_ext') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('file_file_key', __('base/company.entry_file_key') . '', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('input_file_key', old(''), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'readonly','autocomplete'=>'off']) !!}
                                                        <span class="input-group-btn">
                                                            <a href="#" class="btn btn-sm btn-info"
                                                               id="btn_edit_file_key" title="Editar"><i
                                                                        class="fa fa-pencil"></i></a>
                                                            <a href="#" class="btn btn-sm btn-danger"
                                                               id="btn_delete_file_key" title="Eliminar"><i
                                                                        class="fa fa-trash-o"></i></a>
                                                        </span>
                                                    </div>
                                                    {!! Form::file('file_file_key', ['class'=> 'hidden', 'accept' => '.key']) !!}
                                                    @if ($errors->has('file_file_key_ext'))
                                                        <span class="help-block"><small>{{ $errors->first('file_file_key_ext') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('password_key') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('password_key', __('base/company.entry_password_key') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::password('password_key', ['class' => 'form-control', 'placeholder' => __('base/company.entry_password_key')]) !!}
                                                    @if ($errors->has('password_key'))
                                                        <span class="help-block"><small>{{ $errors->first('password_key') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('titular', __('base/company.entry_titular') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('titular', old('titular'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_titular'),'readonly']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('certificate_number', __('base/company.entry_certificate_number') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('certificate_number', old('certificate_number'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_certificate_number'),'readonly']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('date_start', __('base/company.entry_date_start') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('date_start', old('date_start'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_date_start'),'readonly']) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('date_end', __('base/company.entry_date_end') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('date_end', old('date_end'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_date_end'),'readonly']) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_bank_accounts"
                                         aria-labelledby="bank-accounts-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_bank_account">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%"
                                                                class="text-center">@lang('general.column_actions')</th>
                                                            <th width="40%"
                                                                class="text-left">@lang('base/company.column_bank_account_name')</th>
                                                            <th width="15%"
                                                                class="text-center">@lang('base/company.column_bank_account_bank_id')</th>
                                                            <th width="15%"
                                                                class="text-center">@lang('base/company.column_bank_account_currency_id')</th>
                                                            <th width="25%"
                                                                class="text-center">@lang('base/company.column_bank_account_account_number')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_bank_account_row = 1;
                                                            $items_bank_account = old('item_bank_account',[]);
                                                        @endphp
                                                        @foreach ($items_bank_account as $item_bank_account_row => $item)
                                                            @php
                                                                    @endphp
                                                            <tr id="item_bank_account_row_{{ $item_bank_account_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="$('#item_bank_account_row_{{ $item_bank_account_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_bank_account_id_{{ $item_bank_account_row }}"
                                                                           name="item_bank_account[{{ $item_bank_account_row }}][id]"
                                                                           value="{{ old('item_bank_account.' . $item_bank_account_row . '.id') }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.name') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_bank_account[' . $item_bank_account_row . '][name]', old('item_bank_account.' . $item_bank_account_row . '.name'), ['class' => 'form-control input-sm', 'required','id' => 'item_bank_account_name_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.name'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.name') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.bank_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_bank_account[' . $item_bank_account_row . '][bank_id]', $banks,old('item_bank_account.' . $item_bank_account_row . '.bank_id'), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'required','id' => 'item_bank_account_bank_id_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.bank_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.bank_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.currency_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_bank_account[' . $item_bank_account_row . '][currency_id]', $currencies,old('item_bank_account.' . $item_bank_account_row . '.currency_id'), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'required','id' => 'item_bank_account_currency_id_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.currency_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.currency_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_bank_account.'.$item_bank_account_row.'.account_number') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_bank_account[' . $item_bank_account_row . '][account_number]', old('item_bank_account.' . $item_bank_account_row . '.account_number'), ['class' => 'form-control input-sm text-center', 'required','id' => 'item_bank_account_account_number_' . $item_bank_account_row]) !!}
                                                                        @if ($errors->has('item_bank_account.'.$item_bank_account_row.'.account_number'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_bank_account.'.$item_bank_account_row.'.account_number') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_bank_account_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_bank_account">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemBankAccount();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="4"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                    <!--&nbsp;&nbsp;&nbsp;
                                    <a href="{{route('companies.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>-->
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        var item_bank_account_row = "{{ $item_bank_account_row }}";

        function addItemBankAccount() {
            var html = '';

            html += '<tr id="item_bank_account_row_' + item_bank_account_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_bank_account_row_' + item_bank_account_row + '\').remove();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_bank_account[' + item_bank_account_row + '][id]" id="item_bank_account_id_' + item_bank_account_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm" name="item_bank_account[' + item_bank_account_row + '][name]" id="item_bank_account_name_' + item_bank_account_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm" name="item_bank_account[' + item_bank_account_row + '][bank_id]" id="item_bank_account_bank_id_' + item_bank_account_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($banks as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
                html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm" name="item_bank_account[' + item_bank_account_row + '][currency_id]" id="item_bank_account_currency_id_' + item_bank_account_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            @foreach($currencies as $key => $value)
                html += '<option value="{{ $key }}">{{ $value }}</option>';
            @endforeach
                html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center" name="item_bank_account[' + item_bank_account_row + '][account_number]" id="item_bank_account_account_number_' + item_bank_account_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_bank_account tbody #add_item_bank_account").before(html);

            item_bank_account_row++;
        }

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });

            /*File de imagen*/
            $("#form #btn_edit_image").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_image']").trigger('click');
            });
            $("#form #btn_delete_image").on("click", function (e) {
                e.preventDefault();
                $("#form #img_image").attr('src', $("#form #img_image").attr('data-placeholder'));
                $("#form input[name='image']").val('');
            });
            $("#form input[name='file_image']").on("change", function () { //Precarga imagen para visualizar
                if ($(this)[0].files && $(this)[0].files[0]) {
                    let reader = new FileReader();
                    reader.onload = function (e) {
                        $("#img_image").attr("src", e.target.result);
                    };
                    reader.readAsDataURL($(this)[0].files[0]);
                }
            });

            /*File de cer*/
            $("#form #btn_edit_file_cer").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_file_cer']").trigger('click');
            });
            $("#form #btn_delete_file_cer").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_cer']").val('');
                $("#form input[name='input_file_cer']").val('');
            });
            $("#form input[name='file_file_cer']").on("change", function () {
                if ($(this)[0].files && $(this)[0].files[0]) {
                    $("#form input[name='input_file_cer']").val($(this)[0].files[0].name);
                }
            });

            /*File de key*/
            $("#form #btn_edit_file_key").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_file_key']").trigger('click');
            });
            $("#form #btn_delete_file_key").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_key']").val('');
                $("#form input[name='input_file_key']").val('');
            });
            $("#form input[name='file_file_key']").on("change", function () {
                if ($(this)[0].files && $(this)[0].files[0]) {
                    $("#form input[name='input_file_key']").val($(this)[0].files[0].name);
                }
            });

            /* Selecciona pais */
            $("#form select[name='country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{ old('state_id') }}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");

            /* Selecciona estado */
            $("#form select[name='state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{ old('city_id') }}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

        });

    </script>
@endsection
