@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/diot.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/diot.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('diots.index')}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'diots.store','method' => 'POST','class' => '','role' => 'form','id'=>'form']) !!}
                            <!-- input hidden -->
                            {!! Form::hidden('key', old('key','')) !!}
                            <input name="file_template_file" type="file" class="hidden"/>
                            <!-- /.input hidden -->
                            <div class="row mb-0">
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('name', __('base/diot.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/diot.help_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('year') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('year', __('base/diot.entry_year') . ' <span class="required text-danger">*</span>' , ['class' => 'control-label'])) !!}
                                        {!! Form::select('year', $years,request()->input('year',\Date::now()->format('Y')), ['class' => 'form-control','required']) !!}
                                        @if ($errors->has('year'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('month') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('month', __('base/diot.entry_month') . ' <span class="required text-danger">*</span>' , ['class' => 'control-label'])) !!}
                                        {!! Form::select('month', $months,request()->input('month',''), ['class' => 'form-control','required']) !!}
                                        @if ($errors->has('month'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="table-responsive" id="data_cfdi_downloads"
                                                 style="max-height: 700px; border: 1px solid #eeeeee; overflow-y: auto;">
                                        <table class="table table-items table-striped table-hover table-condensed" style="min-width: 1900px;">
                                            <thead>
                                            <tr class="mini">
                                                <th class="text-center" style="width: 30px;"></th>
                                                <th class="text-center" style="width: 120px;">@lang('base/diot.column_line_customer_type')</th>
                                                <th class="text-center" style="width: 120px;">@lang('base/diot.column_line_operation_type')</th>
                                                <th class="text-center" style="width: 120px;">@lang('base/diot.column_line_taxid')</th>
                                                <th class="text-center" style="width: 90px;">@lang('base/diot.column_line_numid')</th>
                                                <th class="text-center">@lang('base/diot.column_line_name')</th>
                                                <th class="text-left" style="width: 25px;"></th>
                                                <th class="text-center" style="width: 160px;">@lang('base/diot.column_line_foreign_country_code')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_foreign_nationality')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_iva_15_16')</th>
                                                <th class="text-center hidden">@lang('base/diot.column_line_iva_15')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_iva_15_16_not')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_iva_10_11')</th>
                                                <th class="text-center hidden">@lang('base/diot.column_line_iva_10')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_iva_10_11_not')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_border_stimulation')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_border_stimulation_not')</th>
                                                <!--<th class="text-center">@lang('base/diot.column_line_foreign_iva_15_16')</th>
                                                <th class="text-left">@lang('base/diot.column_line_foreign_iva_15_16_not')</th>
                                                <th class="text-center">@lang('base/diot.column_line_foreign_iva_10_11')</th>
                                                <th class="text-center">@lang('base/diot.column_line_foreign_iva_10_11_not')</th>
                                                <th class="text-center">@lang('base/diot.column_line_foreign_exempt')</th>-->
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_iva_0')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_exempt')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_iva_detained')</th>
                                                <th class="text-center" style="width: 85px;">@lang('base/diot.column_line_iva_dev_dis_bon')</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                            </div>
                            <div class="row mt-5">
                                <div class="col-md-12 col-xs-12 text-right">
                                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary',]) !!}
                                </div>
                            </div>
                            {!! Form::close() !!}

                            <!-- Footer form -->
                            <!-- /Footer form -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        var item_row = 0;

        function addItem() {
            $.ajax({
                url: "{{ route('diots/add-cfdi-downloads') }}",
                type: "GET",
                dataType: "JSON",
                data: "item_row=" + item_row,
                success: function (data) {
                    if (data.html) {
                        $("#form #data_cfdi_downloads tbody #add_item ").before(data.html);
                        item_row++;
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        }

        $(function () {
            $("#form select[name='year'], #form select[name='month']").on("change", function () {
                let year = $("#form select[name='year']").val();
                let month = $("#form select[name='month']").val();
                $("#form #data_cfdi_downloads tbody").html("");
                if(year && month){
                    $.ajax({
                        url: "{{ route('diots/data-cfdi-downloads') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "year=" + year + "&month=" + month + "",
                        success: function (data) {
                            if (data.html) {
                                $("#form #data_cfdi_downloads tbody").html(data.html);
                                item_row = data.item_row;
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
        });

    </script>
@endsection
