<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$diot->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 150px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($diot->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($diot->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -120px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ __('base/diot.document_title') }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 0px;">
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($diot->company_id) }}" class="invoice-logo" width="100px"/>
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span class="text-primary">{{ $diot->name }} / {{ $diot->year }} / {{ $months[$diot->month+1] ?? '' }}</span><br>
                <span class="">{{ $diot->company->name }}</span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">

            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if(!$diot->status)
<section class="watermark" style="bottom: 640px !important;">
    <span>@lang('general.text_canceled')</span>
</section>
@endif
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th>{!! mb_strtoupper(__('base/diot.column_line_operation_type')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_iva_15_16')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_iva_15_16_not')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_iva_10_11')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_iva_10_11_not')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_border_stimulation')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_border_stimulation_not')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_iva_0')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_exempt')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_iva_detained')) !!}</th>
            <th>{!! mb_strtoupper(__('base/diot.column_line_iva_dev_dis_bon')) !!}</th>
        </tr>
        </thead>
        <tbody>
            @foreach($diot_line_grouped as $result)
            <tr>
                <td class="text-left" colspan="12">
                    [{{$result->first()->taxid}}] {{$result->first()->name}}<br/>
                    {{$diot_customer_types[$result->first()->customer_type] ?? ''}}
                    @if($result->first()->customer_type == '05')
                    {{$result->first()->numid}} / {{$diot_countries[$result->first()->foreign_country_code] ?? ''}} / {{$result->first()->foreign_nationality}}
                    @endif
                </td>
            </tr>
            @foreach($result as $result2)
                <tr>
                    <td class="text-center">{{$diot_operation_types[$result2->operation_type] ?? ''}}</td>
                    <td class="text-right">{{money($result2->iva_15_16,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->iva_15_16_not,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->iva_10_11,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->iva_10_11_not,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->border_stimulation,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->border_stimulation_not,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->iva_0,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->exempt,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->iva_detained,'MXN',true)}}</td>
                    <td class="text-right">{{money($result2->iva_dev_dis_bon,'MXN',true)}}</td>
                </tr>
            @endforeach
                <tr>
                    <td class="text-center"></td>
                    <td class="text-right"><b>{{money($result->sum('iva_15_16'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('iva_15_16_not'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('iva_10_11'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('iva_10_11_not'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('border_stimulation'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('border_stimulation_not'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('iva_0'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('exempt'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('iva_detained'),'MXN',true)}}</b></td>
                    <td class="text-right"><b>{{money($result->sum('iva_dev_dis_bon'),'MXN',true)}}</b></td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>

        </tfoot>
    </table>
    </div>
</section>
</body>
</html>
