@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/employee_payroll.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/employee_payroll.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('employee-payrolls.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'employee-payrolls.store','method' => 'POST','class' => '','role' => 'form','id'=>'form']) !!}
                            <!-- input hidden -->
                            {!! Form::hidden('amount_total_tmp', old('amount_total_tmp',0)) !!}
                            <!-- /.input hidden -->
                            <div class="row">
                                @if($tax_regimens->isNotEmpty())
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                                            {!! html_entity_decode(Form::label('tax_regimen_id', __('base/employee_payroll.entry_tax_regimen_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('tax_regimen_id', $tax_regimens,old('tax_regimen_id',($duplicate_ep->employee_id ?? \App\Helpers\Helper::defaultCompany()->tax_regimen_id)), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                            @if ($errors->has('tax_regimen_id'))
                                                <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('employee_id') ? ' has-error' : '' }}">
                                        @php
                                            $tmp_employees = [];
                                            if(!empty(old('employee_id', ($duplicate_ep->employee_id ?? '')))){
                                                $tmp_employees = \App\Models\Base\Employee::where('id','=',old('employee_id', ($duplicate_ep->employee_id ?? '')))->get()->pluck('text_select2','id');
                                            }
                                        @endphp
                                        {!! html_entity_decode(Form::label('employee_id', __('base/employee_payroll.entry_employee_id')  . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::select('employee_id', $tmp_employees, old('employee_id', ($duplicate_ep->employee_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required','autofocus']) !!}
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-info btn-employee-search"><i class="fa fa-search"></i></button>
                                            </span>
                                        </div>
                                        @if ($errors->has('employee_id'))
                                            <span class="help-block"><small>{{ $errors->first('employee_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('tax_regimen_employee_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('tax_regimen_employee_id', __('base/employee_payroll.entry_tax_regimen_employee_id') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::select('tax_regimen_employee_id', $tax_regimen_employees,old('tax_regimen_employee_id', ($duplicate_ep->tax_regimen_employee_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        @if ($errors->has('tax_regimen_employee_id'))
                                            <span class="help-block"><small>{{ $errors->first('tax_regimen_employee_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="row">
                                        <div class="col-md-6 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('payroll_type_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('payroll_type_id', __('base/employee_payroll.entry_payroll_type_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::select('payroll_type_id', $payroll_types,old('payroll_type_id', ($duplicate_ep->payroll_type_id ?? '')), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                @if ($errors->has('payroll_type_id'))
                                                    <span class="help-block"><small>{{ $errors->first('payroll_type_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('branch_office_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('branch_office_id', __('base/employee_payroll.entry_branch_office_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::select('branch_office_id', $branch_offices,old('branch_office_id',($duplicate_ep->branch_office_id ?? \App\Models\Base\BranchOffice::where('company_id','=',\App\Helpers\Helper::defaultCompany()->id)->get()->first()->id)), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                @if ($errors->has('branch_office_id'))
                                                    <span class="help-block"><small>{{ $errors->first('branch_office_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('date_payment') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('date_payment', __('base/employee_payroll.entry_date_payment') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('date_payment', old('date_payment',\App\Helpers\Helper::date(Date::now())), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_date_payment'),'required','autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('date_payment'))
                                            <span class="help-block"><small>{{ $errors->first('date_payment') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('date_start_payment') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('date_start_payment', __('base/employee_payroll.entry_date_start_payment') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('date_start_payment', old('date_start_payment'), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_date_start_payment'),'required','autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('date_start_payment'))
                                            <span class="help-block"><small>{{ $errors->first('date_start_payment') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('date_end_payment') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('date_end_payment', __('base/employee_payroll.entry_date_end_payment') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('date_end_payment', old('date_end_payment'), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_date_end_payment'),'required','autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('date_end_payment'))
                                            <span class="help-block"><small>{{ $errors->first('date_end_payment') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('payment_days') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('payment_days', __('base/employee_payroll.entry_payment_days') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::number('payment_days', old('payment_days'), ['class' => 'form-control text-center', 'placeholder' => __('base/employee_payroll.entry_payment_days'),'required']) !!}
                                        @if ($errors->has('payment_days'))
                                            <span class="help-block"><small>{{ $errors->first('payment_days') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('taxid_origin', __('base/employee_payroll.entry_taxid_origin') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('taxid_origin', old('taxid_origin', ($duplicate_ep->taxid_origin ?? '')), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_taxid_origin')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-9 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('reference', __('base/employee_payroll.entry_reference') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('reference', old('reference',($duplicate_ep->reference ?? __('base/employee_payroll.text_reference'))), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_reference')]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="well alert-important" style="margin: 10px 0 10px 0; padding: 6px 19px;">
                                        <p class="text-center" style="margin: 0;">
                                            @lang('base/employee_payroll.entry_amount_untaxed'): <span id="txt_amount_untaxed"></span>
                                            &nbsp;&nbsp;&nbsp;
                                            @lang('base/employee_payroll.entry_amount_discount'): <span id="txt_amount_discount"></span>
                                            &nbsp;&nbsp;&nbsp;
                                            @lang('base/employee_payroll.entry_amount_isr'): <span id="txt_amount_isr"></span>
                                            &nbsp;&nbsp;&nbsp;
                                            <b>@lang('base/employee_payroll.entry_amount_total'): <span id="txt_amount_total"></span></b>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('item') ? ' has-error' : '' }}"
                                         style="margin-top: 20px;">
                                        @if ($errors->has('item'))
                                            <span class="help-block"><small>{{ $errors->first('item') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_perceptions" id="perceptions-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/employee_payroll.tab_perceptions')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_deductions" id="deductions-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/employee_payroll.tab_deductions')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_other_payment_types" id="other-payment-types-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/employee_payroll.tab_other_payment_types')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_outsourcing" id="outsourcing-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/employee_payroll.tab_outsourcing')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_retirement" id="retirement-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/employee_payroll.tab_retirement')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_separation" id="separation-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/employee_payroll.tab_separation')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_disabilities" id="disabilities-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/employee_payroll.tab_disabilities')</a>
                                    </li>
                                    <li role="sncf" class="">
                                        <a href="#tab_sncf" id="sncf-tab" role="tab"
                                           data-toggle="tab"
                                           aria-expanded="false">@lang('base/employee_payroll.tab_sncf')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_relations" id="relations-tab" role="tab"
                                           data-toggle="tab"
                                           aria-expanded="false">@lang('base/employee_payroll.tab_relations')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade active in" id="tab_perceptions"
                                         aria-labelledby="perceptions-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_perception">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%" class="text-center">
                                                                @lang('general.column_actions')
                                                            </th>
                                                            <th width="" class="text-center">
                                                                @lang('base/employee_payroll.column_line_perception_id')
                                                            </th>
                                                            <th width="15%" class="text-center">@lang('base/employee_payroll.column_line_code')</th>
                                                            <th width="15%" class="text-center">@lang('base/employee_payroll.column_line_amount_taxed')</th>
                                                            <th width="15%" class="text-center">@lang('base/employee_payroll.column_line_amount_exempt')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_perception_row = 1;
                                                            $items_perception = old('item_perception',($duplicate_ep->employeeActivePerceptionsPayrollLines ?? []));
                                                        @endphp
                                                        @foreach ($items_perception as $item_perception_row => $item)
                                                            @php
                                                                $item = !empty(old('item_perception.' . $item_perception_row . '')) ? (object) old('item_perception.' . $item_perception_row) : $item;

                                                                $tmp_perceptions = [];
                                                                $perception_code = '';
                                                                if(!empty(old('item_perception.' . $item_perception_row . '.perception_id',$item->perception_id))){
                                                                    $tmp_perceptions = \App\Models\Catalogs\Perception::where('id','=',old('item_perception.' . $item_perception_row . '.perception_id',$item->perception_id))->get();
                                                                    $perception_code = !empty($tmp_perceptions->first()) ? $tmp_perceptions->first()->code : '';
                                                                    $tmp_perceptions = $tmp_perceptions->pluck('description_select2','id');
                                                                }
                                                                $tmp_overtimes_type_1 = \App\Models\Catalogs\OvertimesType::where('code', '=', '01')->first();
                                                                $tmp_overtimes_type_2 = \App\Models\Catalogs\OvertimesType::where('code', '=', '02')->first();
                                                                $tmp_overtimes_type_3 = \App\Models\Catalogs\OvertimesType::where('code', '=', '03')->first();
                                                            @endphp
                                                            <tr id="item_perception_row_{{ $item_perception_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="$('#item_perception_row_{{ $item_perception_row }}').remove(); totalItem();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_perception_id_{{ $item_perception_row }}"
                                                                           name="item_perception[{{ $item_perception_row }}][id]"
                                                                           value="{{ old('item_perception.' . $item_perception_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.perception_id') ? ' has-error' : '' }}">
                                                                        <div class="input-group input-group-sm">
                                                                            {!! Form::select('item_perception[' . $item_perception_row . '][perception_id]', $tmp_perceptions,old('item_perception.' . $item_perception_row . '.perception_id',$item->perception_id), ['class' => 'form-control input-sm col-perception-id', 'placeholder' => __('general.text_select'),'required','id' => 'item_perception_perception_id_' . $item_perception_row]) !!}
                                                                            <span class="input-group-btn">
                                                                                <button type="button" class="btn btn-info btn-perception-search" data-row="{{ $item_perception_row }}"><i class="fa fa-search"></i></button>
                                                                            </span>
                                                                        </div>
                                                                        @if ($errors->has('item_perception.'.$item_perception_row.'.perception_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.perception_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                    <div class="{{ $perception_code != '045' ? 'hidden' : '' }}" id="accions_{{$item_perception_row}}">
                                                                        <div class="row">
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.ac_market_value') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][ac_market_value]', old('item_perception.' . $item_perception_row . '.ac_market_value',round($item->ac_market_value,2)), ['class' => 'form-control input-sm text-right col-ac-market-value','id' => 'item_perception_ac_market_value_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_ac_market_value'), 'step' => 'any']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.ac_market_value'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.ac_market_value') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.ac_price_when_granted') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][ac_price_when_granted]', old('item_perception.' . $item_perception_row . '.ac_price_when_granted',round($item->ac_price_when_granted,2)), ['class' => 'form-control input-sm text-right col-ac-price-when-granted','id' => 'item_perception_ac_price_when_granted_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_ac_price_when_granted'), 'step' => 'any']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.ac_price_when_granted'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.ac_price_when_granted') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="{{ $perception_code != '019' ? 'hidden' : '' }}" id="hours_{{$item_perception_row}}">
                                                                        <div class="row">
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_days_1') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_days_1]', old('item_perception.' . $item_perception_row . '.hr_days_1',round($item->hr_days_1,2)), ['class' => 'form-control input-sm text-center col-hr-days-1','id' => 'item_perception_hr_days_1_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_days')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_days_1'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_days_1') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_1') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::hidden('item_perception[' . $item_perception_row . '][hr_overtimes_type_id_1]', $tmp_overtimes_type_1->id, ['class' => 'form-control input-sm text-center col-hr-overtimes-type-id-1','id' => 'item_perception_hr_overtimes_type_id_1_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_overtimes_type_id')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_1'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_1') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_1') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::text('item_perception[' . $item_perception_row . '][hr_overtimes_type_1]', $tmp_overtimes_type_1->code . '-' . $tmp_overtimes_type_1->name, ['class' => 'form-control input-sm text-center col-hr-overtimes-type-1','id' => 'item_perception_hr_overtimes_type_1_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_overtimes_type_id'), 'readonly' => 'readonly']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_1'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_overtimes_type_1') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_hours_1') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_hours_1]', old('item_perception.' . $item_perception_row . '.hr_hours_1',round($item->hr_hours_1,2)), ['class' => 'form-control input-sm text-center col-hr-hours-1','id' => 'item_perception_hr_hours_1_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_hours')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_hours_1'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_hours_1') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_amount_paid_1') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_amount_paid_1]', old('item_perception.' . $item_perception_row . '.hr_amount_paid_1',round($item->hr_amount_paid_1,2)), ['class' => 'form-control input-sm text-right col-hr-amount-paid-1','id' => 'item_perception_hr_amount_paid_1_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_amount_paid'), 'step' => 'any']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_amount_paid_1'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_amount_paid_1') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="row">
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_days_2') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_days_2]', old('item_perception.' . $item_perception_row . '.hr_days_2',round($item->hr_days_2,2)), ['class' => 'form-control input-sm text-center col-hr-days-2','id' => 'item_perception_hr_days_2_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_days')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_days_2'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_days_2') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_2') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::hidden('item_perception[' . $item_perception_row . '][hr_overtimes_type_id_2]', $tmp_overtimes_type_2->id, ['class' => 'form-control input-sm text-center col-hr-overtimes-type-id-2','id' => 'item_perception_hr_overtimes_type_id_2_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_overtimes_type_id')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_2'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_2') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_2') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::text('item_perception[' . $item_perception_row . '][hr_overtimes_type_2]', $tmp_overtimes_type_2->code . '-' . $tmp_overtimes_type_2->name, ['class' => 'form-control input-sm text-center col-hr-overtimes-type-2','id' => 'item_perception_hr_overtimes_type_2_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_overtimes_type_id'), 'readonly' => 'readonly']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_2'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_overtimes_type_2') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_hours_2') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_hours_2]', old('item_perception.' . $item_perception_row . '.hr_hours_2',round($item->hr_hours_2,2)), ['class' => 'form-control input-sm text-center col-hr-hours-2','id' => 'item_perception_hr_hours_2_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_hours')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_hours_2'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_hours_2') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_amount_paid_2') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_amount_paid_2]', old('item_perception.' . $item_perception_row . '.hr_amount_paid_2',round($item->hr_amount_paid_2,2)), ['class' => 'form-control input-sm text-right col-hr-amount-paid-2','id' => 'item_perception_hr_amount_paid_2_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_amount_paid'), 'step' => 'any']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_amount_paid_2'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_amount_paid_2') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="row">
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_days_3') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_days_3]', old('item_perception.' . $item_perception_row . '.hr_days_3',round($item->hr_days_3,2)), ['class' => 'form-control input-sm text-center col-hr-days-3','id' => 'item_perception_hr_days_3_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_days')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_days_3'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_days_3') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_3') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::hidden('item_perception[' . $item_perception_row . '][hr_overtimes_type_id_3]', $tmp_overtimes_type_3->id, ['class' => 'form-control input-sm text-center col-hr-overtimes-type-id-3','id' => 'item_perception_hr_overtimes_type_id_3_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_overtimes_type_id')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_3'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_overtimes_type_id_3') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_3') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::text('item_perception[' . $item_perception_row . '][hr_overtimes_type_3]', $tmp_overtimes_type_3->code . '-' . $tmp_overtimes_type_3->name, ['class' => 'form-control input-sm text-center col-hr-overtimes-type-3','id' => 'item_perception_hr_overtimes_type_3_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_overtimes_type_id'), 'readonly' => 'readonly']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_overtimes_type_3'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_overtimes_type_3') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_hours_3') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_hours_3]', old('item_perception.' . $item_perception_row . '.hr_hours_3',round($item->hr_hours_3,2)), ['class' => 'form-control input-sm text-center col-hr-hours-3','id' => 'item_perception_hr_hours_3_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_hours')]) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_hours_3'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_hours_3') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.hr_amount_paid_3') ? ' has-error' : '' }} mt-2">
                                                                                    {!! Form::number('item_perception[' . $item_perception_row . '][hr_amount_paid_3]', old('item_perception.' . $item_perception_row . '.hr_amount_paid_3',round($item->hr_amount_paid_3,2)), ['class' => 'form-control input-sm text-right col-hr-amount-paid-3','id' => 'item_perception_hr_amount_paid_3_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_hr_amount_paid'), 'step' => 'any']) !!}
                                                                                    @if ($errors->has('item_perception.'.$item_perception_row.'.hr_amount_paid_3'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.hr_amount_paid_3') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.code') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_perception[' . $item_perception_row . '][code]', old('item_perception.' . $item_perception_row . '.code',$item->code), ['class' => 'form-control input-sm text-center col-code','id' => 'item_perception_code_' . $item_perception_row, 'placeholder' => __('base/employee_payroll.column_line_code')]) !!}
                                                                        @if ($errors->has('item_perception.'.$item_perception_row.'.code'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.code') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.amount_taxed') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_perception[' . $item_perception_row . '][amount_taxed]', old('item_perception.' . $item_perception_row . '.amount_taxed',round($item->amount_taxed,2)), ['class' => 'form-control input-sm text-right col-amount-taxed','id' => 'item_perception_amount_taxed_' . $item_perception_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_perception.'.$item_perception_row.'.amount_taxed'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.amount_taxed') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_perception.'.$item_perception_row.'.amount_exempt') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_perception[' . $item_perception_row . '][amount_exempt]', old('item_perception.' . $item_perception_row . '.amount_exempt',round($item->amount_exempt,2)), ['class' => 'form-control input-sm text-right col-amount-exempt','id' => 'item_perception_amount_exempt_' . $item_perception_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_perception.'.$item_perception_row.'.amount_exempt'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_perception.'.$item_perception_row.'.amount_exempt') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_perception_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_perception">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemPerception();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="4"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_deductions"
                                         aria-labelledby="deductions-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_deduction">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%" class="text-center">
                                                                @lang('general.column_actions')
                                                            </th>
                                                            <th width="" class="text-center">
                                                                @lang('base/employee_payroll.column_line_deduction_id')
                                                            </th>
                                                            <th width="20%" class="text-center">@lang('base/employee_payroll.column_line_code')</th>
                                                            <th width="20%" class="text-center">@lang('base/employee_payroll.column_line_amount_total')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_deduction_row = 1;
                                                            $items_deduction = old('item_deduction',($duplicate_ep->employeeActiveDeductionsPayrollLines ?? []));
                                                        @endphp
                                                        @foreach ($items_deduction as $item_deduction_row => $item)
                                                            @php
                                                                $item = !empty(old('item_deduction.' . $item_deduction_row . '')) ? (object) old('item_deduction.' . $item_deduction_row) : $item;

                                                                $tmp_deductions = [];
                                                                if(!empty(old('item_deduction.' . $item_deduction_row . '.deduction_id',$item->deduction_id))){
                                                                    $tmp_deductions = \App\Models\Catalogs\Deduction::where('id','=',old('item_deduction.' . $item_deduction_row . '.deduction_id',$item->deduction_id))->get()->pluck('description_select2','id');
                                                                }
                                                            @endphp
                                                            <tr id="item_deduction_row_{{ $item_deduction_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="$('#item_deduction_row_{{ $item_deduction_row }}').remove(); totalItem();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_deduction_id_{{ $item_deduction_row }}"
                                                                           name="item_deduction[{{ $item_deduction_row }}][id]"
                                                                           value="{{ old('item_deduction.' . $item_deduction_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_deduction.'.$item_deduction_row.'.deduction_id') ? ' has-error' : '' }}">
                                                                        <div class="input-group input-group-sm">
                                                                            {!! Form::select('item_deduction[' . $item_deduction_row . '][deduction_id]', $tmp_deductions,old('item_deduction.' . $item_deduction_row . '.deduction_id',$item->deduction_id), ['class' => 'form-control input-sm col-deduction-id', 'placeholder' => __('general.text_select'),'required','id' => 'item_deduction_deduction_id_' . $item_deduction_row]) !!}
                                                                            <span class="input-group-btn">
                                                                                <button type="button" class="btn btn-info btn-deduction-search" data-row="{{ $item_deduction_row }}"><i class="fa fa-search"></i></button>
                                                                            </span>
                                                                        </div>
                                                                        @if ($errors->has('item_deduction.'.$item_deduction_row.'.deduction_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_deduction.'.$item_deduction_row.'.deduction_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_deduction.'.$item_deduction_row.'.code') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_deduction[' . $item_deduction_row . '][code]', old('item_deduction.' . $item_deduction_row . '.code',$item->code), ['class' => 'form-control input-sm text-center col-code','id' => 'item_deduction_code_' . $item_deduction_row, 'placeholder' => __('base/employee_payroll.column_line_code')]) !!}
                                                                        @if ($errors->has('item_deduction.'.$item_deduction_row.'.code'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_deduction.'.$item_deduction_row.'.code') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_deduction.'.$item_deduction_row.'.amount_total') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_deduction[' . $item_deduction_row . '][amount_total]', old('item_deduction.' . $item_deduction_row . '.amount_total', round($item->amount_total,2)), ['class' => 'form-control input-sm text-right col-amount-total','id' => 'item_deduction_amount_total_' . $item_deduction_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_deduction.'.$item_deduction_row.'.amount_total'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_deduction.'.$item_deduction_row.'.amount_total') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_deduction_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_deduction">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemDeduction();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="3"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_other_payment_types"
                                         aria-labelledby="other-payment-types-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_other_payment_type">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%" class="text-center">
                                                                @lang('general.column_actions')
                                                            </th>
                                                            <th width="" class="text-center">
                                                                @lang('base/employee_payroll.column_line_other_payment_type_id')
                                                            </th>
                                                            <th width="15%" class="text-center">@lang('base/employee_payroll.column_line_code')</th>
                                                            <th width="15%" class="text-center">@lang('base/employee_payroll.column_line_amount_total')</th>
                                                            <th width="15%" class="text-center">@lang('base/employee_payroll.column_line_amount_caused')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_other_payment_type_row = 1;
                                                            $items_other_payment_type = old('item_other_payment_type',($duplicate_ep->employeeActiveOtherPaymentTypesPayrollLines ?? []));
                                                        @endphp
                                                        @foreach ($items_other_payment_type as $item_other_payment_type_row => $item)
                                                            @php
                                                                $item = !empty(old('item_other_payment_type.' . $item_other_payment_type_row . '')) ? (object) old('item_other_payment_type.' . $item_other_payment_type_row) : $item;

                                                                $tmp_other_payment_types = [];
                                                                $other_payment_type_code = '';
                                                                if(!empty(old('item_other_payment_type.' . $item_other_payment_type_row . '.other_payment_type_id',$item->other_payment_type_id))){
                                                                    $tmp_other_payment_types = \App\Models\Catalogs\OtherPaymentType::where('id','=',old('item_other_payment_type.' . $item_other_payment_type_row . '.other_payment_type_id',$item->other_payment_type_id))->get();
                                                                    $other_payment_type_code = !empty($tmp_other_payment_types->first()) ? $tmp_other_payment_types->first()->code : '';
                                                                    $tmp_other_payment_types = $tmp_other_payment_types->pluck('description_select2','id');
                                                                }
                                                            @endphp
                                                            <tr id="item_other_payment_type_row_{{ $item_other_payment_type_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="$('#item_other_payment_type_row_{{ $item_other_payment_type_row }}').remove(); totalItem();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_other_payment_type_id_{{ $item_other_payment_type_row }}"
                                                                           name="item_other_payment_type[{{ $item_other_payment_type_row }}][id]"
                                                                           value="{{ old('item_other_payment_type.' . $item_other_payment_type_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.other_payment_type_id') ? ' has-error' : '' }}">
                                                                        <div class="input-group input-group-sm">
                                                                            {!! Form::select('item_other_payment_type[' . $item_other_payment_type_row . '][other_payment_type_id]', $tmp_other_payment_types,old('item_other_payment_type.' . $item_other_payment_type_row . '.other_payment_type_id',$item->other_payment_type_id), ['class' => 'form-control input-sm col-other-payment-type-id', 'placeholder' => __('general.text_select'),'required','id' => 'item_other_payment_type_other_payment_type_id_' . $item_other_payment_type_row]) !!}
                                                                            <span class="input-group-btn">
                                                                                <button type="button" class="btn btn-info btn-other-payment-type-search" data-row="{{ $item_other_payment_type_row }}"><i class="fa fa-search"></i></button>
                                                                            </span>
                                                                        </div>
                                                                        @if ($errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.other_payment_type_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_other_payment_type.'.$item_other_payment_type_row.'.other_payment_type_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                    <div class="{{ $other_payment_type_code != '004' ? 'hidden' : '' }}" id="compensation_{{$item_other_payment_type_row}}">
                                                                        <div class="row">
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.cm_positive_balance') ? ' has-error' : '' }}">
                                                                                    {!! Form::number('item_other_payment_type[' . $item_other_payment_type_row . '][cm_positive_balance]', old('item_other_payment_type.' . $item_other_payment_type_row . '.cm_positive_balance',$item->cm_positive_balance ?? ''), ['class' => 'form-control input-sm text-right col-cm-positive-balance','id' => 'item_other_payment_type_cm_positive_balance_' . $item_other_payment_type_row, 'placeholder' => __('base/employee_payroll.column_line_cm_positive_balance'), 'step' => 'any']) !!}
                                                                                    @if ($errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.cm_positive_balance'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_other_payment_type.'.$item_other_payment_type_row.'.cm_positive_balance') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.cm_year') ? ' has-error' : '' }}">
                                                                                    {!! Form::number('item_other_payment_type[' . $item_other_payment_type_row . '][cm_year]', old('item_other_payment_type.' . $item_other_payment_type_row . '.cm_year',$item->cm_year ?? ''), ['class' => 'form-control input-sm text-center col-cm-year','id' => 'item_other_payment_type_cm_year_' . $item_other_payment_type_row, 'placeholder' => __('base/employee_payroll.column_line_cm_year')]) !!}
                                                                                    @if ($errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.cm_year'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_other_payment_type.'.$item_other_payment_type_row.'.cm_year') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-3 col-xs-12">
                                                                                <div class="form-group form-group-sm{{ $errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.cm_remainder') ? ' has-error' : '' }}">
                                                                                    {!! Form::number('item_other_payment_type[' . $item_other_payment_type_row . '][cm_remainder]', old('item_other_payment_type.' . $item_other_payment_type_row . '.cm_remainder',$item->cm_remainder ?? ''), ['class' => 'form-control input-sm text-right col-cm-remainder','id' => 'item_other_payment_type_cm_remainder_' . $item_other_payment_type_row, 'placeholder' => __('base/employee_payroll.column_line_cm_remainder'), 'step' => 'any']) !!}
                                                                                    @if ($errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.cm_remainder'))
                                                                                        <span class="help-block"><small>{{ $errors->first('item_other_payment_type.'.$item_other_payment_type_row.'.cm_remainder') }}</small></span>
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.code') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_other_payment_type[' . $item_other_payment_type_row . '][code]', old('item_other_payment_type.' . $item_other_payment_type_row . '.code',$item->code), ['class' => 'form-control input-sm text-center col-code','id' => 'item_other_payment_type_code_' . $item_other_payment_type_row, 'placeholder' => __('base/employee_payroll.column_line_code')]) !!}
                                                                        @if ($errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.code'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_other_payment_type.'.$item_other_payment_type_row.'.code') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.amount_total') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_other_payment_type[' . $item_other_payment_type_row . '][amount_total]', old('item_other_payment_type.' . $item_other_payment_type_row . '.amount_total',round($item->amount_total,2)), ['class' => 'form-control input-sm text-right col-amount-total','id' => 'item_other_payment_type_amount_total_' . $item_other_payment_type_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.amount_total'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_other_payment_type.'.$item_other_payment_type_row.'.amount_total') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.amount_caused') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_other_payment_type[' . $item_other_payment_type_row . '][amount_caused]', old('item_other_payment_type.' . $item_other_payment_type_row . '.amount_caused',round($item->amount_caused,2)), ['class' => 'form-control input-sm text-right col-amount-caused','id' => 'item_other_payment_type_amount_caused_' . $item_other_payment_type_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_other_payment_type.'.$item_other_payment_type_row.'.amount_caused'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_other_payment_type.'.$item_other_payment_type_row.'.amount_caused') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_other_payment_type_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_other_payment_type">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemOtherPaymentType();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="4"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_outsourcing"
                                         aria-labelledby="outsourcing-tab">
                                        <div class="row">
                                            <div class="col-md-6 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_outsourcing">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%" class="text-center">
                                                                @lang('general.column_actions')
                                                            </th>
                                                            <th class="text-center">
                                                                @lang('base/employee_payroll.column_line_taxid')
                                                            </th>
                                                            <th class="text-center">@lang('base/employee_payroll.column_line_percent_time')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_outsourcing_row = 1;
                                                            $items_outsourcing = old('item_outsourcing',($duplicate_ep->employeeActivePayrollOutsourcings ?? []));
                                                        @endphp
                                                        @foreach ($items_outsourcing as $item_outsourcing_row => $item)
                                                            @php
                                                            $item = !empty(old('item_outsourcing.' . $item_outsourcing_row . '')) ? (object) old('item_outsourcing.' . $item_outsourcing_row) : $item;
                                                                    @endphp
                                                            <tr id="item_outsourcing_row_{{ $item_outsourcing_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="$('#item_outsourcing_row_{{ $item_outsourcing_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_outsourcing_id_{{ $item_outsourcing_row }}"
                                                                           name="item_outsourcing[{{ $item_outsourcing_row }}][id]"
                                                                           value="{{ old('item_outsourcing.' . $item_outsourcing_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_outsourcing.'.$item_outsourcing_row.'.taxid') ? ' has-error' : '' }}">
                                                                        {!! Form::text('item_outsourcing[' . $item_outsourcing_row . '][taxid]', old('item_outsourcing.' . $item_outsourcing_row . '.taxid',$item->taxid), ['class' => 'form-control input-sm text-center col-taxid-id','id' => 'item_outsourcing_taxid_' . $item_outsourcing_row, 'placeholder' => __('base/employee_payroll.column_line_taxid')]) !!}
                                                                        @if ($errors->has('item_outsourcing.'.$item_outsourcing_row.'.taxid'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_outsourcing.'.$item_outsourcing_row.'.taxid') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_outsourcing.'.$item_outsourcing_row.'.percent_time') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_outsourcing[' . $item_outsourcing_row . '][percent_time]', old('item_outsourcing.' . $item_outsourcing_row . '.percent_time',round($item->percent_time,2)), ['class' => 'form-control input-sm text-right col-percent-time','id' => 'item_outsourcing_percent_time_' . $item_outsourcing_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_outsourcing.'.$item_outsourcing_row.'.percent_time'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_outsourcing.'.$item_outsourcing_row.'.percent_time') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_outsourcing_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_outsourcing">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemOutsourcing();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="3"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_retirement"
                                         aria-labelledby="retirement-tab">
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('rt_amount_an_exhibition') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('rt_amount_an_exhibition', __('base/employee_payroll.entry_rt_amount_an_exhibition') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('rt_amount_an_exhibition', old('rt_amount_an_exhibition', (!empty($duplicate_ep->rt_amount_an_exhibition) ? round($duplicate_ep->rt_amount_an_exhibition,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_rt_amount_an_exhibition'), 'step' => 'any']) !!}
                                                    @if ($errors->has('rt_amount_an_exhibition'))
                                                        <span class="help-block"><small>{{ $errors->first('rt_amount_an_exhibition') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('rt_partiality_amount') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('rt_partiality_amount', __('base/employee_payroll.entry_rt_partiality_amount') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('rt_partiality_amount', old('rt_partiality_amount', (!empty($duplicate_ep->rt_partiality_amount) ? round($duplicate_ep->rt_partiality_amount,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_rt_partiality_amount'), 'step' => 'any']) !!}
                                                    @if ($errors->has('rt_partiality_amount'))
                                                        <span class="help-block"><small>{{ $errors->first('rt_partiality_amount') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('rt_daily_amount') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('rt_daily_amount', __('base/employee_payroll.entry_rt_daily_amount') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('rt_daily_amount', old('rt_daily_amount', (!empty($duplicate_ep->rt_daily_amount) ? round($duplicate_ep->rt_daily_amount,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_rt_daily_amount'), 'step' => 'any']) !!}
                                                    @if ($errors->has('rt_daily_amount'))
                                                        <span class="help-block"><small>{{ $errors->first('rt_daily_amount') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('rt_cumulative_income') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('rt_cumulative_income', __('base/employee_payroll.entry_rt_cumulative_income') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('rt_cumulative_income', old('rt_cumulative_income', (!empty($duplicate_ep->rt_cumulative_income) ? round($duplicate_ep->rt_cumulative_income,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_rt_cumulative_income'), 'step' => 'any']) !!}
                                                    @if ($errors->has('rt_cumulative_income'))
                                                        <span class="help-block"><small>{{ $errors->first('rt_cumulative_income') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('rt_non_cumulative_income') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('rt_non_cumulative_income', __('base/employee_payroll.entry_rt_non_cumulative_income') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('rt_non_cumulative_income', old('rt_non_cumulative_income', (!empty($duplicate_ep->rt_non_cumulative_income) ? round($duplicate_ep->rt_non_cumulative_income,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_rt_non_cumulative_income'), 'step' => 'any']) !!}
                                                    @if ($errors->has('rt_non_cumulative_income'))
                                                        <span class="help-block"><small>{{ $errors->first('rt_non_cumulative_income') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_separation"
                                         aria-labelledby="separation-tab">
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('sp_total_amount') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('sp_total_amount', __('base/employee_payroll.entry_sp_total_amount') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('sp_total_amount', old('sp_total_amount', (!empty($duplicate_ep->sp_total_amount) ? round($duplicate_ep->sp_total_amount,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_sp_total_amount'), 'step' => 'any']) !!}
                                                    @if ($errors->has('sp_total_amount'))
                                                        <span class="help-block"><small>{{ $errors->first('sp_total_amount') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('sp_years_of_service') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('sp_years_of_service', __('base/employee_payroll.entry_sp_years_of_service') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('sp_years_of_service', old('sp_years_of_service', (!empty($duplicate_ep->sp_years_of_service) ? round($duplicate_ep->sp_years_of_service,0):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_sp_years_of_service')]) !!}
                                                    @if ($errors->has('sp_years_of_service'))
                                                        <span class="help-block"><small>{{ $errors->first('sp_years_of_service') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('sp_last_salary') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('sp_last_salary', __('base/employee_payroll.entry_sp_last_salary') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('sp_last_salary', old('sp_last_salary', (!empty($duplicate_ep->sp_last_salary) ? round($duplicate_ep->sp_last_salary,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_sp_last_salary'), 'step' => 'any']) !!}
                                                    @if ($errors->has('sp_last_salary'))
                                                        <span class="help-block"><small>{{ $errors->first('sp_last_salary') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('sp_cumulative_income') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('sp_cumulative_income', __('base/employee_payroll.entry_sp_cumulative_income') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('sp_cumulative_income', old('sp_cumulative_income', (!empty($duplicate_ep->sp_cumulative_income) ? round($duplicate_ep->sp_cumulative_income,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_sp_cumulative_income'), 'step' => 'any']) !!}
                                                    @if ($errors->has('sp_cumulative_income'))
                                                        <span class="help-block"><small>{{ $errors->first('sp_cumulative_income') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('sp_non_cumulative_income') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('sp_non_cumulative_income', __('base/employee_payroll.entry_sp_non_cumulative_income') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('sp_non_cumulative_income', old('sp_non_cumulative_income', (!empty($duplicate_ep->sp_non_cumulative_income) ? round($duplicate_ep->sp_non_cumulative_income,2):  '')), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_sp_non_cumulative_income'), 'step' => 'any']) !!}
                                                    @if ($errors->has('sp_non_cumulative_income'))
                                                        <span class="help-block"><small>{{ $errors->first('sp_non_cumulative_income') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_disabilities"
                                         aria-labelledby="disabilities-tab">
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_disability">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%" class="text-center">
                                                                @lang('general.column_actions')
                                                            </th>
                                                            <th width="" class="text-center">
                                                                @lang('base/employee_payroll.column_line_disability_type_id')
                                                            </th>
                                                            <th width="25%" class="text-center">@lang('base/employee_payroll.column_line_disability_days')</th>
                                                            <th width="25%" class="text-center">@lang('base/employee_payroll.column_line_disability_amount')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_disability_row = 1;
                                                            $items_disability = old('item_disability',($duplicate_ep->employeeActiveDisabilitiesPayrollLines ?? []));
                                                        @endphp
                                                        @foreach ($items_disability as $item_disability_row => $item)
                                                            @php
                                                                $item = !empty(old('item_disability.' . $item_disability_row . '')) ? (object) old('item_disability.' . $item_disability_row) : $item;

                                                                $tmp_disability_types = [];
                                                                if(!empty(old('item_disability.' . $item_disability_row . '.disability_type_id',$item->disability_type_id))){
                                                                    $tmp_disability_types = \App\Models\Catalogs\DisabilityType::where('id','=',old('item_disability.' . $item_disability_row . '.disability_type_id',$item->disability_type_id))->get()->pluck('description_select2','id');
                                                                }
                                                            @endphp
                                                            <tr id="item_disability_row_{{ $item_disability_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="$('#item_disability_row_{{ $item_disability_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_disability_id_{{ $item_disability_row }}"
                                                                           name="item_disability[{{ $item_disability_row }}][id]"
                                                                           value="{{ old('item_disability.' . $item_disability_row . '.id',$item->id) }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_disability.'.$item_disability_row.'.disability_type_id') ? ' has-error' : '' }}">
                                                                        <div class="input-group input-group-sm">
                                                                            {!! Form::select('item_disability[' . $item_disability_row . '][disability_type_id]', $tmp_disability_types,old('item_disability.' . $item_disability_row . '.disability_type_id',$item->disability_type_id), ['class' => 'form-control input-sm col-disability-type-id', 'placeholder' => __('general.text_select'),'required','id' => 'item_disability_disability_type_id_' . $item_disability_row]) !!}
                                                                            <span class="input-group-btn">
                                                                                <button type="button" class="btn btn-info btn-disability-type-search" data-row="{{ $item_disability_row }}"><i class="fa fa-search"></i></button>
                                                                            </span>
                                                                        </div>
                                                                        @if ($errors->has('item_disability.'.$item_disability_row.'.disability_type_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_disability.'.$item_disability_row.'.disability_type_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_disability.'.$item_disability_row.'.disability_days') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_disability[' . $item_disability_row . '][disability_days]', old('item_disability.' . $item_disability_row . '.disability_days', round($item->disability_days,0)), ['class' => 'form-control input-sm text-center col-disability-days','id' => 'item_disability_disability_days_' . $item_disability_row]) !!}
                                                                        @if ($errors->has('item_disability.'.$item_disability_row.'.disability_days'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_disability.'.$item_disability_row.'.disability_days') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_disability.'.$item_disability_row.'.disability_amount') ? ' has-error' : '' }}">
                                                                        {!! Form::number('item_disability[' . $item_disability_row . '][disability_amount]', old('item_disability.' . $item_disability_row . '.disability_amount', round($item->disability_amount,2)), ['class' => 'form-control input-sm text-right col-disability-amount','id' => 'item_disability_disability_amount_' . $item_disability_row, 'step' => 'any']) !!}
                                                                        @if ($errors->has('item_disability.'.$item_disability_row.'.disability_amount'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_disability.'.$item_disability_row.'.disability_amount') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_disability_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_disability">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemDisability();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="3"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_sncf"
                                         aria-labelledby="sncf-tab">
                                         <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('source_resource_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('source_resource_id', __('base/employee_payroll.entry_source_resource_id') . ' ', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('source_resource_id', $source_resources,old('source_resource_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('source_resource_id'))
                                                        <span class="help-block"><small>{{ $errors->first('source_resource_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('sncf_amount_source_resource') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('sncf_amount_source_resource', __('base/employee_payroll.entry_sncf_amount_source_resource') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('sncf_amount_source_resource', old('sncf_amount_source_resource', ''), ['class' => 'form-control text-right', 'placeholder' => __('base/employee_payroll.entry_sncf_amount_source_resource'), 'step' => 'any']) !!}
                                                    @if ($errors->has('sncf_amount_source_resource'))
                                                        <span class="help-block"><small>{{ $errors->first('sncf_amount_source_resource') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_relations"
                                         aria-labelledby="relations-tab">
                                        <div class="row">
                                            <div class="col-md-4 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('cfdi_relation_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('cfdi_relation_id', __('base/employee_payroll.entry_cfdi_relation_id') . ' ', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('cfdi_relation_id', $cfdi_relations,old('cfdi_relation_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('cfdi_relation_id'))
                                                        <span class="help-block"><small>{{ $errors->first('cfdi_relation_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-xs-12">
                                                <div class="table-responsive">
                                                    <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                                           id="items_relation">
                                                        <thead>
                                                        <tr>
                                                            <th width="5%"
                                                                class="text-center">@lang('general.column_actions')</th>
                                                            <th width="25%"
                                                                class="text-center">
                                                                @lang('base/employee_payroll.column_relation_relation_id')
                                                            </th>
                                                            <th width="65%"
                                                                class="text-center">@lang('base/employee_payroll.column_relation_uuid')</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <!-- Items -->
                                                        @php
                                                            $item_relation_row = 1;
                                                            $items_relation = old('item_relation',[]);
                                                        @endphp
                                                        @foreach ($items_relation as $item_relation_row => $item)
                                                            @php
                                                                $tmp_uuid = '';
                                                                $tmp_employee_payroll_relations = [];
                                                                if(!empty(old('item_relation.' . $item_relation_row . '.relation_id'))){
                                                                    $tmp = \App\Models\Base\EmployeePayroll::find(old('item_relation.' . $item_relation_row . '.relation_id'));
                                                                    $tmp_employee_payroll_relations = $tmp->get()->pluck('text_select2','id');
                                                                    $tmp_uuid = !empty($tmp) ? $tmp->employeePayrollCfdi->uuid : '';
                                                                }
                                                            @endphp
                                                            <tr id="item_relation_row_{{ $item_relation_row }}">
                                                                <td class="text-center"
                                                                    style="vertical-align: middle;">
                                                                    <button type="button"
                                                                            onclick="$('#item_relation_row_{{ $item_relation_row }}').remove();"
                                                                            class="btn btn-xs btn-danger"
                                                                            style="margin-bottom: 0;">
                                                                        <i class="fa fa-trash-o"></i>
                                                                    </button>
                                                                    <!-- input hidden -->
                                                                    <input type="hidden"
                                                                           id="item_relation_id_{{ $item_relation_row }}"
                                                                           name="item_relation[{{ $item_relation_row }}][id]"
                                                                           value="{{ old('item_relation.' . $item_relation_row . '.id') }}">
                                                                    <!-- /.input hidden -->
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    <div class="form-group form-group-sm{{ $errors->has('item_relation.'.$item_relation_row.'.relation_id') ? ' has-error' : '' }}">
                                                                        {!! Form::select('item_relation[' . $item_relation_row . '][relation_id]', $tmp_employee_payroll_relations,old('item_relation.' . $item_relation_row . '.relation_id'), ['class' => 'form-control input-sm col-relation-id', 'placeholder' => __('general.text_select'),'required','id' => 'item_relation_relation_id_' . $item_relation_row,'data-row' => $item_relation_row]) !!}
                                                                        @if ($errors->has('item_relation.'.$item_relation_row.'.relation_id'))
                                                                            <span class="help-block"><small>{{ $errors->first('item_relation.'.$item_relation_row.'.relation_id') }}</small></span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td class="text-center align-middle">
                                                                    <span id="item_relation_uuid_{{ $item_relation_row }}">{{$tmp_uuid}}</span>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @php
                                                            $item_relation_row++;
                                                        @endphp
                                                        <!-- /Items -->
                                                        <!-- Agregar nuevo item -->
                                                        <tr id="add_item_relation">
                                                            <td class="text-center">
                                                                <button type="button"
                                                                        onclick="addItemCfdiRelation();"
                                                                        class="btn btn-xs btn-primary"
                                                                        style="margin-bottom: 0;">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </td>
                                                            <td class="text-right" colspan="2"></td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_pre_payroll'),['type' => 'submit', 'class' => 'btn btn-sm btn-info ladda-button','name' => 'pre_payroll', 'value' => '1']) !!}
                                    &nbsp;&nbsp;
                                    {!! Form::button(__('general.button_create_cfdi'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('employee-payrolls.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">
        var item_perception_row = "{{ $item_perception_row }}";
        var item_deduction_row = "{{ $item_deduction_row }}";
        var item_other_payment_type_row = "{{ $item_other_payment_type_row }}";
        var item_outsourcing_row = "{{ $item_outsourcing_row }}";
        var item_disability_row = "{{ $item_disability_row }}";
        var item_relation_row = "{{ $item_relation_row }}";

        function paymentDays() {
            $.ajax({
                url: "{{ route('employee-payrolls/get-payment-days') }}",
                type: "POST",
                dataType: "JSON",
                data: {
                    date_start_payment: $("#form input[name='date_start_payment']").val(),
                    date_end_payment: $("#form input[name='date_end_payment']").val(),
                },
                success: function (data) {
                    if (data) {
                        if(data.payment_days) {
                            $("#form input[name='payment_days']").val(data.payment_days);
                        }
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        }

        function totalItem() {
            $.ajax({
                url: "{{ route('employee-payrolls/total-lines') }}",
                type: "POST",
                dataType: "JSON",
                data: $("#form").serialize(),
                success: function (data) {
                    if (data) {
                        $("#form #txt_amount_untaxed").html(data.amount_untaxed);
                        $("#form #txt_amount_discount").html(data.amount_discount);
                        $("#form #txt_amount_isr").html(data.amount_isr);
                        $("#form #txt_amount_total").html(data.amount_total);
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        }

        function addItemPerception() {
            var html = '';

            html += '<tr id="item_perception_row_' + item_perception_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_perception_row_' + item_perception_row + '\').remove(); totalItem();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_perception[' + item_perception_row + '][id]" id="item_perception_id_' + item_perception_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<div class="input-group input-group-sm">';
            html += '<select class="form-control input-sm col-perception-id" name="item_perception[' + item_perception_row + '][perception_id]" id="item_perception_perception_id_' + item_perception_row + '" data-row="' + item_perception_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '<span class="input-group-btn">';
            html += '<button type="button" class="btn btn-info btn-perception-search" data-row="' + item_perception_row + '"><i class="fa fa-search"></i></button>';
            html += '</span>';
            html += '</div>';
            html += '</div>';

            html += '<div class="hidden" id="accions_' + item_perception_row + '">';
            html += '<div class="row">';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-right col-ac-market-value" name="item_perception[' + item_perception_row + '][ac_market_value]" id="item_perception_ac_market_value_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_ac_market_value')}}" step="any" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-right col-ac-price-when-granted" name="item_perception[' + item_perception_row + '][ac_price_when_granted]" id="item_perception_ac_price_when_granted_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_ac_price_when_granted')}}" step="any" />';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            html += '</div>';

            html += '<div class="hidden" id="hours_' + item_perception_row + '">';
            @php
                $tmp_overtimes_type_1 = \App\Models\Catalogs\OvertimesType::where('code', '=', '01')->first();
                $tmp_overtimes_type_2 = \App\Models\Catalogs\OvertimesType::where('code', '=', '02')->first();
                $tmp_overtimes_type_3 = \App\Models\Catalogs\OvertimesType::where('code', '=', '03')->first();
            @endphp
                html += '<div class="row">';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-center col-hr-days-1" name="item_perception[' + item_perception_row + '][hr_days_1]" id="item_perception_hr_days_1_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_days')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="hidden" class="form-control input-sm text-right col-hr-overtimes-type-id-1" value="{{$tmp_overtimes_type_1->id}}" name="item_perception[' + item_perception_row + '][hr_overtimes_type_id_1]" id="item_perception_hr_overtimes_type_id_1_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_overtimes_type_id')}}" />';
            html += '</div>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-hr-overtimes-type-1" value="{{$tmp_overtimes_type_1->code . '-' . $tmp_overtimes_type_1->name}}" readonly="readonly" name="item_perception[' + item_perception_row + '][hr_overtimes_type_1]" id="item_perception_hr_overtimes_type_1_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_overtimes_type_id')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-center col-hr-hours-1" name="item_perception[' + item_perception_row + '][hr_hours_1]" id="item_perception_hr_hours_1_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_hours')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-right col-hr-amount-paid-1" name="item_perception[' + item_perception_row + '][hr_amount_paid_1]" id="item_perception_hr_amount_paid_1_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_amount_paid')}}" step="any" />';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            html += '<div class="row">';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-center col-hr-days-2" name="item_perception[' + item_perception_row + '][hr_days_2]" id="item_perception_hr_days_2_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_days')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="hidden" class="form-control input-sm text-right col-hr-overtimes-type-id-2" value="{{$tmp_overtimes_type_2->id}}" name="item_perception[' + item_perception_row + '][hr_overtimes_type_id_2]" id="item_perception_hr_overtimes_type_id_2_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_overtimes_type_id')}}" />';
            html += '</div>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-hr-overtimes-type-2" value="{{$tmp_overtimes_type_2->code . '-' . $tmp_overtimes_type_2->name}}" readonly="readonly" name="item_perception[' + item_perception_row + '][hr_overtimes_type_2]" id="item_perception_hr_overtimes_type_2_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_overtimes_type_id')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-center col-hr-hours-2" name="item_perception[' + item_perception_row + '][hr_hours_2]" id="item_perception_hr_hours_2_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_hours')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-right col-hr-amount-paid-2" name="item_perception[' + item_perception_row + '][hr_amount_paid_2]" id="item_perception_hr_amount_paid_2_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_amount_paid')}}" step="any" />';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            html += '<div class="row">';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-center col-hr-days-3" name="item_perception[' + item_perception_row + '][hr_days_3]" id="item_perception_hr_days_3_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_days')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="hidden" class="form-control input-sm text-right col-hr-overtimes-type-id-3" value="{{$tmp_overtimes_type_3->id}}" name="item_perception[' + item_perception_row + '][hr_overtimes_type_id_3]" id="item_perception_hr_overtimes_type_id_3_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_overtimes_type_id')}}" />';
            html += '</div>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-hr-overtimes-type-3" value="{{$tmp_overtimes_type_3->code . '-' . $tmp_overtimes_type_3->name}}" readonly="readonly" name="item_perception[' + item_perception_row + '][hr_overtimes_type_3]" id="item_perception_hr_overtimes_type_3_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_overtimes_type_id')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-center col-hr-hours-3" name="item_perception[' + item_perception_row + '][hr_hours_3]" id="item_perception_hr_hours_3_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_hours')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-right col-hr-amount-paid-3" name="item_perception[' + item_perception_row + '][hr_amount_paid_3]" id="item_perception_hr_amount_paid_3_' + item_perception_row + '" placeholder="{{__('base/employee_payroll.column_line_hr_amount_paid')}}" step="any" />';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            html += '</div>';

            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-code" name="item_perception[' + item_perception_row + '][code]" id="item_perception_code_' + item_perception_row + '" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-amount-taxed" name="item_perception[' + item_perception_row + '][amount_taxed]" id="item_perception_amount_taxed_' + item_perception_row + '" step="any" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-amount-exempt" name="item_perception[' + item_perception_row + '][amount_exempt]" id="item_perception_amount_exempt_' + item_perception_row + '" step="any" />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_perception tbody #add_item_perception").before(html);

            /* Configura select2 */
            initItemPerception();

            totalItem();
            item_perception_row++;
        }

        function initItemPerception() {
            /*Busqueda de percepciones*/
            $("#form #items_perception tbody .col-perception-id").select2({
                ajax: {
                    url: "{{route('perceptions/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
        }

        function addItemDeduction() {
            var html = '';

            html += '<tr id="item_deduction_row_' + item_deduction_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_deduction_row_' + item_deduction_row + '\').remove(); totalItem();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_deduction[' + item_deduction_row + '][id]" id="item_deduction_id_' + item_deduction_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<div class="input-group input-group-sm">';
            html += '<select class="form-control input-sm col-deduction-id" name="item_deduction[' + item_deduction_row + '][deduction_id]" id="item_deduction_deduction_id_' + item_deduction_row + '" data-row="' + item_deduction_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '<span class="input-group-btn">';
            html += '<button type="button" class="btn btn-info btn-deduction-search" data-row="' + item_deduction_row + '"><i class="fa fa-search"></i></button>';
            html += '</span>';
            html += '</div>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-code" name="item_deduction[' + item_deduction_row + '][code]" id="item_deduction_code_' + item_deduction_row + '" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-amount-total" name="item_deduction[' + item_deduction_row + '][amount_total]" id="item_deduction_amount_total_' + item_deduction_row + '" required step="any" />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_deduction tbody #add_item_deduction").before(html);

            /* Configura select2 */
            initItemDeduction();

            totalItem();
            item_deduction_row++;
        }

        function initItemDeduction() {
            /*Busqueda de deducciones*/
            $("#form #items_deduction tbody .col-deduction-id").select2({
                ajax: {
                    url: "{{route('deductions/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
        }

        function addItemOtherPaymentType() {
            var html = '';

            html += '<tr id="item_other_payment_type_row_' + item_other_payment_type_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_other_payment_type_row_' + item_other_payment_type_row + '\').remove(); totalItem();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_other_payment_type[' + item_other_payment_type_row + '][id]" id="item_other_payment_type_id_' + item_other_payment_type_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<div class="input-group input-group-sm">';
            html += '<select class="form-control input-sm col-other-payment-type-id" name="item_other_payment_type[' + item_other_payment_type_row + '][other_payment_type_id]" id="item_other_payment_type_other_payment_type_id_' + item_other_payment_type_row + '" data-row="' + item_other_payment_type_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '<span class="input-group-btn">';
            html += '<button type="button" class="btn btn-info btn-other-payment-type-search" data-row="' + item_other_payment_type_row + '"><i class="fa fa-search"></i></button>';
            html += '</span>';
            html += '</div>';
            html += '</div>';

            html += '<div class="hidden" id="compensation_' + item_other_payment_type_row + '">';
            html += '<div class="row">';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-right col-cm-positive-balance" name="item_other_payment_type[' + item_other_payment_type_row + '][cm_positive_balance]" id="item_other_payment_type_cm_positive_balance_' + item_other_payment_type_row + '" placeholder="{{__('base/employee_payroll.column_line_cm_positive_balance')}}" step="any" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-center col-cm-year" name="item_other_payment_type[' + item_other_payment_type_row + '][cm_year]" id="item_other_payment_type_cm_year_' + item_other_payment_type_row + '" placeholder="{{__('base/employee_payroll.column_line_cm_year')}}" />';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-3 col-xs-12">';
            html += '<div class="form-group form-group-sm mt-2">';
            html += '<input type="number" class="form-control input-sm text-right col-cm-remainder" name="item_other_payment_type[' + item_other_payment_type_row + '][cm_remainder]" id="item_other_payment_type_cm_remainder_' + item_other_payment_type_row + '" placeholder="{{__('base/employee_payroll.column_line_cm_remainder')}}" step="any" />';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            html += '</div>';

            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-code" name="item_other_payment_type[' + item_other_payment_type_row + '][code]" id="item_other_payment_type_code_' + item_other_payment_type_row + '" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-amount-total" name="item_other_payment_type[' + item_other_payment_type_row + '][amount_total]" id="item_other_payment_type_amount_total_' + item_other_payment_type_row + '" required step="any" />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-amount-caused" name="item_other_payment_type[' + item_other_payment_type_row + '][amount_caused]" id="item_other_payment_type_amount_caused_' + item_other_payment_type_row + '" step="any" />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_other_payment_type tbody #add_item_other_payment_type").before(html);

            /* Configura select2 */
            initItemOtherPaymentType();

            totalItem();
            item_other_payment_type_row++;
        }

        function initItemOtherPaymentType() {
            /*Busqueda de percepciones*/
            $("#form #items_other_payment_type tbody .col-other-payment-type-id").select2({
                ajax: {
                    url: "{{route('other-payment-types/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
        }

        function addItemOutsourcing() {
            var html = '';

            html += '<tr id="item_outsourcing_row_' + item_outsourcing_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_outsourcing_row_' + item_outsourcing_row + '\').remove();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_outsourcing[' + item_outsourcing_row + '][id]" id="item_outsourcing_id_' + item_outsourcing_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="text" class="form-control input-sm text-center col-taxid" name="item_outsourcing[' + item_outsourcing_row + '][taxid]" id="item_outsourcing_taxid_' + item_outsourcing_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-percent-time" name="item_outsourcing[' + item_outsourcing_row + '][percent_time]" id="item_outsourcing_percent_time_' + item_outsourcing_row + '" required step="any" />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_outsourcing tbody #add_item_outsourcing").before(html);

            item_outsourcing_row++;
        }

        function addItemDisability() {
            var html = '';

            html += '<tr id="item_disability_row_' + item_disability_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_disability_row_' + item_disability_row + '\').remove();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_disability[' + item_disability_row + '][id]" id="item_disability_id_' + item_disability_row + '" /> ';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<div class="input-group input-group-sm">';
            html += '<select class="form-control input-sm col-disability-type-id" name="item_disability[' + item_disability_row + '][disability_type_id]" id="item_disability_disability_type_id_' + item_disability_row + '" data-row="' + item_disability_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '<span class="input-group-btn">';
            html += '<button type="button" class="btn btn-info btn-disability-type-search" data-row="' + item_disability_row + '"><i class="fa fa-search"></i></button>';
            html += '</span>';
            html += '</div>';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-center col-disability-days" name="item_disability[' + item_disability_row + '][disability_days]" id="item_disability_disability_days_' + item_disability_row + '" required />';
            html += '</div>';
            html += '</td>';
            html += '<td>';
            html += '<div class="form-group form-group-sm">';
            html += '<input type="number" class="form-control input-sm text-right col-disability-amount" name="item_disability[' + item_disability_row + '][disability_amount]" id="item_disability_disability_amount_' + item_disability_row + '" required step="any" />';
            html += '</div>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_disability tbody #add_item_disability").before(html);

            /* Configura select2 */
            initItemDisability();

            item_disability_row++;
        }

        function initItemDisability() {
            /*Busqueda de tipos de discapacidad*/
            $("#form #items_disability tbody .col-disability-type-id").select2({
                ajax: {
                    url: "{{route('disability-types/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                templateResult: formatRepoCode,
                templateSelection: formatRepoCodeSelection,
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 2
            });
        }

        function addItemCfdiRelation() {
            var html = '';

            html += '<tr id="item_relation_row_' + item_relation_row + '">';
            html += '<td class="text-center" style="vertical-align: middle;">';
            html += '<button type="button" onclick="$(\'#item_relation_row_' + item_relation_row + '\').remove();" class="btn btn-xs btn-danger" style="margin-bottom: 0;">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '<input type="hidden" name="item_relation[' + item_relation_row + '][id]" id="item_relation_id_' + item_relation_row + '" /> ';
            html += '</td>';
            html += '<td class="text-center align-middle">';
            html += '<div class="form-group form-group-sm">';
            html += '<select class="form-control input-sm col-relation-id" name="item_relation[' + item_relation_row + '][relation_id]" id="item_relation_relation_id_' + item_relation_row + '" data-row="' + item_relation_row + '" required>';
            html += '<option selected="selected" value="">@lang('general.text_select')</option>';
            html += '</select>';
            html += '</div>';
            html += '</td>';
            html += '<td class="text-center align-middle">';
            html += '<span id="item_relation_uuid_' + item_relation_row + '"></span>';
            html += '</td>';
            html += '</tr>';

            $("#form #items_relation tbody #add_item_relation").before(html);

            /* Configura select2 */
            initItemCfdiRelation();

            item_relation_row++;
        }


        function initItemCfdiRelation() {
            /*Busqueda de facturas*/
            $("#form #items_relation tbody .col-relation-id").select2({
                ajax: {
                    url: "{{route('employee-payrolls/autocomplete-cfdi')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                            employee_id: $("#form select[name='employee_id']").val(),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 2
            });
        }

        $(function () {
            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='date_payment']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='date_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form input[name='date_start_payment']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='date_start_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
                paymentDays();
            });
            $("#form input[name='date_end_payment']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='date_end_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
                paymentDays();
            });

            /* Configura select2 para buscar cliente*/
            $("#form select[name='employee_id']").select2({
                ajax: {
                    url: "{{route('employees/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            }).on("change", function () { //Selecciona cliente
                let id = $(this).val();
                if (id) {
                    $.ajax({
                        url: "{{ route('employees/get-employee') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            $("#form select[name='tax_regimen_employee_id']").val(data.tax_regimen_id);
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });


            /* init de Funciones */
            initItemPerception();
            initItemDeduction();
            initItemOtherPaymentType();
            initItemDisability();
            initItemCfdiRelation();
            totalItem();

            /*Modal para buscar clientes*/
            $(".btn-employee-search").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('employees/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_employee_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar cliente*/
            $(document).on("click", '#form_modal_employee_search #employees .btn-select-employee', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-name'), $(this).attr('data-id'), false, true);
                $("#form select[name='employee_id']").append(option).trigger('change');
                $("#modal_employee_search").modal("hide");
            });


            /* Eventos en items percepciones */
            /*Modal para buscar percepciones*/
            $(document).on('click', '#form #items_perception tbody .btn-perception-search', function (e) {
                e.preventDefault();
                let row = $(this).attr('data-row');
                $.ajax({
                    url: "{{route('perceptions/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1&row_origin="+ row,
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_perception_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar percepcion*/
            $(document).on("click", '#form_modal_perception_search #perceptions .btn-select-perception', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form #items_perception tbody #item_perception_perception_id_" + $(this).attr('data-row-origin') + "").append(option).trigger('select2:select');
                $("#modal_perception_search").modal("hide");
            });
            $(document).on("keyup", "#form #items_perception tbody .col-amount-taxed,#form #items_perception tbody .col-amount-exempt", function () {
                totalItem();
            });
            /*Selecciona percepcion*/
            $(document).on('select2:select', '#form #items_perception tbody .col-perception-id', function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('perceptions/get-perception') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            if(data.code2) {
                                $("#form #item_perception_code_" + row).val(data.code2);
                            }else if(data.code) {
                                $("#form #item_perception_code_" + row).val(data.code);
                            }
                            //Muestra campo para acciones y titulos
                            if(data.code == '045'){
                                $("#form #accions_" + row).removeClass('hidden');
                            }else{
                                $("#form #accions_" + row).addClass('hidden');
                            }
                            //Muestra campo para horas extra
                            if(data.code == '019'){
                                $("#form #hours_" + row).removeClass('hidden');
                            }else{
                                $("#form #hours_" + row).addClass('hidden');
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            /* Eventos en items deducciones */
            /*Modal para buscar deducciones*/
            $(document).on('click', '#form #items_deduction tbody .btn-deduction-search', function (e) {
                e.preventDefault();
                let row = $(this).attr('data-row');
                $.ajax({
                    url: "{{route('deductions/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1&row_origin="+ row,
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_deduction_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar deduccion*/
            $(document).on("click", '#form_modal_deduction_search #deductions .btn-select-deduction', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form #items_deduction tbody #item_deduction_deduction_id_" + $(this).attr('data-row-origin') + "").append(option).trigger('select2:select');
                $("#modal_deduction_search").modal("hide");
            });
            $(document).on("keyup", "#form #items_deduction tbody .col-amount-total", function () {
                totalItem();
            });
            /*Selecciona deduccion*/
            $(document).on('select2:select', '#form #items_deduction tbody .col-deduction-id', function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('deductions/get-deduction') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            if(data.code2) {
                                $("#form #item_deduction_code_" + row).val(data.code2);
                            }else if(data.code) {
                                $("#form #item_deduction_code_" + row).val(data.code);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            /* Eventos en items otros pagos */
            /*Modal para buscar otros pagos*/
            $(document).on('click', '#form #items_other_payment_type tbody .btn-other-payment-type-search', function (e) {
                e.preventDefault();
                let row = $(this).attr('data-row');
                $.ajax({
                    url: "{{route('other-payment-types/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1&row_origin="+ row,
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_other_payment_type_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar otro tipo de pagos*/
            $(document).on("click", '#form_modal_other_payment_type_search #other_payment_types .btn-select-other-payment-type', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form #items_other_payment_type tbody #item_other_payment_type_other_payment_type_id_" + $(this).attr('data-row-origin') + "").append(option).trigger('select2:select');
                $("#modal_other_payment_type_search").modal("hide");
            });
            $(document).on("keyup", "#form #items_other_payment_type tbody .col-amount-total", function () {
                totalItem();
            });
            /*Selecciona otro tipo de pago*/
            $(document).on('select2:select', '#form #items_other_payment_type tbody .col-other-payment-type-id', function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('other-payment-types/get-other-payment-type') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            if(data.code2) {
                                $("#form #item_other_payment_type_code_" + row).val(data.code2);
                            }else if(data.code) {
                                $("#form #item_other_payment_type_code_" + row).val(data.code);
                            }
                            //Muestra campo para compensacion saldos a favor
                            if(data.code == '004'){
                                $("#form #compensation_" + row).removeClass('hidden');
                            }else{
                                $("#form #compensation_" + row).addClass('hidden');
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });


            /* Eventos en items incapacidades */
            /*Modal para buscar incapacidades*/
            $(document).on('click', '#form #items_disability tbody .btn-disability-type-search', function (e) {
                e.preventDefault();
                let row = $(this).attr('data-row');
                $.ajax({
                    url: "{{route('disability-types/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1&row_origin="+ row,
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_disability_type_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar incapacidades*/
            $(document).on("click", '#form_modal_disability_type_search #disability_types .btn-select-disability-type', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form #items_disability tbody #item_disability_disability_type_id_" + $(this).attr('data-row-origin') + "").append(option).trigger('select2:select');
                $("#modal_disability_type_search").modal("hide");
            });

            /*Selecciona incapacidades*/
            $(document).on('select2:select', '#form #items_disability tbody .col-disability-type-id', function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('disability-types/get-disability-type') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            /* Eventos en items cfdi relation */
            /*Selecciona factura*/
            $(document).on('select2:select', '#form #items_relation tbody .col-relation-id', function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('employee-payrolls/get-employee-payroll') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            $("#form #item_relation_uuid_" + row).html(data.uuid);
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

        });

    </script>
@endsection
