@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/employee_payroll.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/google-code-prettify/bin/prettify.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/employee_payroll.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('employee-payrolls.create',request()->except('page'))}}"
                               class="btn btn-sm btn-success">@lang('general.button_add')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Filtros -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            <div class="filter-data">
                                {!! Form::open(['route' => 'employee-payrolls.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_name', __('base/employee_payroll.entry_name') , ['class' => 'control-label'])) !!}
                                            {!! Form::text('filter_name', request()->input('filter_name'), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_name'),'autofocus']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_date_payment_from', __('general.text_date_from') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('filter_date_payment_from', request()->input('filter_date_payment_from',\App\Helpers\Helper::date(Date::parse('first day of this month')->subMonths(2))), ['class' => 'form-control', 'placeholder' => __('general.text_date_from'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_date_payment_to', __('general.text_date_to') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('filter_date_payment_to', request()->input('filter_date_payment_to',\App\Helpers\Helper::date(Date::parse('last day of this month'))), ['class' => 'form-control', 'placeholder' => __('general.text_date_to'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_payroll_type_id', __('base/employee_payroll.entry_payroll_type_id') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_payroll_type_id', $payroll_types,request()->input('filter_payroll_type_id'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            @php
                                                $tmp_employees = [];
                                                if(!empty(request()->input('filter_employee_id'))){
                                                    $tmp_employees = \App\Models\Base\Employee::where('id',request()->input('filter_employee_id'))->get()->pluck('text_select2','id');
                                                }
                                            @endphp
                                            {!! html_entity_decode(Form::label('filter_employee_id', __('base/employee_payroll.entry_employee_id') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_employee_id', $tmp_employees,request()->input('filter_employee_id'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_payroll_id', __('base/employee_payroll.entry_payroll_id') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_payroll_id', $payrolls,request()->input('filter_payroll_id'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_status', __('base/employee_payroll.entry_status') , ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_status', $list_status,request()->input('filter_status'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="row" style="margin-top: 10px;">
                                    <div class="col-md-8 col-xs-5 text-left">
                                        <div class="form-inline">
                                        <span>
                                            <span class="hidden-xs">@lang('general.text_item_per_page')</span>
                                            {!! Form::select('limit', $limits,request()->input('limit',setting('list_limit','100')), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'onchange' => 'this.form.submit()']) !!}
                                        </span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xs-7 text-right footer-form">
                                        {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-sm btn-default']) !!}
                                        &nbsp;
                                        {!! Form::button(__('general.button_download_xmlpdf'),['type' => 'submit', 'class' => 'btn btn-sm btn-default','name' => 'download_xmlpdf','value' => '1']) !!}
                                        &nbsp;
                                        <a href="{{route('employee-payrolls/export-to-excel',request()->except('page'))}}" class="btn btn-sm btn-excel">
                                            @lang('general.button_export_to_excel')
                                        </a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Filtros -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_list')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->

                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data table-dropdown">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr class="mini">
                                        <th class="text-center">@sortablelink('name',
                                            __('base/employee_payroll.column_name'))
                                        </th>
                                        <th class="text-left">
                                            @lang('base/employee_payroll.column_payroll')
                                        </th>
                                        <th class="text-center">@sortablelink('date_payment',
                                            __('base/employee_payroll.column_date_payment'))
                                        </th>
                                        <th class="text-center">
                                            @lang('base/employee_payroll.column_uuid')
                                        </th>
                                        <th class="text-left">@sortablelink('employee.name',
                                            __('base/employee_payroll.column_employee'))
                                        </th>
                                        <th class="text-center">@sortablelink('payrollType.name',
                                            __('base/employee_payroll.column_payroll_type'))
                                        </th>
                                        <th class="text-center">@sortablelink('currency.name',
                                            __('base/employee_payroll.column_currency'))
                                        </th>
                                        <th class="text-center">@sortablelink('amount_total',
                                            __('base/employee_payroll.column_amount_total'))
                                        </th>
                                        <th class="text-center">@sortablelink('mail_sent',
                                            __('base/employee_payroll.column_mail_sent'))
                                        </th>
                                        <th class="text-center">@sortablelink('status',
                                            __('base/employee_payroll.column_status'))
                                        </th>
                                        <th class="text-center" width="5%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="mini {{ ($result->status == \App\Models\Base\EmployeePayroll::CANCEL ? 'text-muted' : '') }}">
                                            <td class="text-center">
                                                <a href="{{ route('employee-payrolls.show',array_merge(['id' => $result->id],request()->except('page'))) }}">{{$result->name}}</a>
                                            </td>
                                            <td class="text-left">{{ $result->payroll->name ?? '' }}</td>
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDate($result->date_payment) }}</td>
                                            <td class="text-center">{{ $result->employeePayrollCfdi->uuid ?? '' }}</td>
                                            <td class="text-left">{{ $result->employee->name }}</td>
                                            <td class="text-center">{{ $result->payrollType->name }}</td>
                                            <td class="text-center">{{ $result->currency->code }}</td>
                                            <td class="text-right">{{ money($result->amount_total,$result->currency->code,true) }}</td>
                                            <td class="text-center">
                                                @if($result->mail_sent)
                                                    <i class="fa fa-check text-success"></i>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                {!! \App\Helpers\BaseHelper::statusEmployeePayrollHtml($result->status) !!}
                                            </td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <!-- form -->

                                            <!-- /form -->
                                                <div class="btn-group btn-group-xs">
                                                    <button type="button" class="btn btn-default dropdown-toggle"
                                                            data-toggle="dropdown" data-toggle-position="left"
                                                            aria-expanded="false">
                                                        <i class="fa fa-ellipsis-h"></i>
                                                    </button>
                                                    <ul class="dropdown-menu dropdown-menu-right pull-right"
                                                        style="padding-top: 10px; padding-bottom: 10px;">
                                                        <li>
                                                            <a href="{{ route('employee-payrolls.show',array_merge(['id' => $result->id],request()->except('page'))) }}">
                                                                <i class="fa fa-eye"></i> @lang('general.button_show')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ route('employee-payrolls.create',['duplicate_id' => $result->id]) }}">
                                                                <i class="fa fa-copy"></i> @lang('general.button_duplicate')
                                                            </a>
                                                        </li>
                                                        @if((int) $result->status == \App\Models\Base\EmployeePayroll::DRAFT)
                                                            <li>
                                                                <a href="{{ route('employee-payrolls.edit',array_merge(['id' => $result->id],request()->except('page'))) }}">
                                                                    <i class="fa fa-pencil"></i> @lang('general.button_edit')
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="{{ route('employee-payrolls/stamp',array_merge(['id' => $result->id],request()->except('page'))) }}">
                                                                    <i class="fa fa-file-text-o"></i> @lang('general.button_payroll_stamp')
                                                                </a>
                                                            </li>
                                                        @endif
                                                        <li>
                                                            <a href="{{route('employee-payrolls/download-pdf',['id' => $result->id])}}">
                                                                <i class="fa fa-file-pdf-o"></i> @lang('general.button_download_pdf')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{route('employee-payrolls/download-xml',['id' => $result->id])}}">
                                                                <i class="fa fa-file-code-o"></i> @lang('general.button_download_xml')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="#" class="link-send-mail" data-id="{{$result->id}}" data-url="{{route('employee-payrolls/modal-send-mail',['id' => $result->id])}}">
                                                                <i class="fa fa-envelope-o"></i> @lang('general.button_send_mail')
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{route('employee-payrolls/print',['id' => $result->id])}}"
                                                               target="_blank">
                                                                <i class="fa fa-print"></i> @lang('general.button_print')
                                                            </a>
                                                        </li>
                                                        @if(!$result->mail_sent && (int) $result->status != \App\Models\Base\EmployeePayroll::DRAFT)
                                                            <li>
                                                                <a href="{{route('employee-payrolls/mark-sent',['id' => $result->id])}}">
                                                                    <i class="fa fa-hand-paper-o"></i> @lang('base/employee_payroll.text_mark_sent')
                                                                </a>
                                                            </li>
                                                        @endif
                                                        @if(!empty($result->employeePayrollCfdi->uuid))
                                                            <li>
                                                                <a href="#" class="link-status-sat" data-id="{{$result->id}}" data-url="{{route('employee-payrolls/modal-status-sat',['id' => $result->id])}}">
                                                                    <i class="fa fa-question-circle-o"></i> @lang('general.button_status_sat')
                                                                </a>
                                                            </li>
                                                        @endif
                                                        @if((int) $result->status != \App\Models\Base\EmployeePayroll::CANCEL)
                                                            <li class="divider"></li>
                                                            <li>
                                                                <a href="#" class="link-cancel" data-id="{{$result->id}}" data-url="{{route('employee-payrolls/modal-cancel',['id' => $result->id])}}">
                                                                    <i class="fa fa-trash-o"></i> @lang('general.button_cancel')
                                                                </a>
                                                            </li>
                                                        @endif
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="11" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/bootstrap-wysiwyg/js/bootstrap-wysiwyg.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/jquery.hotkeys/jquery.hotkeys.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/google-code-prettify/src/prettify.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='filter_date_payment_from']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='filter_date_payment_from']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form input[name='filter_date_payment_to']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='filter_date_payment_to']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });

            /* Configura select2 para buscar cliente*/
            $("#form select[name='filter_employee_id']").select2({
                ajax: {
                    url: "{{route('employees/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_all')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });

            /*Modal para envio de correos*/
            $(".link-send-mail").on("click", function () {
                let id = $(this).attr('data-id');
                let url = $(this).attr('data-url');
                if (id && url) {
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id ,
                        success: function (data) {
                            $("#modals").html(data.html);
                            $("#modal_employee_payroll_send_mail").modal("show");

                            //Editor
                            $("#modal_employee_payroll_send_mail .modal-body textarea[name='message']").wysiwyg();
                            $("#modal_employee_payroll_send_mail #editor-one").wysiwyg({
                                toolbarSelector: '[data-target="#editor-one"]',
                            }).html(data.custom_message);

                            //Correos para
                            $("#modal_employee_payroll_send_mail .modal-body select[name='to\[\]']").select2({
                                placeholder: "@lang('general.text_select')",
                                theme: "bootstrap",
                                width: "auto",
                                dropdownAutoWidth: true,
                                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                                tags: true,
                                tokenSeparators: [',', ' '],
                            });

                            //Correos para
                            $("#modal_employee_payroll_send_mail .modal-body select[name='reply\[\]']").select2({
                                placeholder: "@lang('general.text_select')",
                                theme: "bootstrap",
                                width: "auto",
                                dropdownAutoWidth: true,
                                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                                tags: true,
                                tokenSeparators: [',', ' '],
                            });

                            //Archivos
                            $("#modal_employee_payroll_send_mail .modal-body select[name='attach\[\]']").select2({
                                placeholder: "@lang('general.text_select')",
                                theme: "bootstrap",
                                width: "auto",
                                dropdownAutoWidth: true,
                                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                                disabled: true,
                            });
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            /*Submit para envio de correos*/
            $(document).on("submit", '#form_modal_employee_payroll_send_mail', function (e) {
                e.preventDefault();
                $("#modal_employee_payroll_send_mail .modal-body textarea[name='message']").val($("#editor-one").html());
                $.ajax({
                    url: $(this).attr('action'),
                    type: "POST",
                    dataType: "JSON",
                    data: $(this).serialize(),
                    success: function (data) {
                        if (data.success) {
                            $("#modal_employee_payroll_send_mail .modal-body").html(alertRichMessage('success', data.success));
                            $("#modal_employee_payroll_send_mail .modal-footer").remove();
                            $("#modal_employee_payroll_send_mail .modal-dialog").removeClass('modal-lg');
                            setTimeout(function () {
                                location.reload();
                            }, 2000);
                        }
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            let message = error.responseJSON.error;
                            $("#modal_general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });

            /*Modal para cancelar*/
            $(".link-cancel").on("click", function () {
                let id = $(this).attr('data-id');
                let url = $(this).attr('data-url');
                if (id && url) {
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id ,
                        success: function (data) {
                            $("#modals").html(data.html);
                            $("#modal_employee_payroll_cancel").modal("show");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

            /*Modal para status en el SAT*/
            $(".link-status-sat").on("click", function () {
                let id = $(this).attr('data-id');
                let url = $(this).attr('data-url');
                if (id && url) {
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id ,
                        success: function (data) {
                            $("#modals").html(data.html);
                            $("#modal_employee_payroll_status_sat").modal("show");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
        });



    </script>
@endsection
