<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$employee_payroll->documentType->name}}-{{$employee_payroll->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 50px;
            margin-bottom: 30px;
        }
        body {
            font-size: 7pt;
        }
        .text-head {
            font-size: 7pt;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 15px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($employee_payroll->company_id) }}     !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($employee_payroll->company_id) }}     !important;
        }

        .table-items2 thead th, .table-items2 {
            background-color: #DDDDDD !important;
            color: #333333;
        }

        .cell-primary {
            color: #ffffff !important;
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($employee_payroll->company_id) }}     !important;
        }

        .border-primary {
            border: 1px solid {{ \App\Helpers\Helper::companyColorPrimary($employee_payroll->company_id) }};
        }
        .watermark2 {
            position: absolute;
            bottom: 540px;
            left: 100px;
            font-size: 50pt;
            font-weight: bold;
            color: #555555;
            letter-spacing: 6px;
            opacity: 0.3;
            transform: rotate(-45deg);
        }
    </style>
</head>
<body style="background-color: white;">
@php
//Obtiene datos del Cfdi33
$draft = (int) $employee_payroll->status == \App\Models\Base\EmployeePayroll::DRAFT ? true : false;
$cfdi33 = empty($data['cfdi33']) ? null : $data['cfdi33'];
$conceptos = null;
if($cfdi33){
    $conceptos = $cfdi33->conceptos;
    $conceptos = $conceptos();
}
@endphp
<section class="header" style="top: -30px;">

</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
@if($employee_payroll->status == \App\Models\Base\EmployeePayroll::CANCEL)
    <section class="watermark" style="bottom: 450px !important;">
        @if(!empty($employee_payroll->employeePayrollCfdi->uuid))
            <span>@lang('general.text_canceled_cfdi')</span>
        @else
            <span>@lang('general.text_canceled')</span>
        @endif
    </section>
@endif
@if($draft)

@endif
<section>
    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%">
            <tr>
                <td width="24%" class="border-primary" style="vertical-align: top; padding: 1px; position: relative; text-align: center;">
                    @if(!empty(setting('branch_office_logo_docs')))
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocsBranchOffices($employee_payroll->company_id,$employee_payroll->branch_office_id) }}"
                        class="invoice-logo" style="max-width: 160px !important; max-height: 80px !important;"/>
                    @else
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($employee_payroll->company_id) }}"
                        class="invoice-logo" style="max-width: 160px !important; max-height: 80px !important;"/>
                    @endif
                </td>
                <td width="43%" class="cell-primary border-primary" style="vertical-align: top; padding: 5px; position: relative;">
                    <strong style="font-size: 8pt;">{{ mb_strtoupper($employee_payroll->company->name) }}</strong>
                    <br/>
                    {{ ($employee_payroll->taxRegimen->name_sat ?? $employee_payroll->company->taxRegimen->name_sat) }}
                    <br/>
                    {{ mb_strtoupper($employee_payroll->company->taxid) }}
                    <span>
                    @if(!empty($employee_payroll->company->address_1) || !empty($employee_payroll->company->address_2) || !empty($employee_payroll->company->address_3) || !empty($employee_payroll->company->address_4))
                            <br/>
                            {{ $employee_payroll->company->address_1 ?? '' }} {{ $employee_payroll->company->address_2 ?? '' }} {{ $employee_payroll->company->address_3 ?? '' }} {{ $employee_payroll->company->address_4 ?? '' }}
                        @endif
                        @if(!empty($employee_payroll->company->city->name) || !empty($employee_payroll->company->state->name))
                            <br/>
                            {{ !empty($employee_payroll->company->city->name) ? $employee_payroll->company->city->name . ', ' : '' }}{{ !empty($employee_payroll->company->state->name) ? $employee_payroll->company->state->name . ', ' : '' }}
                        @endif
                        <br/>
                        {{ $employee_payroll->company->country->name ?? '' }}{!! ($employee_payroll->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $employee_payroll->company->postcode : '') !!}
                </span>
                </td>
                <td width="33%" class="text-center cell-primary border-primary" style="vertical-align: top; padding: 5px; height: 60px;">
                    <strong style="font-size: 8pt;">{{ mb_strtoupper($employee_payroll->documentType->name) }}: {{ $employee_payroll->name }}</strong>
                    <br/>
                    <span>@lang('general.text_issued_in'): </span>{{ $employee_payroll->branchOffice->name ?? '' }} {!! ($employee_payroll->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $employee_payroll->branchOffice->postcode : '') !!}
                    <br/>
                    <span>@lang('base/employee_payroll.entry_date'): </span>{{ \App\Helpers\Helper::convertSqlToDateTime($employee_payroll->date) }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td colspan="3" style="padding: 3px 1px;">
                    <strong>{{ mb_strtoupper($employee_payroll->employee->name) }}</strong>
                </td>
            </tr>
            <tr>
                <td width="34%" class="text-head" style="vertical-align: top; padding: 3px;">
                    <strong>@lang('base/employee.entry_code2'): </strong>{{ mb_strtoupper($employee_payroll->employee->code) }}
                    <br>
                    <strong>@lang('base/employee.entry_taxid'): </strong>{{ mb_strtoupper($employee_payroll->employee->taxid) }}
                    @if(!empty($employee_payroll->employee->nss))
                        <br>
                        <strong>@lang('base/employee_payroll.entry_nss'): </strong>{{ mb_strtoupper($employee_payroll->employee->nss) }}
                    @endif
                    <br>
                    <strong>@lang('base/employee.entry_curp'): </strong>{{ mb_strtoupper($employee_payroll->employee->curp) }}
                    @if($employee_payroll->base_salary>0)
                        <br>
                        <strong>@lang('base/employee_payroll.entry_base_salary'): </strong>{{ money($employee_payroll->base_salary,$employee_payroll->currency->code,true) }}
                    @endif
                    @if($employee_payroll->sdi>0)
                        <br>
                        <strong>@lang('base/employee_payroll.entry_sdi'): </strong>{{ money($employee_payroll->sdi,$employee_payroll->currency->code,true) }}
                    @endif
                    <br>
                    <strong>@lang('base/employee_payroll.entry_tax_regimen_employee_id2'): </strong>{{ $employee_payroll->taxRegimenEmployee->name_sat ?? ($employee_payroll->employee->taxRegimen->name_sat ?? '') }}
                </td>
                <td width="33%" class="text-head" style="vertical-align: top; padding: 3px;">
                    <strong>@lang('base/employee_payroll.entry_date_payment'): </strong>{{ \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_payment) }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_date_start_payment'): </strong>{{ $employee_payroll->date_start_payment ? \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_start_payment) : '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_date_end_payment'): </strong>{{ $employee_payroll->date_end_payment ? \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_end_payment) : '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_payment_days'): </strong>{{ \App\Helpers\Helper::numberFormat($employee_payroll->payment_days,3) }}
                    <br>
                    <strong>@lang('base/employee.entry_frequency_payment_id'): </strong>{{ $employee_payroll->employee->frequencyPayment->name_sat ?? '' }}
                    <br>
                    <strong>@lang('base/employee.entry_contract_type_id'): </strong>{{ $employee_payroll->employee->contractType->code ?? '' }}
                </td>
                <td width="33%" class="text-head" style="vertical-align: top; padding: 3px;">
                    <strong>@lang('base/employee_payroll.entry_payroll_type_id'): </strong>{{ $employee_payroll->payrollType->name_sat ?? '' }}
                    <br>
                    <strong>@lang('base/employee.entry_recruitment_regime_id'): </strong>{{ $employee_payroll->employee->recruitmentRegime->code ?? '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_cfdi_use_id'): </strong>{{ $employee_payroll->cfdiUse->code ?? '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_state_id'): </strong>{{ $employee_payroll->employee->state->code ?? '' }}
                    <br>
                    <strong>@lang('base/employee.entry_department'): </strong>{{ $employee_payroll->employee->department }}
                    <br>
                    <strong>@lang('base/employee.entry_job'): </strong>{{ $employee_payroll->employee->job }}
                    <br>
                    <strong>@lang('base/employee.entry_postcode'): </strong>{{ $employee_payroll->employee->postcode }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 5px;">
            <thead>
            <tr>
                <th class="text-center" width="50%">{{ mb_strtoupper(__('base/employee_payroll.tab_perceptions')) }}</th>
                <th class="text-center" width="50%">{{ mb_strtoupper(__('base/employee_payroll.tab_deductions')) }}</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td style="background-color: white; padding-right: 5px; border: 0; vertical-align: top;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                        <tbody>
                        <tr>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_code2')}}</b></td>
                            <td class="text-left"><b>{{__('base/employee_payroll.column_line_perception_id')}}</b></td>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_amount_total')}}</b></td>
                        </tr>
                        @if($employee_payroll->employeeActivePerceptionsAllPayrollLines->isNotEmpty())
                            @foreach($employee_payroll->employeeActivePerceptionsAllPayrollLines as $result)
                                <tr>
                                    <td class="text-center">{{$result->code}}</td>
                                    <td class="text-left">{{(!empty($result->perception->name_sat) ? $result->perception->name_sat : (!empty($result->otherPaymentType->name_sat) ? $result->otherPaymentType->name_sat : ''))}}</td>
                                    <td class="text-right">{{\App\Helpers\Helper::numberFormatMoney($result->amount_total,2)}}</td>
                                </tr>
                            @endforeach
                        @endif
                        </tbody>
                    </table>
                </td>
                <td style="background-color: white; padding-left: 5px; border: 0; vertical-align: top;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                        <tbody>
                        <tr>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_code2')}}</b></td>
                            <td class="text-left"><b>{{__('base/employee_payroll.column_line_deduction_id')}}</b></td>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_amount_total')}}</b></td>
                        </tr>
                        @if($employee_payroll->employeeActiveDeductionsPayrollLines->isNotEmpty())
                            @foreach($employee_payroll->employeeActiveDeductionsPayrollLines as $result)
                                <tr>
                                    <td class="text-center">{{$result->code}}</td>
                                    <td class="text-left">{{$result->deduction->name_sat}}</td>
                                    <td class="text-right">{{\App\Helpers\Helper::numberFormatMoney($result->amount_total,2)}}</td>
                                </tr>
                            @endforeach
                        @endif
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr>
                <td style="background-color: white; padding-right: 5px; border: 0; border-top: 1px solid #999999; color: #555555;">
                    <small>{{\App\Helpers\Helper::companyModulePayrLegend($employee_payroll->company->id)}}</small>
                    @if(empty(\App\Helpers\Helper::companyModulePayrLegend($employee_payroll->company->id)))
                        <br><br>
                    @endif
                    <br><br><br>
                    ____________________________
                    <br><span>@lang('base/employee_payroll.text_employee_signature')</span>
                </td>
                <td style="background-color: white; padding-left: 5px; border: 0; border-top: 1px solid #999999;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                        <tbody>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_untaxed'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_untaxed,2)}}</b></td>
                        </tr>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_discount'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_discount,2)}}</b></td>
                        </tr>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_isr'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_isr,2)}}</b></td>
                        </tr>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_total'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_total,2)}}</b></td>
                        </tr>
                        <tr>
                            <td colspan="2" style="background: #fff;">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.column_line_amount_caused2'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($data['subsidio_causado'],2)}}</b></td>
                        </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items table-items2" width="100%" style="margin-top: 15px;">
            <thead>
            <tr>
                <th class="text-left">{{ (__('base/employee_payroll.column_line0_name')) }}</th>
                <th width="15%">{{ (__('base/employee_payroll.column_line0_sat_product_id')) }}</th>
                <th width="14%">{{ (__('base/employee_payroll.column_line0_unit_measure_id')) }}</th>
                <th width="7%">{{ (__('base/employee_payroll.column_line0_quantity')) }}</th>
                <th width="14%">{{ (__('base/employee_payroll.column_line0_price_unit')) }}</th>
                <th width="10%">{{ (__('base/employee_payroll.column_line0_discount')) }}</th>
                <th width="11%">{{ (__('base/employee_payroll.column_line0_amount_untaxed')) }}</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>{{!empty($employee_payroll->reference) ? $employee_payroll->reference  : __('base/employee_payroll.text_reference')}}</td>
                <td class="text-center">84111505</td>
                <td class="text-center">ACT</td>
                <td class="text-center">1</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_untaxed,2) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_discount + $employee_payroll->amount_isr,2) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_total,2) }}</td>
            </tr>
            <tr>
                <td colspan="7" class="text-center" style="background-color: #FAFAFA;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($employee_payroll->amount_total,$employee_payroll->currency->code,$employee_payroll->currency->decimal_place)}})***
                </td>
            </tr>
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('base/employee_payroll.entry_payment_way_id'): </strong>{{ $employee_payroll->paymentWay->name_sat }}
                </td>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('base/employee_payroll.entry_payment_method_id'): </strong>{{ $employee_payroll->paymentMethod->name_sat }}
                </td>
            </tr>
        </table>
    </div>
    <div class="text-center">
        <small>@lang('general.text_cfdi_40')</small>
    </div>

    <hr style="border: 1px dashed #888888; margin: 35px 0 35px 0;">

    <div>
        <table cellpadding="0" cellspacing="0" class="" width="100%">
            <tr>
                <td width="67%" class="cell-primary" style="vertical-align: top; padding: 5px; position: relative;">
                    <strong style="font-size: 8pt;">{{ mb_strtoupper($employee_payroll->company->name) }}</strong>
                    <br/>
                    {{ $employee_payroll->company->taxRegimen->name_sat }}
                    <br/>
                    {{ mb_strtoupper($employee_payroll->company->taxid) }}
                    <br/>
                    <span>
                    @if(!empty($employee_payroll->company->address_1) || !empty($employee_payroll->company->address_2) || !empty($employee_payroll->company->address_3) || !empty($employee_payroll->company->address_4))
                            {{ $employee_payroll->company->address_1 ?? '' }} {{ $employee_payroll->company->address_2 ?? '' }} {{ $employee_payroll->company->address_3 ?? '' }} {{ $employee_payroll->company->address_4 ?? '' }}
                        @endif
                        @if(!empty($employee_payroll->company->city->name) || !empty($employee_payroll->company->state->name))
                            {{ !empty($employee_payroll->company->city->name) ? $employee_payroll->company->city->name . ', ' : '' }}{{ !empty($employee_payroll->company->state->name) ? $employee_payroll->company->state->name . ', ' : '' }}
                        @endif
                        {{ $employee_payroll->company->country->name ?? '' }}{!! ($employee_payroll->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $employee_payroll->company->postcode : '') !!}
                </span>
                </td>
                <td width="33%" class="text-center cell-primary" style="vertical-align: top; padding: 5px; height: 60px;">
                    <strong style="font-size: 8pt;">{{ mb_strtoupper($employee_payroll->documentType->name) }}: {{ $employee_payroll->name }}</strong>
                    <br/>
                    <span>@lang('general.text_issued_in'): </span>{{ $employee_payroll->branchOffice->name ?? '' }} {!! ($employee_payroll->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $employee_payroll->branchOffice->postcode : '') !!}
                    <br/>
                    <span>@lang('base/employee_payroll.entry_date'): </span>{{ \App\Helpers\Helper::convertSqlToDateTime($employee_payroll->date) }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td colspan="3" style="padding: 3px 1px;">
                    <strong>{{ mb_strtoupper($employee_payroll->employee->name) }}</strong>
                </td>
            </tr>
            <tr>
                <td width="34%" class="text-head" style="vertical-align: top; padding: 3px;">
                    <strong>@lang('base/employee.entry_code2'): </strong>{{ mb_strtoupper($employee_payroll->employee->code) }}
                    <br>
                    <strong>@lang('base/employee.entry_taxid'): </strong>{{ mb_strtoupper($employee_payroll->employee->taxid) }}
                    @if(!empty($employee_payroll->employee->nss))
                        <br>
                        <strong>@lang('base/employee_payroll.entry_nss'): </strong>{{ mb_strtoupper($employee_payroll->employee->nss) }}
                    @endif
                    <br>
                    <strong>@lang('base/employee.entry_curp'): </strong>{{ mb_strtoupper($employee_payroll->employee->curp) }}
                    @if($employee_payroll->base_salary>0)
                        <br>
                        <strong>@lang('base/employee_payroll.entry_base_salary'): </strong>{{ money($employee_payroll->base_salary,$employee_payroll->currency->code,true) }}
                    @endif
                    @if($employee_payroll->sdi>0)
                        <br>
                        <strong>@lang('base/employee_payroll.entry_sdi'): </strong>{{ money($employee_payroll->sdi,$employee_payroll->currency->code,true) }}
                    @endif
                </td>
                <td width="33%" class="text-head" style="vertical-align: top; padding: 3px;">
                    <strong>@lang('base/employee_payroll.entry_date_payment'): </strong>{{ \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_payment) }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_date_start_payment'): </strong>{{ $employee_payroll->date_start_payment ? \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_start_payment) : '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_date_end_payment'): </strong>{{ $employee_payroll->date_end_payment ? \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_end_payment) : '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_payment_days'): </strong>{{ \App\Helpers\Helper::numberFormat($employee_payroll->payment_days,3) }}
                    <br>
                    <strong>@lang('base/employee.entry_frequency_payment_id'): </strong>{{ $employee_payroll->employee->frequencyPayment->name_sat ?? '' }}
                    <br>
                    <strong>@lang('base/employee.entry_contract_type_id'): </strong>{{ $employee_payroll->employee->contractType->code ?? '' }}
                </td>
                <td width="33%" class="text-head" style="vertical-align: top; padding: 3px;">
                    <strong>@lang('base/employee_payroll.entry_payroll_type_id'): </strong>{{ $employee_payroll->payrollType->name_sat ?? '' }}
                    <br>
                    <strong>@lang('base/employee.entry_recruitment_regime_id'): </strong>{{ $employee_payroll->employee->recruitmentRegime->code ?? '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_cfdi_use_id'): </strong>{{ $employee_payroll->cfdiUse->code ?? '' }}
                    <br>
                    <strong>@lang('base/employee_payroll.entry_state_id'): </strong>{{ $employee_payroll->employee->state->code ?? '' }}
                    <br>
                    <strong>@lang('base/employee.entry_department'): </strong>{{ $employee_payroll->employee->department }}
                    <br>
                    <strong>@lang('base/employee.entry_job'): </strong>{{ $employee_payroll->employee->job }}
                </td>
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" style="margin-top: 5px;">
            <thead>
            <tr>
                <th class="text-center" width="50%">{{ mb_strtoupper(__('base/employee_payroll.tab_perceptions')) }}</th>
                <th class="text-center" width="50%">{{ mb_strtoupper(__('base/employee_payroll.tab_deductions')) }}</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td style="background-color: white; padding-right: 5px; border: 0; vertical-align: top;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                        <tbody>
                        <tr>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_code2')}}</b></td>
                            <td class="text-left"><b>{{__('base/employee_payroll.column_line_perception_id')}}</b></td>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_amount_total')}}</b></td>
                        </tr>
                        @if($employee_payroll->employeeActivePerceptionsAllPayrollLines->isNotEmpty())
                            @foreach($employee_payroll->employeeActivePerceptionsAllPayrollLines as $result)
                                <tr>
                                    <td class="text-center">{{$result->code}}</td>
                                    <td class="text-left">{{(!empty($result->perception->name_sat) ? $result->perception->name_sat : (!empty($result->otherPaymentType->name_sat) ? $result->otherPaymentType->name_sat : ''))}}</td>
                                    <td class="text-right">{{\App\Helpers\Helper::numberFormatMoney($result->amount_total,2)}}</td>
                                </tr>
                            @endforeach
                        @endif
                        </tbody>
                    </table>
                </td>
                <td style="background-color: white; padding-left: 5px; border: 0; vertical-align: top;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                        <tbody>
                        <tr>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_code2')}}</b></td>
                            <td class="text-left"><b>{{__('base/employee_payroll.column_line_deduction_id')}}</b></td>
                            <td class="text-center"><b>{{__('base/employee_payroll.column_line_amount_total')}}</b></td>
                        </tr>
                        @if($employee_payroll->employeeActiveDeductionsPayrollLines->isNotEmpty())
                            @foreach($employee_payroll->employeeActiveDeductionsPayrollLines as $result)
                                <tr>
                                    <td class="text-center">{{$result->code}}</td>
                                    <td class="text-left">{{$result->deduction->name_sat}}</td>
                                    <td class="text-right">{{\App\Helpers\Helper::numberFormatMoney($result->amount_total,2)}}</td>
                                </tr>
                            @endforeach
                        @endif
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr>
                <td style="background-color: white; padding-right: 5px; border: 0; border-top: 1px solid #999999; color: #555555;">
                    <small>{{\App\Helpers\Helper::companyModulePayrLegend($employee_payroll->company->id)}}</small>
                    <br><br><br>
                    ____________________________
                    <br><span>@lang('base/employee_payroll.text_employee_signature')</span>
                </td>
                <td style="background-color: white; padding-left: 5px; border: 0; border-top: 1px solid #999999;">
                    <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                        <tbody>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_untaxed'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_untaxed,2)}}</b></td>
                        </tr>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_discount'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_discount,2)}}</b></td>
                        </tr>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_isr'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_isr,2)}}</b></td>
                        </tr>
                        <tr>
                            <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_total'))}}</b></td>
                            <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_total,2)}}</b></td>
                        </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-items table-items2" width="100%" style="margin-top: 15px;">
            <thead>
            <tr>
                <th class="text-left">{{ (__('base/employee_payroll.column_line0_name')) }}</th>
                <th width="15%">{{ (__('base/employee_payroll.column_line0_sat_product_id')) }}</th>
                <th width="14%">{{ (__('base/employee_payroll.column_line0_unit_measure_id')) }}</th>
                <th width="7%">{{ (__('base/employee_payroll.column_line0_quantity')) }}</th>
                <th width="14%">{{ (__('base/employee_payroll.column_line0_price_unit')) }}</th>
                <th width="10%">{{ (__('base/employee_payroll.column_line0_discount')) }}</th>
                <th width="11%">{{ (__('base/employee_payroll.column_line0_amount_untaxed')) }}</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>Pago de nómina</td>
                <td class="text-center">84111505</td>
                <td class="text-center">ACT</td>
                <td class="text-center">1</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_untaxed,2) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_discount + $employee_payroll->amount_isr,2) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_total,2) }}</td>
            </tr>
            <tr>
                <td colspan="7" class="text-center" style="background-color: #FAFAFA;">
                    ***({{\App\Helpers\Helper::numberToWordCurrency($employee_payroll->amount_total,$employee_payroll->currency->code,$employee_payroll->currency->decimal_place)}})***
                </td>
            </tr>
            </tbody>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
            <tr>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('base/employee_payroll.entry_payment_way_id'): </strong>{{ $employee_payroll->paymentWay->name_sat }}
                </td>
                <td width="50%" style="vertical-align: top; padding: 5px;">
                    <strong>@lang('base/employee_payroll.entry_payment_method_id'): </strong>{{ $employee_payroll->paymentMethod->name_sat }}
                </td>
            </tr>
        </table>
    </div>
    @if(!empty($employee_payroll->source_resource_id))
        <div>
            <p style="margin-bottom: 2px;">
                <strong>@lang('base/employee_payroll.tab_sncf_2')</strong>
            </p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                        <strong>@lang('base/employee_payroll.entry_source_resource_id'): </strong>
                    </td>
                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                        {{$employee_payroll->sourceResource->name}}
                    </td>
                </tr>
                @if($employee_payroll->sourceResource->code == 'IM'))
                <tr>
                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                        <strong>@lang('base/employee_payroll.entry_sncf_amount_source_resource'): </strong>
                    </td>
                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                        {{\App\Helpers\Helper::numberFormatMoney($employee_payroll->sncf_amount_source_resource,2)}}
                    </td>
                </tr>
                @endif
            </table>
        </div>
    @endif
    @if(!empty($employee_payroll->cfdi_relation_id))
        <div>
            <p style="margin-bottom: 2px;">
                <strong>@lang('base/employee_payroll.tab_relations') - {{ $employee_payroll->cfdiRelation->name_sat }}</strong>
            </p>
            <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
                <tr>
                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                        @if($employee_payroll->employeePayrollRelations->isNotEmpty())
                            @foreach($employee_payroll->employeePayrollRelations as $result)
                                {{$result->relation->name ?? ''}}<br/>
                            @endforeach
                        @endif
                    </td>
                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                        @if($employee_payroll->employeePayrollRelations->isNotEmpty())
                            @foreach($employee_payroll->employeePayrollRelations as $result)
                                {{$result->uuid_related}}<br/>
                            @endforeach
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    @endif
    <div class="text-center">
        <small>@lang('general.text_cfdi')</small>
    </div>
</section>
</body>
</html>
