<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8"/>
    <title>{{$customer_invoice->documentType->name}}-{{$customer_invoice->name}}</title>
    <link href="{{ public_path('css/custom_pdf.css') }}" rel="stylesheet">
    <style type="text/css">
        @page {
            margin-top: 310px;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
        }

        .footer {
            bottom: 10px;
            font-size: 7pt;
            color: #333333;
        }

        .pagenum:before {
            content: counter(page);
        }

        .text-primary {
            color: {{ \App\Helpers\Helper::companyColorPrimary($customer_invoice->company_id) }}   !important;
        }

        .table-items thead th {
            background-color: {{ \App\Helpers\Helper::companyColorPrimary($customer_invoice->company_id) }}   !important;
        }
    </style>
</head>
<body style="background-color: white;">
<section class="header" style="top: -287px;">
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td colspan="2" class="text-right">
                <h1>{{ mb_strtoupper($customer_invoice->documentType->name) }}</h1>
            </td>
        </tr>
        <tr>
            <td width="50%" style="vertical-align: top; padding-top: 10px;">
                    <img src="{{ \App\Helpers\Helper::logoCompanyDocs($customer_invoice->company_id) }}" class="invoice-logo" width="170px"/>
            </td>
            <td width="50%" class="text-right text-company" style="vertical-align: top; padding-top: 10px;">
                <span><strong>{{ mb_strtoupper($customer_invoice->company->name) }}</strong></span>
                <br/>
                <span>{{ $customer_invoice->company->taxRegimen->name_sat }}</span>
                <br/>
                <span>{{ $customer_invoice->company->address_1 ?? '' }} {{ $customer_invoice->company->address_2 ?? '' }} {{ $customer_invoice->company->address_3 ?? '' }} {{ $customer_invoice->company->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_invoice->company->city->name ?? '' }}, {{ ($customer_invoice->company->state->name ?? '') }}</span>
                <br/>
                <span>{{ $customer_invoice->company->country->name ?? '' }}{!! ($customer_invoice->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $customer_invoice->company->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($customer_invoice->company->taxid) }}</span>
                <br/>
                <span>---</span>
                <br/>
                <span>{{ $customer_invoice->company->phone ?? ' ' }}</span>
                <br/>
                <span>{{ $customer_invoice->company->email ?? ' ' }}</span>
            </td>
        </tr>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary"># {{ $customer_invoice->name }}</span>

            </td>
            <td width="50%" style="border-bottom: 1px solid #cccccc; padding-bottom: 5px;">
                <span class="text-primary">{{ mb_strtoupper(__('general.text_customer')) }}</span>
            </td>
        </tr>
        <tr>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>@lang('general.text_cfdi_uuid')
                        : </strong>{{ $customer_invoice->customerInvoiceCfdi->uuid ?? '' }}</span>
                <br/>
                <span><strong>@lang('base/document_type.entry_cfdi_type_id')
                        : </strong>{{ $customer_invoice->documentType->cfdiType->name_sat ?? '' }}</span>
                <br/>
                <span><strong>@lang('sales/customer_invoice.entry_date')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDateTime($customer_invoice->date) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_invoice.entry_date_due')
                        : </strong>{{ \App\Helpers\Helper::convertSqlToDate($customer_invoice->date_due) }}</span>
                <br/>
                <span><strong>@lang('sales/customer_invoice.entry_payment_term_id')
                        : </strong>{{ $customer_invoice->paymentTerm->name }}</span>
                <br/>
                <span><strong>@lang('sales/customer_invoice.entry_cfdi_use_id')
                        : </strong>{{ $customer_invoice->cfdiUse->name_sat }}</span>
                <br/>
                <span><strong>@lang('general.text_issued_in')
                        : </strong>{{ $customer_invoice->branchOffice->name ?? '' }} {!! ($customer_invoice->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $customer_invoice->branchOffice->postcode : '') !!}</span>
                <br/>
            </td>
            <td width="50%" class="text-head" style="vertical-align: top; padding-top: 7px;">
                <span><strong>{{ mb_strtoupper($customer_invoice->customer->name) }}</strong></span>
                <br/>
                <span>{{ $customer_invoice->customer->address_1 ?? '' }} {{ $customer_invoice->customer->address_2 ?? '' }} {{ $customer_invoice->customer->address_3 ?? '' }} {{ $customer_invoice->customer->address_4 ?? '' }}</span>
                <br/>
                <span>{{ $customer_invoice->customer->city->name ?? '' }}
                    , {{ $customer_invoice->customer->state->name ?? '' }}</span>
                <br/>
                <span>{{ $customer_invoice->customer->country->name ?? '' }}{!! ($customer_invoice->customer->postcode ? '&nbsp;&nbsp;' . __('sales/customer.entry_postcode') . ': ' . $customer_invoice->customer->postcode : '') !!}</span>
                <br/>
                <span>{{ mb_strtoupper($customer_invoice->customer->taxid) }}</span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="footer">
    <hr>
    <div>
    <table cellpadding="0" cellspacing="0" class="" width="100%">
        <tr>
            <td width="25%">
                <span>{{!empty(config('app.cfdi_footer')) ? config('app.cfdi_footer')  : config('app.name') . ' ' . 'v.' . config('app.version') }}</span>
            </td>
            <td width="50%" class="text-center">
                @lang('general.text_cfdi')
            </td>
            <td width="25%" class="text-right">
                @lang('general.text_page') <span class="pagenum"></span>
            </td>
        </tr>
    </table>
    </div>
</section>
<section class="watermark" style="bottom: 540px !important;">
    <span>@lang('general.text_invalid_cfdi')</span>
</section>
<section>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-items" width="100%">
        <thead>
        <tr>
            <th class="text-left">{{ mb_strtoupper(__('sales/customer_invoice.column_line_name')) }}</th>
            <th width="9%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_sat_product_id')) }}</th>
            <th width="14%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_unit_measure_id')) }}</th>
            <th width="8%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_quantity')) }}</th>
            <th width="10%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_price_unit')) }}</th>
            <th width="7%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_discount')) }}</th>
            <th width="11%">{{ mb_strtoupper(__('sales/customer_invoice.column_line_amount_untaxed')) }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($customer_invoice->customerActiveInvoiceLines as $result)
            <tr>
                <td>{!! nl2br($result->name) !!}</td>
                <td class="text-center">{{ $result->satProduct->code }}</td>
                <td class="text-center">{{ $result->unitMeasure->name_sat }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->quantity,$result->unitMeasure->decimal_place) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($result->price_unit,\App\Helpers\Helper::companyProductPriceDecimalPlace($customer_invoice->company_id)) }}</td>
                <td class="text-center">{{ \App\Helpers\Helper::numberFormat($result->discount,2) }}</td>
                <td class="text-right">{{ money($result->amount_untaxed,$customer_invoice->currency->code,true) }}</td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr>
            <td colspan="4" class="text-center" style="vertical-align: bottom;">
                <span style="line-height: 16px;">***({{\App\Helpers\Helper::numberToWordCurrency($customer_invoice->amount_total,$customer_invoice->currency->code,$customer_invoice->currency->decimal_place)}}
                    )***</span>
            </td>
            <td colspan="2" class="text-right" style="vertical-align: top; padding-right: 4px;">
                <strong>@lang('general.text_amount_untaxed')</strong><br/>
                @if($customer_invoice->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_invoice->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;"><strong>{{$result->name}}</strong></span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ mb_strtoupper(__('general.text_amount_total')) }}</strong></span>
            </td>
            <td class="text-right">
                {{ money($customer_invoice->amount_untaxed,$customer_invoice->currency->code,true) }}<br/>
                @if($customer_invoice->customerInvoiceTaxes->isNotEmpty())
                    @foreach($customer_invoice->customerInvoiceTaxes as $result)
                        <span style="line-height: 16px;">{{ money(abs($result->amount_tax),$customer_invoice->currency->code,true) }}</span><br/>
                    @endforeach
                @endif
                <span style="line-height: 16px;"><strong>{{ money($customer_invoice->amount_total,$customer_invoice->currency->code,true) }}</strong></span>
            </td>
        </tr>
        </tfoot>
    </table>
    </div>
    <div>
    <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" style="margin-top: 5px;">
        <tr>
            <td width="100%" style="vertical-align: top; padding: 5px;">
                <span><strong>@lang('sales/customer_invoice.entry_payment_way_id')
                        : </strong>{{ $customer_invoice->paymentWay->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/customer_invoice.entry_payment_method_id')
                        : </strong>{{ $customer_invoice->paymentMethod->name_sat }}</span>
                <br/>
                <span><strong>@lang('sales/customer_invoice.entry_currency_id')
                        : </strong>{{ $customer_invoice->currency->code }}{!! ($customer_invoice->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('sales/customer_invoice.entry_currency_value').':</strong> '.round($customer_invoice->currency_value,4) :'') !!}</span>
                <br/>
            </td>
        </tr>
    </table>
    </div>
    @if(!empty($customer_invoice->cfdi_relation_id))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_invoice.tab_relations')
                - {{ $customer_invoice->cfdiRelation->name_sat }} </strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%" >
            <tr>
                <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                    @if($customer_invoice->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_invoice->customerInvoiceRelations as $result)
                            {{$result->relation->name}}<br/>
                        @endforeach
                    @endif
                </td>
                <td width="85%" style="vertical-align: middle; padding: 5px;">
                    @if($customer_invoice->customerInvoiceRelations->isNotEmpty())
                        @foreach($customer_invoice->customerInvoiceRelations as $result)
                            {{$result->relation->customerInvoiceCfdi->uuid}}<br/>
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif
    @if(!empty($customer_invoice->comment))
        <div>
        <p style="margin-bottom: 2px;"><strong>@lang('sales/customer_invoice.entry_comment')</strong></p>
        <table cellpadding="0" cellspacing="0" class="table-secundary" width="100%">
            <tr>
                <td width="100%" style="vertical-align: top; padding: 5px;">
                    {!! nl2br($customer_invoice->comment) !!}
                </td>
            </tr>
        </table>
        </div>
    @endif
</section>
</body>
</html>
