@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/employee.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/employee.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                    <div class="col-md-5 col-xs-12 pull-right">
                        <a href="{{route('employees.index',request()->except('page'))}}"
                           class="btn btn-sm btn-default">@lang('general.button_discard')
                        </a>
                    </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'employees.store','method' => 'POST','class' => '','role' => 'form','id'=>'form']) !!}
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_general" id="general-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('general.tab_general')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade active in" id="tab_general"
                                         aria-labelledby="general-tab">
                                        <div class="row">
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('code') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('code', __('base/employee.entry_code') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('code', old('code'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_code'),'required','autofocus']) !!}
                                                    @if ($errors->has('code'))
                                                        <span class="help-block"><small>{{ $errors->first('code') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('firstname') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('firstname', __('base/employee.entry_firstname') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('firstname', old('firstname'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/employee.entry_firstname'),'required']) !!}
                                                    @if ($errors->has('firstname'))
                                                        <span class="help-block"><small>{{ $errors->first('firstname') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('lastname') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('lastname', __('base/employee.entry_lastname') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('lastname', old('lastname'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/employee.entry_lastname'),'required']) !!}
                                                    @if ($errors->has('lastname'))
                                                        <span class="help-block"><small>{{ $errors->first('lastname') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('lastname2') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('lastname2', __('base/employee.entry_lastname2') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('lastname2', old('lastname2'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/employee.entry_lastname2')]) !!}
                                                    @if ($errors->has('lastname2'))
                                                        <span class="help-block"><small>{{ $errors->first('lastname2') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('taxid') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('taxid', __('base/employee.entry_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('taxid', old('taxid'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/employee.entry_taxid'),'required']) !!}
                                                    @if ($errors->has('taxid'))
                                                        <span class="help-block"><small>{{ $errors->first('taxid') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('tax_regimen_id', __('base/employee.entry_tax_regimen_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('tax_regimen_id', $tax_regimens,old('tax_regimen_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('tax_regimen_id'))
                                                        <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('curp') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('curp', __('base/employee.entry_curp') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('curp', old('curp'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_curp'),'required']) !!}
                                                    @if ($errors->has('curp'))
                                                        <span class="help-block"><small>{{ $errors->first('curp') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('postcode') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('postcode', __('base/employee.entry_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('postcode', old('postcode'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_postcode')]) !!}
                                                    @if ($errors->has('postcode'))
                                                        <span class="help-block"><small>{{ $errors->first('postcode') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('email', __('base/employee.entry_email') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_email')]) !!}
                                                    @if ($errors->has('email'))
                                                        <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('recruitment_regime_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('recruitment_regime_id', __('base/employee.entry_recruitment_regime_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('recruitment_regime_id', $recruitment_regimes,null, ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('recruitment_regime_id'))
                                                        <span class="help-block"><small>{{ $errors->first('recruitment_regime_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('date_start_work') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('date_start_work', __('base/employee.entry_date_start_work') . '', ['class' => 'control-label'])) !!}
                                                    <div class="input-group input-group-sm">
                                                        {!! Form::text('date_start_work', old('date_start_work'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_date_start_work'),'autocomplete'=>'off']) !!}
                                                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    </div>
                                                    @if ($errors->has('date_start_work'))
                                                        <span class="help-block"><small>{{ $errors->first('date_start_work') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('nss') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('nss', __('base/employee.entry_nss') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('nss', old('nss'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_nss')]) !!}
                                                    @if ($errors->has('nss'))
                                                        <span class="help-block"><small>{{ $errors->first('nss') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('unionized', __('base/employee.entry_unionized') , ['class' => 'control-label'])) !!}
                                                    <br/>
                                                    <label>
                                                        {!! Form::checkbox('unionized', '1',(!empty(old('unionized',false)) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('workday_type_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('workday_type_id', __('base/employee.entry_workday_type_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('workday_type_id', $workday_types,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('workday_type_id'))
                                                        <span class="help-block"><small>{{ $errors->first('workday_type_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('contract_type_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('contract_type_id', __('base/employee.entry_contract_type_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('contract_type_id', $contract_types,null, ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('contract_type_id'))
                                                        <span class="help-block"><small>{{ $errors->first('contract_type_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('employee_category_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('employee_category_id', __('base/employee.entry_employee_category_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('employee_category_id', $employee_categories,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('employee_category_id'))
                                                        <span class="help-block"><small>{{ $errors->first('employee_category_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('department', __('base/employee.entry_department') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('department', old('department'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_department')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('job', __('base/employee.entry_job') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('job', old('job'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_job')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('job_risk_classe_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('job_risk_classe_id', __('base/employee.entry_job_risk_classe_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('job_risk_classe_id', $job_risk_classes,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('job_risk_classe_id'))
                                                        <span class="help-block"><small>{{ $errors->first('job_risk_classe_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('frequency_payment_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('frequency_payment_id', __('base/employee.entry_frequency_payment_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('frequency_payment_id', $frequency_payments,null, ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('frequency_payment_id'))
                                                        <span class="help-block"><small>{{ $errors->first('frequency_payment_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('bank_id', __('base/employee.entry_bank_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('bank_id', $banks,null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('bank_account', __('base/employee.entry_bank_account') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('bank_account', old('bank_account'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_bank_account')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-5">
                                                <div class="form-group form-group-sm{{ $errors->has('base_salary') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('base_salary', __('base/employee.entry_base_salary') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('base_salary', old('base_salary'), ['class' => 'form-control text-right', 'placeholder' => __('base/employee.entry_base_salary'),'step' => 'any']) !!}
                                                    @if ($errors->has('base_salary'))
                                                        <span class="help-block"><small>{{ $errors->first('base_salary') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-5">
                                                <div class="form-group form-group-sm{{ $errors->has('sdi') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('sdi', __('base/employee.entry_sdi') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::number('sdi', old('sdi'), ['class' => 'form-control text-right', 'placeholder' => __('base/employee.entry_sdi'),'step' => 'any']) !!}
                                                    @if ($errors->has('sdi'))
                                                        <span class="help-block"><small>{{ $errors->first('sdi') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('country_id', __('base/employee.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('country_id'))
                                                        <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('state_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('state_id', __('base/employee.entry_state_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('state_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                    @if ($errors->has('state_id'))
                                                        <span class="help-block"><small>{{ $errors->first('state_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('phone', __('base/employee.entry_phone') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('phone', old('phone'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_phone')]) !!}
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('phone_mobile', __('base/employee.entry_phone_mobile') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::text('phone_mobile', old('phone_mobile'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_phone_mobile')]) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;&nbsp;
                                    <a href="{{route('employees.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });
            $("#form input[name='date_start_work']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='date_start_work']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            /* Selecciona pais */
            $("#form select[name='country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{ old('state_id') }}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");
        });

    </script>
@endsection
