@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/employee.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('vendor/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/employee.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('employees.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        @lang('general.error_upload_file')
                        <ul>
                            @foreach ($errors->all() as $key => $error)
                                <li>{!! $error  !!}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('base/employee.text_import_title')</h2>
                            <div class="clearfix"></div>
                            <p>@lang('base/employee.text_import_subtitle')</p>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'employees/download-template-import','method' => 'POST','class' => '','role' => 'form','id'=>'form1']) !!}
                            <!-- input hidden -->
                            {!! Form::hidden('update', old('update')) !!}
                            <!-- /.input hidden -->
                                <div class="table-responsive table-data">
                                    <table class="table table-striped table-hover table-condensed">
                                        <thead>
                                        <tr class="mini">
                                            <th class="text-center">@lang('base/employee.entry_code')</th>
                                            <th class="text-left">@lang('base/employee.entry_firstname')</th>
                                            <th class="text-left">@lang('base/employee.entry_lastname')</th>
                                            <th class="text-left">@lang('base/employee.entry_lastname2')</th>
                                            <th class="text-center">@lang('base/employee.entry_taxid')</th>
                                            <th class="text-center">@lang('base/employee.entry_tax_regimen_id')</th>
                                            <th class="text-center">@lang('base/employee.entry_curp')</th>
                                            <th class="text-center">@lang('base/employee.entry_postcode')</th>
                                            <th class="text-center">@lang('base/employee.entry_nss')</th>
                                            <th class="text-center">@lang('base/employee.entry_email')</th>
                                            <th class="text-left">@lang('base/employee.entry_recruitment_regime_id')</th>
                                            <th class="text-center">@lang('base/employee.entry_date_start_work')</th>
                                            <th class="text-center">@lang('base/employee.entry_unionized')</th>
                                            <th class="text-left">@lang('base/employee.entry_workday_type_id')</th>
                                            <th class="text-left">@lang('base/employee.entry_contract_type_id')</th>
                                            <th class="text-left">@lang('base/employee.entry_employee_category_id')</th>
                                            <th class="text-left">@lang('base/employee.entry_department')</th>
                                            <th class="text-left">@lang('base/employee.entry_job')</th>
                                            <th class="text-left">@lang('base/employee.entry_job_risk_classe_id')</th>
                                            <th class="text-left">@lang('base/employee.entry_frequency_payment_id')</th>
                                            <th class="text-left">@lang('base/employee.entry_bank_id')</th>
                                            <th class="text-left">@lang('base/employee.entry_bank_account')</th>
                                            <th class="text-right">@lang('base/employee.entry_base_salary')</th>
                                            <th class="text-right">@lang('base/employee.entry_sdi')</th>
                                            <th class="text-center">@lang('base/employee.entry_country_id')</th>
                                            <th class="text-center">@lang('base/employee.entry_state_id')</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($import_results as $result)
                                            <tr class="">
                                                <td class="text-center">{{$result->code}}</td>
                                                <td class="text-left">{{$result->firstname}}</td>
                                                <td class="text-left">{{$result->lastname}}</td>
                                                <td class="text-left">{{$result->lastname2}}</td>
                                                <td class="text-center">{{$result->taxid}}</td>
                                                <td class="text-center">{{$result->tax_regimen}}</td>
                                                <td class="text-center">{{$result->curp}}</td>
                                                <td class="text-center">{{$result->postcode}}</td>
                                                <td class="text-center">{{$result->nss}}</td>
                                                <td class="text-center">{{$result->email}}</td>
                                                <td class="text-left">{{$result->recruitment_regime}}</td>
                                                <td class="text-center">{{$result->date_start_work}}</td>
                                                <td class="text-center">{{$result->unionized}}</td>
                                                <td class="text-left">{{$result->workday_type}}</td>
                                                <td class="text-left">{{$result->contract_type}}</td>
                                                <td class="text-left">{{$result->employee_category}}</td>
                                                <td class="text-left">{{$result->department}}</td>
                                                <td class="text-left">{{$result->job}}</td>
                                                <td class="text-left">{{$result->job_risk_classe}}</td>
                                                <td class="text-left">{{$result->frequency_payment}}</td>
                                                <td class="text-left">{{$result->bank}}</td>
                                                <td class="text-left">{{$result->bank_account}}</td>
                                                <td class="text-right">{{$result->base_salary}}</td>
                                                <td class="text-right">{{$result->sdi}}</td>
                                                <td class="text-center">{{$result->country}}</td>
                                                <td class="text-center">{{$result->state}}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('tax_regimen_id', __('base/employee.entry_tax_regimen_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('tax_regimen_id', $tax_regimens,old('recruitment_regime_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('recruitment_regime_id', __('base/employee.entry_recruitment_regime_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('recruitment_regime_id', $recruitment_regimes,old('recruitment_regime_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('unionized', __('base/employee.entry_unionized') , ['class' => 'control-label'])) !!}
                                            <br/>
                                            <label>
                                                {!! Form::checkbox('unionized', '1',(!empty(old('unionized',false)) ? true : false),['class' => 'js-switch']); !!}
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('workday_type_id', __('base/employee.entry_workday_type_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('workday_type_id', $workday_types,old('workday_type_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('contract_type_id', __('base/employee.entry_contract_type_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('contract_type_id', $contract_types,old('contract_type_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('employee_category_id', __('base/employee.entry_employee_category_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('employee_category_id', $employee_categories,old('employee_category_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('department', __('base/employee.entry_department') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::text('department', old('department'), ['class' => 'form-control', 'placeholder' => __('base/employee.entry_department')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('job_risk_classe_id', __('base/employee.entry_job_risk_classe_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('job_risk_classe_id', $job_risk_classes,old('job_risk_classe_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('frequency_payment_id', __('base/employee.entry_frequency_payment_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('frequency_payment_id', $frequency_payments,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('bank_id', __('base/employee.entry_bank_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('bank_id', $banks,old('bank_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-5">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('base_salary', __('base/employee.entry_base_salary') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::number('base_salary', old('base_salary'), ['class' => 'form-control text-right', 'placeholder' => __('base/employee.entry_base_salary'),'step' => 'any']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-5">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('sdi', __('base/employee.entry_sdi') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::number('sdi', old('sdi'), ['class' => 'form-control text-right', 'placeholder' => __('base/employee.entry_sdi'),'step' => 'any']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                            {!! html_entity_decode(Form::label('country_id', __('base/employee.entry_country_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('state_id', __('base/employee.entry_state_id') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('state_id', [],null, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                        </div>
                                    </div>
                                </div>

                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 text-right footer-form">
                                        {!! Form::button(__('general.button_download_template_update_import'),['type' => 'button', 'class' => 'btn btn-sm btn-success', 'onclick' => 'downloadTemplate(1)']) !!}
                                        &nbsp;&nbsp;
                                        {!! Form::button(__('general.button_download_template_import'),['type' => 'button', 'class' => 'btn btn-sm btn-success', 'onclick' => 'downloadTemplate(null)']) !!}
                                    </div>
                                </div>
                            {!! Form::close() !!}
                            {!! Form::open(['route' => 'employees/import','method' => 'POST','class' => '','role' => 'form','id'=>'form','files' => true]) !!}
                                <input name="file_employees_import" type="file" class="hidden"/>
                                <div class="dropzone mt-3" style="cursor: pointer; position: relative; min-height: 150px; padding-top: 15px;">
                                    <div class="fallback text-center">
                                        <label id="file_employees_import_upload" style="font-size: 12px;"></label>
                                    </div>
                                    <div class="dz-message needsclick text-center" style="padding-top: 10px;">
                                        <i class="fa fa-cloud-upload" style="font-size: 50px;"></i>
                                        <h4 style="">@lang('general.help_upload_file')</h4>
                                    </div>
                                </div>
                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_importar'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('employees.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('vendor/sweetalert2/sweetalert2.min.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">
        function downloadTemplate(update){
            $("#form1 input[name='update']").val(update)
            $("#form1").submit()
        }
        $("#form1 .my-select2").select2({
            placeholder: "@lang('general.text_select')",
            theme: "bootstrap",
            width: "auto",
            dropdownAutoWidth: true,
            allowClear: true,
            language: "{{ str_replace('_', '-', app()->getLocale()) }}",
        });
        /* Selecciona pais */
        $("#form1 select[name='country_id']").on("change", function () {
            var id = $(this).val();
            let state_id = $("#form1 select[name='state_id']");
            state_id.html("<option value=\"\">@lang('general.text_select')</option>");
            if (id) {
                $.ajax({
                    url: "{{ route('countries/get-states') }}",
                    type: "GET",
                    dataType: "JSON",
                    data: "id=" + id + "&state_id=" + "{{ old('state_id') }}",
                    success: function (data) {
                        if (data.html) {
                            state_id.html(data.html);
                        }
                        state_id.trigger("change");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            }
        }).trigger("change");
        $(".dropzone").on("click", function (e) {
            e.preventDefault();
            $("#form input[name='file_employees_import']").trigger("click");
        });
        $("#form input[name='file_employees_import']").change(function(e){
            let fileName = e.target.files[0].name;
            $("#form #file_employees_import_upload").text(fileName).addClass('label label-success font-14');
        });
        $("#form button[type='submit']").on('click',function(e){
            e.preventDefault();
            Pace.track(function () {
                $.ajax({
                    url: "{{ route('employees/before-import') }}",
                    type: "POST",
                    dataType: "JSON",
                    data: new FormData($("#form").get(0)),
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (data) {
                        if (data.success) {
                            Swal.fire({
                                title: "{{__('general.text_are_you_sure')}}",
                                html: data.total_import_employees,
                                type: 'warning',
                                showCancelButton: true,
                                confirmButtonText: "{{__('general.button_yes_import')}}",
                                cancelButtonText: "{{__('general.button_no_cancel')}}",
                                confirmButtonClass: 'btn btn-primary mt-2',
                                cancelButtonClass: 'btn btn-secondary ml-2 mt-2',
                                buttonsStyling: false,
                                onClose: () => {
                                    Ladda.stopAll();
                                }
                            }).then(function (result) {
                                if (result.value) {
                                    $("#form").submit();
                                } else if (
                                    // Read more about handling dismissals
                                    result.dismiss === Swal.DismissReason.cancel
                                ) {
                                    //Cancelar
                                }
                            });
                        }
                    },
                    error: function (error, textStatus, errorThrown) {
                        Ladda.stopAll();
                        if (error.status == 422) {
                            let message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
        });
    </script>
@endsection
