@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/employee.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">
    
    </div>
    
    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            
            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/employee.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('employees.create',request()->except('page'))}}"
                               class="btn btn-sm btn-success">@lang('general.button_add')
                            </a>
                            &nbsp;
                            <a href="{{route('employees/import')}}"
                               class="btn btn-sm btn-default">@lang('general.button_importar')
                            </a>
                            &nbsp;
                            <a href="{{route('employees/export-to-excel',request()->except('page'))}}" class="btn btn-sm btn-excel">
                                @lang('general.button_export_to_excel')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->
            
            <div class="clearfix"></div>
            
            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->
            
            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_list')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->
                            <div class="filter-data">
                                {!! Form::open(['route' => 'employees.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-7 text-left">
                                        <div class="form-inline">
                                            <span>
                                                <span class="hidden-xs">@lang('general.text_item_per_page')</span>
                                                {!! Form::select('limit', $limits,request()->input('limit',setting('list_limit','100')), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'onchange' => 'this.form.submit()']) !!}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-1 text-right">
                                        <div class="form-group form-group-sm">
                                            {!! Form::select('filter_status',['all' => __('general.text_all'), '1' => __('general.text_enableds'),'0' => __('general.text_disableds')], request()->input('filter_status','1'), ['class' => 'form-control','onchange' => '$(\'#form\').submit();' ]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-4 text-right">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('filter_search', request()->input('filter_search'), ['class' => 'form-control', 'placeholder' => __('general.text_search') . '...']) !!}
                                            <span class="input-group-btn">
                                                {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-default']) !!}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th class="text-center">@sortablelink('code',
                                            __('base/employee.column_code'))
                                        </th>
                                        <th class="text-left">@sortablelink('name',
                                            __('base/employee.column_name'))
                                        </th>
                                        <th class="text-center">@sortablelink('taxid',
                                            __('base/employee.column_taxid'))
                                        </th>
                                        <th class="text-center">@sortablelink('curp',
                                            __('base/employee.column_curp'))
                                        </th>
                                        <th class="text-center">@sortablelink('nss',
                                            __('base/employee.column_nss'))
                                        </th>
                                        <th class="text-center">@sortablelink('email',
                                            __('base/employee.column_email'))
                                        </th>
                                        <th class="text-center">@sortablelink('recruitmentRegime.name',
                                            __('base/employee.column_recruitment_regime'))
                                        </th>
                                        <th class="text-center">@sortablelink('employeeCategory',
                                            __('base/employee.column_employee_category'))
                                        </th>
                                        <th class="text-center">@sortablelink('department',
                                            __('base/employee.column_department'))
                                        </th>
                                        <th class="text-center">@sortablelink('job',
                                            __('base/employee.column_job'))
                                        </th>
                                        <th class="text-center">@sortablelink('status',
                                            __('base/employee.column_status'))
                                        </th>
                                        <th class="text-center" width="8%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="{{ (!$result->status ? 'text-muted' : '') }}">
                                            <td class="text-center">{{ $result->code }}</td>
                                            <td class="text-left">
                                                <a href="{{ route('employees.edit',array_merge(['id' => $result->id],request()->except('page'))) }}">{{$result->name}}</a>
                                            </td>
                                            <td class="text-center">{{$result->taxid}}</td>
                                            <td class="text-center">{{$result->curp}}</td>
                                            <td class="text-center">{{$result->nss}}</td>
                                            <td class="text-center">{{ $result->email }}</td>
                                            <td class="text-center">{{ $result->recruitmentRegime->name }}</td>
                                            <td class="text-center">{{ $result->employeeCategory->name ?? '' }}</td>
                                            <td class="text-center">{{$result->department}}</td>
                                            <td class="text-center">{{$result->job}}</td>
                                            <td class="text-center">
                                                @if($result->status)
                                                    <label class="label label-success">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @else
                                                    <label class="label label-default">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @endif
                                            </td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <!-- form -->
                                            {!! Form::open(['route' => ['employees.destroy', $result->id],'method' => 'DELETE','class' => 'hidden','role' => 'form','id' => 'form' . $result->id ]) !!}
                                            {!! Form::close() !!}
                                            <!-- /form -->
                                                <div class="btn-group btn-group-xs text-center text-nowrap" role="group">
                                                    <a href="{{ route('employees.edit',array_merge(['id' => $result->id],request()->except('page'))) }}"
                                                       class="btn btn-xs btn-info"
                                                       title="@lang('general.button_edit')">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                    <a href="javascript:;" class="btn btn-xs btn-danger"
                                                       onclick="$('#form{{$result->id}}').submit();"
                                                       title="@lang('general.button_delete')">
                                                        <i class="fa fa-trash-o"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="12" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->
        
        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });
    
    </script>
@endsection