@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/folio.document_title'))
@section('css_specific')

@endsection
@section('css')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('content')
    <div id="modals">
    
    </div>
    
    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            
            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/folio.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('folios.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->
            
            <div class="clearfix"></div>
            
            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->
            
            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_folio_assignments')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'folios.store','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form']) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('product') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('product', __('base/folio.entry_product') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('product', old('product'), ['class' => 'form-control', 'placeholder' => __('base/folio.entry_product'),'required','autofocus']) !!}
                                        @if ($errors->has('product'))
                                            <span class="help-block"><small>{{ $errors->first('product') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('amount_total') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('amount_total', __('base/folio.entry_amount_total') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('amount_total', old('amount_total'), ['class' => 'form-control', 'placeholder' => __('base/folio.entry_amount_total'),'required']) !!}
                                        @if ($errors->has('amount_total'))
                                            <span class="help-block"><small>{{ $errors->first('amount_total') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('quantity_folio') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('quantity_folio', __('base/folio.entry_quantity_folio') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('quantity_folio', old('quantity_folio'), ['class' => 'form-control', 'placeholder' => __('base/folio.entry_quantity_folio'),'required']) !!}
                                        @if ($errors->has('quantity_folio'))
                                            <span class="help-block"><small>{{ $errors->first('quantity_folio') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('expiry_date') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('expiry_date', __('base/folio.entry_expiry_date') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                        {!! Form::text('expiry_date', old('expiry_date',\App\Helpers\Helper::date(\Date::now()->addDays(30))), ['class' => 'form-control', 'placeholder' => __('base/folio.entry_expiry_date'),'required']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('expiry_date'))
                                            <span class="help-block"><small>{{ $errors->first('expiry_date') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('folios.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->
        
        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*Configura datepicker*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");
            $("#form input[name='expiry_date']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='expiry_date']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
        });
    
    </script>
@endsection