@extends('layouts.installation')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/installation_step_1.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main" style="margin-left: 0;">
        <div class="">

            <!-- Titulo -->

            <!-- /Titulo -->
            <div class="form_wizard wizard_horizontal">
                <h2 class="text-center" style="font-weight: bold; margin-bottom: 25px;">@lang('general.text_installation')</h2>
                <ul class="wizard_steps" style="margin-bottom: 25px; ">
                    <li>
                        <a href="javascript:;" class="selected">
                            <span class="step_no">1</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_1')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="disabled">
                            <span class="step_no">2</span>
                            <span class="step_descr">
                                <span>@lang('general.text_installation_stpe_2')</span>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="disabled">
                            <span class="step_no">3</span>
                            <span class="step_descr">
                                <span>@lang('general.text_installation_stpe_3')</span>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="disabled">
                            <span class="step_no">4</span>
                            <span class="step_descr">
                                <span>@lang('general.text_installation_stpe_4')</span>
                            </span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2 class=""
                                style="float: none; font-weight: bold;">@lang('base/installation_step_1.document_title')</h2>
                            <p class="">@lang('base/installation_step_1.text_help_1')</p>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content" style="padding-top: 15px;">
                        {!! Form::model($company,['route' => ['installation/step-1',$company->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form','files' => true]) !!}
                        <!-- input hidden -->
                        {!! Form::hidden('image', old('image')) !!}
                        <!-- /.input hidden -->

                            <div class="row">
                                <div class="col-md-3 col-xs-12">
                                    <div class="row">
                                        <div class="col-md-12 col-xs-12" style="padding-top: 23px;">
                                            <div class="row">
                                                <div class="col-xs-9 col-md-9">
                                                    <div class="thumbnail">
                                                        <div class="image view view-first">
                                                            <img style="width: 100%; display: block; height: 100%;"
                                                                 class="img-responsive"
                                                                 src="{{!empty($company->image) ? $company->pathImage() : asset('img/no_imagen_340x150.png')}}"
                                                                 data-placeholder="{{asset('img/no_imagen_340x150.png')}}"
                                                                 alt="@lang('base/company.entry_image')"
                                                                 id="img_image"/>
                                                            <div class="mask">
                                                                <p>&nbsp;</p>
                                                                <div class="tools tools-bottom">
                                                                    <a href="#" id="btn_edit_image"
                                                                       title="@lang('general.button_edit')"><i
                                                                                class="fa fa-pencil"></i></a>
                                                                    <a href="#" id="btn_delete_image"
                                                                       title="@lang('general.button_delete')"><i
                                                                                class="fa fa-trash-o"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12 col-xs-12">
                                                    <div class="form-group form-group-sm{{ $errors->has('file_image') ? ' has-error' : '' }}">
                                                        {!! Form::file('file_image', ['class'=> 'hidden']) !!}
                                                        @if ($errors->has('file_image'))
                                                            <span class="help-block"><small>{{ $errors->first('file_image') }}</small></span>
                                                        @endif
                                                    </div>
                                                    {!! Form::button(__('general.button_select'),['type' => 'button', 'class' => 'btn btn-sm btn-default','id' => 'btn_select']) !!}
                                                    <i class="fa fa-info-circle text-info" data-toggle="tooltip" data-placement="top" title="{{__('base/company.help_image')}}"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-9 col-xs-12">
                                    <div class="row">
                                        <div class="col-md-12 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('name', __('base/company.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_name'),'required','autofocus']) !!}
                                                @if ($errors->has('name'))
                                                    <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('taxid') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('taxid', __('base/company.entry_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::text('taxid', old('taxid'), ['class' => 'form-control text-uppercase', 'placeholder' => __('base/company.entry_taxid'),'required']) !!}
                                                @if ($errors->has('taxid'))
                                                    <span class="help-block"><small>{{ $errors->first('taxid') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('tax_regimen_id', __('base/company.entry_tax_regimen_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::select('tax_regimen_id', $tax_regimens,old('tax_regimen_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                @if ($errors->has('tax_regimen_id'))
                                                    <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('email', __('base/company.entry_email') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_email')]) !!}
                                                @if ($errors->has('email'))
                                                    <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('phone', __('base/company.entry_phone') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::text('phone', old('phone'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_phone')]) !!}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 col-xs-12" style="margin-top: 15px;">
                                            <strong class="text-muted">* @lang('base/installation_step_1.text_help_2')</strong>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-3 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('address_1', __('base/company.entry_address_1') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::text('address_1', old('address_1'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_1')]) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('address_2', __('base/company.entry_address_2') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::text('address_2', old('address_2'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_2')]) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('address_3', __('base/company.entry_address_3') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::text('address_3', old('address_3'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_3')]) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-5 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('address_4', __('base/company.entry_address_4') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::text('address_4', old('address_4'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_address_4')]) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('country_id', __('base/company.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                                @if ($errors->has('country_id'))
                                                    <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('state_id', __('base/company.entry_state_id') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::select('state_id', [],old('state_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('city_id', __('base/company.entry_city_id') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::select('city_id', [],old('city_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('postcode') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('postcode', __('base/company.entry_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::text('postcode', old('postcode'), ['class' => 'form-control', 'placeholder' => __('base/company.entry_postcode'),'required']) !!}
                                                @if ($errors->has('postcode'))
                                                    <span class="help-block"><small>{{ $errors->first('postcode') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-center footer-form">
                                    {!! Form::button(__('general.button_save_&_continue'),['type' => 'submit', 'class' => 'btn btn-success ladda-button']) !!}
                                </div>
                            </div>

                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });

            /*File de imagen*/
            $("#form #btn_select").on("click", function (e) {
                e.preventDefault();
                $("#form #btn_edit_image").trigger("click");
            });
            $("#form #btn_edit_image").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_image']").trigger('click');
            });
            $("#form #btn_delete_image").on("click", function (e) {
                e.preventDefault();
                $("#form #img_image").attr('src', $("#form #img_image").attr('data-placeholder'));
                $("#form input[name='image']").val('');
            });
            $("#form input[name='file_image']").on("change", function () { //Precarga imagen para visualizar
                if ($(this)[0].files && $(this)[0].files[0]) {
                    let reader = new FileReader();
                    reader.onload = function (e) {
                        $("#form #img_image").attr("src", e.target.result);
                    };
                    reader.readAsDataURL($(this)[0].files[0]);
                }
            });

            /* Selecciona pais */
            $("#form select[name='country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{old('state_id',$company->state_id)}}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");

            /* Selecciona estado */
            $("#form select[name='state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{old('city_id',$company->city_id)}}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

        });

    </script>
@endsection
