@extends('layouts.installation')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/installation_step_2.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main" style="margin-left: 0;">
        <div class="">

            <!-- Titulo -->

            <!-- /Titulo -->
            <div class="form_wizard wizard_horizontal">
                <h2 class="text-center" style="font-weight: bold; margin-bottom: 25px;">@lang('general.text_installation')</h2>
                <ul class="wizard_steps" style="margin-bottom: 25px; ">
                    <li>
                        <a href="javascript:;" class="done">
                            <span class="step_no">1</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_1')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="selected">
                            <span class="step_no">2</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_2')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="disabled">
                            <span class="step_no">3</span>
                            <span class="step_descr">
                                <span>@lang('general.text_installation_stpe_3')</span>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="disabled">
                            <span class="step_no">4</span>
                            <span class="step_descr">
                                <span>@lang('general.text_installation_stpe_4')</span>
                            </span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2 class=""
                                style="float: none; font-weight: bold;">@lang('base/installation_step_2.document_title')</h2>
                            <p class="">
                                @lang('base/installation_step_2.text_help_1')<br>
                                @lang('base/installation_step_2.text_help_2')<br>
                                @lang('base/installation_step_2.text_help_3')
                            </p>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content" style="padding-top: 15px;">
                        {!! Form::model($company,['route' => ['installation/step-2',$company->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form','files' => true]) !!}
                        <!-- input hidden -->

                        <!-- /.input hidden -->

                            <div class="row">
                                <div class="col-md-6 col-md-offset-3 col-xs-12">
                                    <div class="row">
                                        <div class="col-md-6 col-xs-12">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="thumbnail text-center pt-5 pb-5">
                                                    <i class="fa fa-file fa-5x"></i>
                                                    <p class="pt-4">
                                                    {!! html_entity_decode(Form::label('file_file_cer', __('base/company.entry_file_cer') . '', ['class' => 'control-label'])) !!}
                                                    </p>
                                                    <a href="#" class="btn btn-sm btn-info"
                                                       id="btn_edit_file_cer" title="@lang('general.button_select')">
                                                        @lang('general.button_select')
                                                    </a>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('file_file_cer_ext') ? ' has-error' : '' }}">
                                                    {!! Form::text('input_file_cer', old('',$company->file_cer), ['class' => 'form-control hidden','readonly', 'placeholder' => __('general.text_select'),'readonly','autocomplete'=>'off']) !!}
                                                    {!! Form::file('file_file_cer', ['class'=> 'hidden', 'accept' => '.cer']) !!}
                                                    @if ($errors->has('file_file_cer_ext'))
                                                        <span class="help-block"><small>{{ $errors->first('file_file_cer_ext') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xs-12">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="thumbnail text-center pt-5 pb-5">
                                                    <i class="fa fa-file fa-5x"></i>
                                                    <p class="pt-4">
                                                        {!! html_entity_decode(Form::label('file_file_key', __('base/company.entry_file_key') . '', ['class' => 'control-label'])) !!}
                                                    </p>
                                                    <a href="#" class="btn btn-sm btn-info"
                                                       id="btn_edit_file_key" title="@lang('general.button_select')">
                                                        @lang('general.button_select')
                                                    </a>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('file_file_key_ext') ? ' has-error' : '' }}">
                                                    {!! Form::text('input_file_key', old('',$company->file_key), ['class' => 'form-control hidden','readonly', 'placeholder' => __('general.text_select'),'readonly','autocomplete'=>'off']) !!}
                                                    {!! Form::file('file_file_key', ['class'=> 'hidden', 'accept' => '.key']) !!}
                                                    @if ($errors->has('file_file_key_ext'))
                                                        <span class="help-block"><small>{{ $errors->first('file_file_key_ext') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-md-offset-3 col-xs-12">
                                            <div class="form-group form-group-sm text-center{{ $errors->has('password_key') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('password_key', __('base/company.entry_password_key') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::password('password_key', ['class' => 'form-control text-center', 'placeholder' => __('base/company.entry_password_key'),'required']) !!}
                                                @if ($errors->has('password_key'))
                                                    <span class="help-block"><small>{{ $errors->first('password_key') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-center footer-form">
                                    <a href="{{url('base/installation/step-1')}}"
                                       class="btn btn-default">@lang('general.button_previous')</a>
                                    &nbsp;
                                    <a href="{{url('base/installation/skip-step-2')}}"
                                       class="btn btn-default">@lang('general.button_skip')</a>
                                    &nbsp;
                                    {!! Form::button(__('general.button_save_&_continue'),['type' => 'submit', 'class' => 'btn btn-success ladda-button']) !!}
                                </div>
                            </div>

                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

            /*File de cer*/
            $("#form #btn_edit_file_cer").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_file_cer']").trigger('click');
            });
            $("#form input[name='file_file_cer']").on("change", function () {
                if ($(this)[0].files && $(this)[0].files[0]) {
                    $("#form input[name='input_file_cer']").val($(this)[0].files[0].name);
                    $("#form #btn_edit_file_cer").removeClass('btn-info').addClass('btn-success');
                }
            });

            /*File de key*/
            $("#form #btn_edit_file_key").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_file_key']").trigger('click');
            });
            $("#form input[name='file_file_key']").on("change", function () {
                if ($(this)[0].files && $(this)[0].files[0]) {
                    $("#form input[name='input_file_key']").val($(this)[0].files[0].name);
                    $("#form #btn_edit_file_key").removeClass('btn-info').addClass('btn-success');
                }
            });

        });

    </script>
@endsection
