@extends('layouts.installation')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/installation_step_3.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main" style="margin-left: 0;">
        <div class="">

            <!-- Titulo -->

            <!-- /Titulo -->
            <div class="form_wizard wizard_horizontal">
                <h2 class="text-center" style="font-weight: bold; margin-bottom: 25px;">@lang('general.text_installation')</h2>
                <ul class="wizard_steps" style="margin-bottom: 25px; ">
                    <li>
                        <a href="javascript:;" class="done">
                            <span class="step_no">1</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_1')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="done">
                            <span class="step_no">2</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_2')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="selected">
                            <span class="step_no">3</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_3')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="disabled">
                            <span class="step_no">4</span>
                            <span class="step_descr">
                                <span>@lang('general.text_installation_stpe_4')</span>
                            </span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2 class=""
                                style="float: none; font-weight: bold;">@lang('base/installation_step_3.document_title')</h2>
                            <p class="">@lang('base/installation_step_3.text_help_1')</p>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content" style="padding-top: 15px;">
                            {!! Form::model($branch_office,['route' => ['installation/step-3',$branch_office->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form','files' => true]) !!}


                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('name', __('base/branch_office.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12" style="margin-top: 15px;">
                                    <strong class="text-muted">* @lang('base/installation_step_3.text_help_2')</strong>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('address_1', __('base/branch_office.entry_address_1') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('address_1', !empty(old('address_1')) ? old('address_1') : $company->address_1, ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_1')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-2 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('address_2', __('base/branch_office.entry_address_2') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('address_2', !empty(old('address_2')) ? old('address_2') : $company->address_2, ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_2')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-2 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('address_3', __('base/branch_office.entry_address_3') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('address_3', !empty(old('address_3')) ? old('address_3') : $company->address_3, ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_3')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-5 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('address_4', __('base/branch_office.entry_address_4') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('address_4', !empty(old('address_4')) ? old('address_4') : $company->address_4, ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_address_4')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('country_id', __('base/branch_office.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('country_id', $countries,!empty(old('country_id')) ? old('country_id') : $company->country_id, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('country_id'))
                                            <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('state_id', __('base/branch_office.entry_state_id') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::select('state_id', [],!empty(old('state_id')) ? old('state_id') : $company->state_id, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('city_id', __('base/branch_office.entry_city_id') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::select('city_id', [],!empty(old('city_id')) ? old('city_id') : $company->city_id, ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-2 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('postcode') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('postcode', __('base/branch_office.entry_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::text('postcode', !empty(old('postcode')) ? old('postcode') : $company->postcode, ['class' => 'form-control', 'placeholder' => __('base/branch_office.entry_postcode'),'required']) !!}
                                        @if ($errors->has('postcode'))
                                            <span class="help-block"><small>{{ $errors->first('postcode') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-center footer-form">
                                    <a href="{{url('base/installation/step-2')}}"
                                       class="btn btn-default">@lang('general.button_previous')</a>
                                    &nbsp;
                                    {!! Form::button(__('general.button_save_&_continue'),['type' => 'submit', 'class' => 'btn btn-success ladda-button']) !!}
                                </div>
                            </div>

                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });

            /* Selecciona pais */
            $("#form select[name='country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{(!empty(old('state_id',$branch_office->state_id)) ? old('state_id',$branch_office->state_id) : $company->state_id)}}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                            state_id.trigger("change");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");

            /* Selecciona estado */
            $("#form select[name='state_id']").on("change", function () {
                var id = $(this).val();
                let city_id = $("#form select[name='city_id']");
                city_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('states/get-cities') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&city_id=" + "{{(!empty(old('city_id',$branch_office->city_id)) ? old('city_id',$branch_office->city_id) : $company->city_id)}}",
                        success: function (data) {
                            if (data.html) {
                                city_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });

        });

    </script>
@endsection
