@extends('layouts.installation')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/installation_step_4.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main" style="margin-left: 0;">
        <div class="">

            <!-- Titulo -->

            <!-- /Titulo -->
            <div class="form_wizard wizard_horizontal">
                <h2 class="text-center" style="font-weight: bold; margin-bottom: 25px;">@lang('general.text_installation')</h2>
                <ul class="wizard_steps" style="margin-bottom: 25px; ">
                    <li>
                        <a href="javascript:;" class="done">
                            <span class="step_no">1</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_1')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="done">
                            <span class="step_no">2</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_2')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="done">
                            <span class="step_no">3</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_3')</strong>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:;" class="selected">
                            <span class="step_no">4</span>
                            <span class="step_descr">
                                <strong>@lang('general.text_installation_stpe_4')</strong>
                            </span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2 class=""
                                style="float: none; font-weight: bold;">@lang('base/installation_step_4.text_help_1')</h2>
                            <p class="">@lang('base/installation_step_4.text_help_2')</p>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content" style="padding-top: 15px;">
                            {!! Form::open(['route' => 'installation/step-4','method' => 'POST','class' => 'form-horizontal','role' => 'form','id' => 'form']) !!}


                            <div class="row">
                                <div class="col-md-6 col-md-offset-3 col-xs-12">
                                    <div class="table-responsive table-data">
                                        <table class="table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th class="text-left">
                                                    {{__('base/document_type.column_name')}}
                                                </th>
                                                <th class="text-center">
                                                    {{__('base/document_type.column_prefix')}}
                                                </th>
                                                <th class="text-center">
                                                    {{__('base/document_type.column_next_number')}}
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @php
                                                $item_row = 1;
                                                $items = old('item',$results);
                                            @endphp
                                            @foreach ($items as $item_row => $item)
                                                @php
                                                    $item = !empty(old('item.' . $item_row . '')) ? (object) old('item.' . $item_row) : $item;
                                                @endphp
                                                <tr class="">
                                                    <td class="text-left">
                                                        <!-- input hidden -->
                                                        <input type="hidden" id="item_code_{{ $item_row }}"
                                                               name="item[{{ $item_row }}][code]"
                                                               value="{{ old('item.' . $item_row . '.code',$item->code) }}">
                                                        <!-- /.input hidden -->
                                                        <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.name') ? ' has-error' : '' }}">
                                                            {!! Form::text('item[' . $item_row . '][name]', old('item.' . $item_row . '.name',$item->name), ['class' => 'form-control input-sm', 'required','id' => 'item_name_' . $item_row]) !!}
                                                            @if ($errors->has('item.'.$item_row.'.name'))
                                                                <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.name') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.prefix') ? ' has-error' : '' }}">
                                                            {!! Form::text('item[' . $item_row . '][prefix]', old('item.' . $item_row . '.prefix',$item->prefix), ['class' => 'form-control input-sm text-center', 'required','id' => 'item_prefix_' . $item_row]) !!}
                                                            @if ($errors->has('item.'.$item_row.'.prefix'))
                                                                <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.prefix') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="form-group form-group-sm{{ $errors->has('item.'.$item_row.'.current_number') ? ' has-error' : '' }}">
                                                            {!! Form::number('item[' . $item_row . '][current_number]', old('item.' . $item_row . '.current_number',$item->current_number+1), ['class' => 'form-control input-sm text-center', 'required','id' => 'item_current_number_' . $item_row, 'step' => 'any']) !!}
                                                            @if ($errors->has('item.'.$item_row.'.current_number'))
                                                                <span class="help-block"><small>{{ $errors->first('item.'.$item_row.'.current_number') }}</small></span>
                                                            @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-center footer-form">
                                    <a href="{{url('base/installation/step-3')}}"
                                       class="btn btn-default">@lang('general.button_previous')</a>
                                    &nbsp;
                                    {!! Form::button(__('general.button_save_&_continue'),['type' => 'submit', 'class' => 'btn btn-success ladda-button']) !!}
                                </div>
                            </div>

                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection
