@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/pac.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/pac.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('pacs.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'pacs.store','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form']) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('base/pac.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('code') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('code', __('base/pac.entry_code') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('code', old('code'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_code'),'required']) !!}
                                        @if ($errors->has('code'))
                                            <span class="help-block"><small>{{ $errors->first('code') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('ws_url') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('ws_url', __('base/pac.entry_ws_url') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('ws_url', old('ws_url'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_ws_url'),'required']) !!}
                                        @if ($errors->has('ws_url'))
                                            <span class="help-block"><small>{{ $errors->first('ws_url') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('ws_url_cancel', __('base/pac.entry_ws_url_cancel') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('ws_url_cancel', old('ws_url_cancel'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_ws_url_cancel'),'']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('username', __('base/pac.entry_username') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('username', old('username'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_username'),'']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('password', __('base/pac.entry_password') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::password('password', ['class' => 'form-control', 'placeholder' => __('base/pac.entry_password'),'']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('team_id', __('base/pac.entry_team_id') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('team_id', old('team_id'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_team_id'),'']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('token', __('base/pac.entry_token') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('token', old('token'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_token'),'']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('base/pac.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('base/pac.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('test', __('base/pac.entry_test') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('test', '1',(!empty(old('test')) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('pacs.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection
