@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/payroll.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">
    
    </div>
    
    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            
            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/payroll.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('payrolls.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->
            
            <div class="clearfix"></div>
            
            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if (!$errors->isEmpty())
                    <div class="alert alert-danger alert-dismissable alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        {{ __('general.error_form') }}
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->
            
            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $payroll->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($payroll,['route' => ['payrolls.update',$payroll->id],'method' => 'PUT','class' => '','role' => 'form','id' => 'form']) !!}
                            <!-- input hidden -->
                            <!-- /.input hidden -->
                            <div class="row">
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('name', __('base/payroll.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/payroll.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm">
                                        {!! html_entity_decode(Form::label('reference', __('base/employee_payroll.entry_reference') . '', ['class' => 'control-label'])) !!}
                                        {!! Form::text('reference', old('reference',$payroll->employeePayrolls->first()->reference ?? __('base/employee_payroll.text_reference_assimilated')), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_reference')]) !!}
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('payroll_type_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('payroll_type_id', __('base/payroll.entry_payroll_type_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('payroll_type_id', $payroll_types,old('payroll_type_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('payroll_type_id'))
                                            <span class="help-block"><small>{{ $errors->first('payroll_type_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 col-xs-12">
                                    <div class="form-group form-group-sm{{ $errors->has('branch_office_id') ? ' has-error' : '' }}">
                                        {!! html_entity_decode(Form::label('branch_office_id', __('base/payroll.entry_branch_office_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                        {!! Form::select('branch_office_id', $branch_offices,old('branch_office_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('branch_office_id'))
                                            <span class="help-block"><small>{{ $errors->first('branch_office_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="well alert-important" style="margin: 10px 0 10px 0; padding: 6px 19px;">
                                        <p class="text-center" style="margin: 0;">
                                            @lang('base/payroll.entry_amount_untaxed'): <span id="txt_amount_untaxed">{{ money($payroll->amount_untaxed,$payroll->currency->code,true) }}</span>
                                            &nbsp;&nbsp;&nbsp;
                                            @lang('base/payroll.entry_amount_discount'): <span id="txt_amount_discount">{{ money($payroll->amount_discount,$payroll->currency->code,true) }}</span>
                                            &nbsp;&nbsp;&nbsp;
                                            @lang('base/payroll.entry_amount_isr'): <span id="txt_amount_isr">{{ money($payroll->amount_isr,$payroll->currency->code,true) }}</span>
                                            &nbsp;&nbsp;&nbsp;
                                            <b>@lang('base/payroll.entry_amount_total'): <span id="txt_amount_total">{{ money($payroll->amount_total,$payroll->currency->code,true) }}</span></b>
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_employee_payrolls" id="perceptions-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/payroll.tab_employee_payrolls')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade active in" id="tab_employee_payrolls"
                                         aria-labelledby="perceptions-tab">
                                        <div class="table-responsive table-data">
                                            <table class="table table-striped table-hover table-condensed">
                                                <thead>
                                                <tr class="mini">
                                                    <th class="text-center">@lang('base/employee.entry_curp')</th>
                                                    <th class="text-left">@lang('base/employee.entry_name')</th>
                                                    <th class="text-center">@lang('base/payroll.entry_date_payment')</th>
                                                    <th class="text-center">@lang('base/payroll.entry_date_start_payment')</th>
                                                    <th class="text-center">@lang('base/payroll.entry_date_end_payment')</th>
                                                    <th class="text-center">@lang('base/payroll.entry_payment_days')</th>
                                                    <th class="text-right">@lang('base/employee_payroll.text_amount_untaxed')</th>
                                                    <th class="text-right">@lang('base/employee_payroll.text_amount_discount')</th>
                                                    <th class="text-right">@lang('base/employee_payroll.text_amount_isr')</th>
                                                    <th class="text-right">@lang('base/employee_payroll.text_amount_total')</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($payroll->employeePayrolls as $result)
                                                    <tr class="">
                                                        <td class="text-center">{{ $result->employee->curp }}</td>
                                                        <td class="text-left">{{ $result->employee->name }}</td>
                                                        <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDate($result->date_payment) }}</td>
                                                        <td class="text-center">{{\App\Helpers\Helper::convertSqlToDate($result->date_start_payment)}}</td>
                                                        <td class="text-center">{{\App\Helpers\Helper::convertSqlToDate($result->date_end_payment)}}</td>
                                                        <td class="text-center">{{$result->payment_days}}</td>
                                                        <td class="text-right">{{ money($result->amount_untaxed,$result->currency->code,true) }}</td>
                                                        <td class="text-right">{{ money($result->amount_discount,$result->currency->code,true) }}</td>
                                                        <td class="text-right">{{ money($result->amount_isr,$result->currency->code,true) }}</td>
                                                        <td class="text-right">{{ money($result->amount_total,$result->currency->code,true) }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            
                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;
                                    {!! Form::button(__('general.button_save_&_stamp'),['type' => 'submit', 'class' => 'btn btn-sm btn-info ladda-button','name' => 'save_and_stamp', 'value' => '1']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('payrolls.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->
        
        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*Configura datepicker*/

        });
    
    </script>
@endsection