@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/payroll.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('vendor/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/payroll.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('payrolls.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        @lang('general.error_upload_file')
                        <ul>
                            @foreach ($errors->all() as $key => $error)
                                <li>{!! $error  !!}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('base/payroll.document_title_import_assimilated')</h2>
                            <div class="clearfix"></div>
                            <p>@lang('base/payroll.text_import_subtitle')</p>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'payrolls/download-template-import-assimilated','method' => 'POST','class' => '','role' => 'form','id'=>'form1']) !!}
                            <!-- input hidden -->
                            <!-- /.input hidden -->
                                <div class="table-responsive table-data">
                                    <table class="table table-striped table-hover table-condensed">
                                        <thead>
                                        <tr class="mini">
                                            <th class="text-center">@lang('base/employee.entry_curp')</th>
                                            <th class="text-left">@lang('base/employee.entry_name')</th>
                                            <th class="text-center">@lang('base/payroll.entry_date_payment')</th>
                                            <th class="text-center">@lang('base/payroll.entry_date_start_payment')</th>
                                            <th class="text-center">@lang('base/payroll.entry_date_end_payment')</th>
                                            <th class="text-center">@lang('base/payroll.entry_payment_days')</th>
                                            <th class="text-right">@lang('base/payroll.text_amount_assimilated')</th>
                                            <th class="text-right">@lang('base/payroll.text_amount_isr')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($import_results as $result)
                                            <tr class="">
                                                <td class="text-center">{{$result->employee_curp}}</td>
                                                <td class="text-left">{{$result->employee}}</td>
                                                <td class="text-center">{{$result->date_payment}}</td>
                                                <td class="text-center">{{$result->date_start_payment}}</td>
                                                <td class="text-center">{{$result->date_end_payment}}</td>
                                                <td class="text-center">{{$result->payment_days}}</td>
                                                <td class="text-right">{{$result->amount_assimilated}}</td>
                                                <td class="text-right">{{$result->amount_isr}}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('filter_employee_category_id', __('base/employee.entry_employee_category_id2') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('filter_employee_category_id', $employee_categories,old('filter_employee_category_id'), ['class' => 'form-control', 'placeholder' => __('general.text_all')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('date_payment', __('base/employee_payroll.entry_date_payment') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('date_payment', old('date_payment',\App\Helpers\Helper::date(Date::now())), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_date_payment'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('date_start_payment', __('base/employee_payroll.entry_date_start_payment') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('date_start_payment', old('date_start_payment'), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_date_start_payment'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('date_end_payment', __('base/employee_payroll.entry_date_end_payment') . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::text('date_end_payment', old('date_end_payment'), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_date_end_payment'),'autocomplete'=>'off']) !!}
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-xs-5">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('payment_days', __('base/employee_payroll.entry_payment_days') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::number('payment_days', old('payment_days'), ['class' => 'form-control text-center', 'placeholder' => __('base/employee_payroll.entry_payment_days')]) !!}
                                        </div>
                                    </div>
                                </div>

                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 text-right footer-form">
                                        {!! Form::button(__('general.button_download_template_import'),['type' => 'submit', 'class' => 'btn btn-sm btn-success']) !!}
                                    </div>
                                </div>
                            {!! Form::close() !!}
                            {!! Form::open(['route' => 'payrolls/import-assimilated','method' => 'POST','class' => '','role' => 'form','id'=>'form','files' => true]) !!}
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 mt-3">
                                        <h4>@lang('base/payroll.text_modal_cancel_help4')</h4>
                                        <p>@lang('base/payroll.text_modal_cancel_help4_1')</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3 col-xs-12">
                                        @if($tax_regimens->isNotEmpty())
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('tax_regimen_id', __('base/payroll.entry_tax_regimen_id') . '', ['class' => 'control-label'])) !!}
                                                    {!! Form::select('tax_regimen_id', $tax_regimens,old('tax_regimen_id', \App\Helpers\Helper::defaultCompany()->tax_regimen_id), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    @if ($errors->has('tax_regimen_id'))
                                                        <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                        <div class="col-md-12 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('name', __('base/payroll.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' =>  __('base/payroll.entry_name'),'required']) !!}
                                                @if ($errors->has('name'))
                                                    <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-xs-12">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('reference', __('base/employee_payroll.entry_reference') . '', ['class' => 'control-label'])) !!}
                                                {!! Form::text('reference', old('reference',__('base/employee_payroll.text_reference_assimilated')), ['class' => 'form-control', 'placeholder' => __('base/employee_payroll.entry_reference')]) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('payroll_type_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('payroll_type_id', __('base/employee_payroll.entry_payroll_type_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::select('payroll_type_id', $payroll_types,old('payroll_type_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                @if ($errors->has('payroll_type_id'))
                                                    <span class="help-block"><small>{{ $errors->first('payroll_type_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-xs-12">
                                            <div class="form-group form-group-sm{{ $errors->has('branch_office_id') ? ' has-error' : '' }}">
                                                {!! html_entity_decode(Form::label('branch_office_id', __('base/payroll.entry_branch_office_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                                                {!! Form::select('branch_office_id', $branch_offices,old('branch_office_id',\App\Models\Base\BranchOffice::where('company_id','=',\App\Helpers\Helper::defaultCompany()->id)->get()->first()->id), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                                @if ($errors->has('branch_office_id'))
                                                    <span class="help-block"><small>{{ $errors->first('branch_office_id') }}</small></span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-9 col-xs-12" style="padding-top: 15px;">
                                        <input name="file_payrolls_import" type="file" class="hidden"/>
                                        <div class="dropzone mt-3" style="cursor: pointer; position: relative; min-height: 150px; padding-top: 15px;">
                                            <div class="fallback text-center">
                                                <label id="file_payrolls_import_upload" style="font-size: 12px;"></label>
                                            </div>
                                            <div class="dz-message needsclick text-center" style="padding-top: 10px;">
                                                <i class="fa fa-cloud-upload" style="font-size: 50px;"></i>
                                                <h4 style="">@lang('general.help_upload_file')</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_importar'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('payrolls.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('vendor/sweetalert2/sweetalert2.min.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        function paymentDays() {
            $.ajax({
                url: "{{ route('payrolls/get-payment-days') }}",
                type: "POST",
                dataType: "JSON",
                data: $("#form1").serialize(),
                success: function (data) {
                    if (data) {
                        if(data.payment_days) {
                            $("#form1 input[name='payment_days']").val(data.payment_days);
                            $("#form input[name='name']").val(data.payroll_name);
                        }
                    }
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        }

        moment.locale("{{ substr(app()->getLocale(),0,2) }}");
        $("#form1 input[name='date_payment']").daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
            },
            autoUpdateInput: false
        }, function (chosen_date) {
            $("#form1 input[name='date_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
        });
        $("#form1 input[name='date_start_payment']").daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
            },
            autoUpdateInput: false
        }, function (chosen_date) {
            $("#form1 input[name='date_start_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            paymentDays();
        });
        $("#form1 input[name='date_end_payment']").daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
            },
            autoUpdateInput: false,
        }, function (chosen_date) {
            $("#form1 input[name='date_end_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            paymentDays();
        });
        $(".dropzone").on("click", function (e) {
            e.preventDefault();
            $("#form input[name='file_payrolls_import']").trigger("click");
        });
        $("#form input[name='file_payrolls_import']").change(function(e){
            let fileName = e.target.files[0].name;
            $("#form #file_payrolls_import_upload").text(fileName).addClass('label label-success font-14');
        });
        $("#form button[type='submit']").on('click',function(e){
            e.preventDefault();
            Pace.track(function () {
                $.ajax({
                    url: "{{ route('payrolls/before-import-assimilated') }}",
                    type: "POST",
                    dataType: "JSON",
                    data: new FormData($("#form").get(0)),
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (data) {
                        if (data.success) {
                            Swal.fire({
                                title: "{{__('general.text_are_you_sure')}}",
                                html: data.total_import_payrolls,
                                type: 'warning',
                                showCancelButton: true,
                                confirmButtonText: "{{__('general.button_yes_import')}}",
                                cancelButtonText: "{{__('general.button_no_cancel')}}",
                                confirmButtonClass: 'btn btn-primary mt-2',
                                cancelButtonClass: 'btn btn-secondary ml-2 mt-2',
                                buttonsStyling: false,
                                onClose: () => {
                                    Ladda.stopAll();
                                }
                            }).then(function (result) {
                                if (result.value) {
                                    $("#form").submit();
                                } else if (
                                    // Read more about handling dismissals
                                    result.dismiss === Swal.DismissReason.cancel
                                ) {
                                    //Cancelar
                                }
                            });
                        }
                    },
                    error: function (error, textStatus, errorThrown) {
                        Ladda.stopAll();
                        if (error.status == 422) {
                            let message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
        });
    </script>
@endsection
