@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/employee_payroll.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/employee_payroll.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('employee-payrolls.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            @php
                //Obtiene datos del Cfdi33
                $cfdi33 = !empty($data['cfdi33']) ? $data['cfdi33'] : [];
            @endphp

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $employee_payroll->documentType->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">


                            <section class="content invoice">
                                <!-- title row -->
                                <div class="row">
                                    <div class="col-xs-12 invoice-header">
                                        <h1></h1>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-9 col-xs-12 invoice-col">
                                        <strong style="">{{ mb_strtoupper($employee_payroll->company->name) }}</strong>
                                        <br/>
                                        {{ $employee_payroll->company->taxRegimen->name_sat }}
                                        <br/>
                                        {{ mb_strtoupper($employee_payroll->company->taxid) }}
                                        <br/>
                                        <span>
                                            @if(!empty($employee_payroll->company->address_1) || !empty($employee_payroll->company->address_2) || !empty($employee_payroll->company->address_3) || !empty($employee_payroll->company->address_4))
                                                {{ $employee_payroll->company->address_1 ?? '' }} {{ $employee_payroll->company->address_2 ?? '' }} {{ $employee_payroll->company->address_3 ?? '' }} {{ $employee_payroll->company->address_4 ?? '' }}
                                            @endif
                                            @if(!empty($employee_payroll->company->city->name) || !empty($employee_payroll->company->state->name))
                                                {{ !empty($employee_payroll->company->city->name) ? $employee_payroll->company->city->name . ', ' : '' }}{{ !empty($employee_payroll->company->state->name) ? $employee_payroll->company->state->name . ', ' : '' }}
                                            @endif
                                            {{ $employee_payroll->company->country->name ?? '' }}{!! ($employee_payroll->company->postcode ? '&nbsp;&nbsp;' . __('base/company.entry_postcode') . ': ' . $employee_payroll->company->postcode : '') !!}
                                        </span>
                                    </div>
                                    <div class="col-md-3 col-xs-12 invoice-col text-right">
                                        <strong style="">{{ mb_strtoupper($employee_payroll->documentType->name) }}: {{ $employee_payroll->name }}</strong>
                                        <br/>
                                        <span>@lang('general.text_issued_in'): </span>{{ $employee_payroll->branchOffice->name ?? '' }} {!! ($employee_payroll->branchOffice->postcode ? '<strong>&nbsp;&nbsp;' . __('base/branch_office.entry_postcode') . ':</strong> ' . $employee_payroll->branchOffice->postcode : '') !!}
                                        <br/>
                                        <span>@lang('base/employee_payroll.entry_date'): </span>{{ \App\Helpers\Helper::convertSqlToDateTime($employee_payroll->date) }}
                                        <br/>
                                        <span>@lang('general.text_cfdi_uuid'): </span>{{ $employee_payroll->employeePayrollCfdi->uuid ?? '' }}
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        <strong>{{ mb_strtoupper($employee_payroll->employee->name) }}</strong>
                                    </div>
                                    <div class="col-md-4 col-xs-12 invoice-col">
                                        <strong>@lang('base/employee.entry_taxid'): </strong>{{ mb_strtoupper($employee_payroll->employee->taxid) }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_nss'): </strong>{{ mb_strtoupper($employee_payroll->employee->nss) }}
                                        <br>
                                        <strong>@lang('base/employee.entry_curp'): </strong>{{ mb_strtoupper($employee_payroll->employee->curp) }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_base_salary'): </strong>{{ money($employee_payroll->base_salary,$employee_payroll->currency->code,true) }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_sdi'): </strong>{{ money($employee_payroll->sdi,$employee_payroll->currency->code,true) }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_payment_days'): </strong>{{ \App\Helpers\Helper::numberFormat($employee_payroll->payment_days,3) }}

                                    </div>
                                    <div class="col-md-4 col-xs-12 invoice-col">
                                        <strong>@lang('base/employee.entry_code'): </strong>{{ mb_strtoupper($employee_payroll->employee->code) }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_date_payment'): </strong>{{ \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_payment) }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_date_start_payment'): </strong>{{ $employee_payroll->date_start_payment ? \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_start_payment) : '' }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_date_end_payment'): </strong>{{ $employee_payroll->date_end_payment ? \App\Helpers\Helper::convertSqlToDate($employee_payroll->date_end_payment) : '' }}
                                        <br>
                                        <strong>@lang('base/employee.entry_frequency_payment_id'): </strong>{{ $employee_payroll->employee->frequencyPayment->name_sat ?? '' }}
                                        <br>
                                        <strong>@lang('base/employee.entry_contract_type_id'): </strong>{{ $employee_payroll->employee->contractType->code ?? '' }}
                                    </div>
                                    <div class="col-md-4 col-xs-12 invoice-col">
                                        <strong>@lang('base/employee_payroll.entry_payroll_type_id'): </strong>{{ $employee_payroll->payrollType->name_sat ?? '' }}
                                        <br>
                                        <strong>@lang('base/employee.entry_recruitment_regime_id'): </strong>{{ $employee_payroll->employee->recruitmentRegime->code ?? '' }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_cfdi_use_id'): </strong>{{ $employee_payroll->cfdiUse->code ?? '' }}
                                        <br>
                                        <strong>@lang('base/employee_payroll.entry_state_id'): </strong>{{ $employee_payroll->employee->state->code ?? '' }}
                                        <br>
                                        <strong>@lang('base/employee.entry_department'): </strong>{{ $employee_payroll->employee->department }}
                                        <br>
                                        <strong>@lang('base/employee.entry_job'): </strong>{{ $employee_payroll->employee->job }}
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-center" width="50%">{{ mb_strtoupper(__('base/employee_payroll.tab_perceptions')) }}</th>
                                                    <th class="text-center" width="50%">{{ mb_strtoupper(__('base/employee_payroll.tab_deductions')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td style="background-color: white; padding-right: 5px; border: 0; vertical-align: top;">
                                                        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                                                            <tbody>
                                                            <tr>
                                                                <td class="text-center"><b>{{__('base/employee_payroll.column_line_code2')}}</b></td>
                                                                <td class="text-left"><b>{{__('base/employee_payroll.column_line_perception_id')}}</b></td>
                                                                <td class="text-right"><b>{{__('base/employee_payroll.column_line_amount_total')}}</b></td>
                                                            </tr>
                                                            @if($employee_payroll->employeeActivePerceptionsAllPayrollLines->isNotEmpty())
                                                                @foreach($employee_payroll->employeeActivePerceptionsAllPayrollLines as $result)
                                                                    <tr>
                                                                        <td class="text-center">{{$result->code}}</td>
                                                                        <td class="text-left">{{(!empty($result->perception->name_sat) ? $result->perception->name_sat : (!empty($result->otherPaymentType->name_sat) ? $result->otherPaymentType->name_sat : ''))}}</td>
                                                                        <td class="text-right">{{\App\Helpers\Helper::numberFormatMoney($result->amount_total,2)}}</td>
                                                                    </tr>
                                                                @endforeach
                                                            @endif
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td style="background-color: white; padding-left: 5px; border: 0; vertical-align: top;">
                                                        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                                                            <tbody>
                                                            <tr>
                                                                <td class="text-center"><b>{{__('base/employee_payroll.column_line_code2')}}</b></td>
                                                                <td class="text-left"><b>{{__('base/employee_payroll.column_line_deduction_id')}}</b></td>
                                                                <td class="text-right"><b>{{__('base/employee_payroll.column_line_amount_total')}}</b></td>
                                                            </tr>
                                                            @if($employee_payroll->employeeActiveDeductionsPayrollLines->isNotEmpty())
                                                                @foreach($employee_payroll->employeeActiveDeductionsPayrollLines as $result)
                                                                    <tr>
                                                                        <td class="text-center">{{$result->code}}</td>
                                                                        <td class="text-left">{{$result->deduction->name_sat}}</td>
                                                                        <td class="text-right">{{\App\Helpers\Helper::numberFormatMoney($result->amount_total,2)}}</td>
                                                                    </tr>
                                                                @endforeach
                                                            @endif
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="background-color: white; padding-right: 5px; border: 0; border-top: 1px solid #dddddd; color: #999999;">
                                                        <small>{{\App\Helpers\Helper::companyModulePayrLegend($employee_payroll->company->id)}}</small>
                                                    </td>
                                                    <td style="background-color: white; padding-left: 5px; border: 0; border-top: 1px solid #dddddd;">
                                                        <table cellpadding="0" cellspacing="0" class="table-items" width="100%" border="0">
                                                            <tbody>
                                                            <tr>
                                                                <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_untaxed'))}}</b></td>
                                                                <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_untaxed,2)}}</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_discount'))}}</b></td>
                                                                <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_discount,2)}}</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_isr'))}}</b></td>
                                                                <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_isr,2)}}</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td class="text-right table-items2"><b>{{mb_strtoupper(__('base/employee_payroll.text_amount_total'))}}</b></td>
                                                                <td class="text-right table-items2" style="padding-right: 5px;"><b>{{\App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_total,2)}}</b></td>
                                                            </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 table">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th class="text-left">{{ (__('base/employee_payroll.column_line0_name')) }}</th>
                                                    <th class="text-center" width="15%">{{ (__('base/employee_payroll.column_line0_sat_product_id')) }}</th>
                                                    <th class="text-center" width="14%">{{ (__('base/employee_payroll.column_line0_unit_measure_id')) }}</th>
                                                    <th class="text-center" width="7%">{{ (__('base/employee_payroll.column_line0_quantity')) }}</th>
                                                    <th class="text-center" width="14%">{{ (__('base/employee_payroll.column_line0_price_unit')) }}</th>
                                                    <th class="text-center" width="10%">{{ (__('base/employee_payroll.column_line0_discount')) }}</th>
                                                    <th class="text-center" width="11%">{{ (__('base/employee_payroll.column_line0_amount_untaxed')) }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td>Pago de nómina</td>
                                                    <td class="text-center">84111505</td>
                                                    <td class="text-center">ACT</td>
                                                    <td class="text-center">1</td>
                                                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_untaxed,2) }}</td>
                                                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_discount,2) }}</td>
                                                    <td class="text-center">{{ \App\Helpers\Helper::numberFormatMoney($employee_payroll->amount_total,2) }}</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row" style="margin-bottom: 30px;">
                                    <div class="col-md-6 col-xs-12">
                                        <span><strong>@lang('base/employee_payroll.entry_payment_way_id')
                                                : </strong>{{ $employee_payroll->paymentWay->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('base/employee_payroll.entry_payment_method_id')
                                                : </strong>{{ $employee_payroll->paymentMethod->name_sat }}</span>
                                        <br/>
                                        <span><strong>@lang('base/employee_payroll.entry_currency_id')
                                                : </strong>{{ $employee_payroll->currency->code }}{!! ($employee_payroll->currency->code!='MXN' ? '&nbsp;&nbsp;&nbsp;<strong>'.__('base/employee_payroll.entry_currency_value').':</strong> '.round($employee_payroll->currency_value,4) :'') !!}</span>
                                        <br/>
                                        @if(!empty($cfdi33))
                                            <span><strong>@lang('general.text_cfdi_certificado'): </strong>
                                                {{ $cfdi33['NoCertificado'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_no_certificado_sat'): </strong>
                                                {{ $cfdi33->complemento->timbreFiscalDigital['NoCertificadoSAT'] }}</span>
                                            <br/>
                                            <span><strong>@lang('general.text_cfdi_tfd_fecha_timbrado'): </strong>
                                                {{ \App\Helpers\Helper::convertSqlToDateTime(str_replace('T',' ',$cfdi33->complemento->timbreFiscalDigital['FechaTimbrado'])) }}</span>
                                            <br/>
                                        @endif
                                    </div>
                                    <div class="col-md-6 col-xs-12">
                                    </div>
                                    <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 15px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($employee_payroll->cfdi_relation_id))
                                            <p style="margin-bottom: 2px;"><strong>@lang('base/employee_payroll.tab_relations')
                                                    - {{ $employee_payroll->cfdiRelation->name_sat }} </strong></p>
                                            <table cellpadding="0" cellspacing="0" class="table table-secundary" width="100%">
                                                <tr>
                                                    <td width="15%" class="text-center" style="vertical-align: middle; padding: 5px;">
                                                        @if($employee_payroll->employeePayrollRelations->isNotEmpty())
                                                            @foreach($employee_payroll->employeePayrollRelations as $result)
                                                                {{$result->relation->name}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                    <td width="85%" style="vertical-align: middle; padding: 5px;">
                                                        @if($employee_payroll->employeePayrollRelations->isNotEmpty())
                                                            @foreach($employee_payroll->employeePayrollRelations as $result)
                                                                {{$result->relation->employeePayrollCfdi->uuid}}<br/>
                                                            @endforeach
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                                <!-- info row -->
                                <div class="row invoice-info" style="margin-bottom: 20px;">
                                    <div class="col-md-12 col-xs-12 invoice-col">
                                        @if(!empty($cfdi33))
                                            <table cellpadding="0" cellspacing="0" class="table" width="100%"
                                                   style="margin-top: 5px; table-layout: fixed;">
                                                <tr>
                                                    <td width="23%" class="text-center" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <img src="{{ $data['qr'] }}" width="137px" style="margin: 9px 0;"/>
                                                    </td>
                                                    <td width="77%" style="vertical-align: middle; padding: 5px; word-wrap:break-word;">
                                                        <strong>@lang('general.text_cfdi_tfd_cadena_origen') </strong><br/>
                                                        <small>{{ $data['tfd_cadena_origen'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_cfdi') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloCFD'] }}</small>
                                                        <br/>
                                                        <strong>@lang('general.text_cfdi_tfd_sello_sat') </strong><br/>
                                                        <small>{{ $cfdi33->complemento->timbreFiscalDigital['SelloSAT'] }}</small>
                                                        <br/>
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    </div>
                                </div>
                                <!-- /.row -->
                            </section>


                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

    </script>
@endsection