@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/setting.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/mjolnic-bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/iCheck/skins/flat/green.css') }}" rel="stylesheet"/>
    <link href="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/google-code-prettify/bin/prettify.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/setting.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('home',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_content">
                            {!! Form::model($setting,['url' => ['base/settings'],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form', 'files'=>true, 'onSubmit' => '$("textarea[name=\'modulecq_terms_of_sale\']").val($("#editor-one").html());']) !!}
                            <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#tab_general" id="general-tab" role="tab" data-toggle="tab"
                                           aria-expanded="true">@lang('base/setting.tab_general')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_customer_quotations" id="customer-quotations-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('base/setting.tab_active_inactive_modules')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_pdf_templates" id="pdf-templates-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('base/setting.tab_pdf_templates')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_complements" id="complements-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('base/setting.tab_complements')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_dropbox" id="dropbox-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('base/setting.tab_dropbox')</a>
                                    </li>
                                    <li role="presentation" class="">
                                        <a href="#tab_system" id="system-tab" role="tab" data-toggle="tab"
                                           aria-expanded="false">@lang('base/setting.tab_system')</a>
                                    </li>
                                </ul>
                                <div id="myTabContent" class="tab-content">
                                    <div role="tabpanel" class="tab-pane fade active in" id="tab_general"
                                         aria-labelledby="general-tab">
                                        <div class="row">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('product_price_decimal_place', __('base/setting.entry_product_price_decimal_place') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::number('product_price_decimal_place', old('product_price_decimal_place'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_product_price_decimal_place')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('color_primary', __('base/setting.entry_color_primary') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('color_primary', old('color_primary'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_color_primary')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('show_product_code_on_pdf', __('base/setting.entry_show_product_code_on_pdf') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('show_product_code_on_pdf', '1',(!empty(old('show_product_code_on_pdf',$setting['show_product_code_on_pdf'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('folios_per_branch_office', __('base/setting.entry_folios_per_branch_office') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('folios_per_branch_office', '1',(!empty(old('folios_per_branch_office',$setting['folios_per_branch_office'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('branch_office_logo_docs', __('base/setting.entry_branch_office_logo_docs') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('branch_office_logo_docs', '1',(!empty(old('branch_office_logo_docs',$setting['branch_office_logo_docs'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            @if(Auth::user()->superadmin)
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('multi_taxid', __('base/setting.entry_multi_taxid') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('multi_taxid', '1',(!empty(old('multi_taxid',$setting['multi_taxid'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('customers_per_taxid', __('base/setting.entry_customers_per_taxid') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('customers_per_taxid', '1',(!empty(old('customers_per_taxid',$setting['customers_per_taxid'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('products_per_taxid', __('base/setting.entry_products_per_taxid') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('products_per_taxid', '1',(!empty(old('products_per_taxid',$setting['products_per_taxid'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="hidden form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('validate_taxid_insigna', __('base/setting.entry_validate_taxid_insigna') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('validate_taxid_insigna', '1',(!empty(old('validate_taxid_insigna',$setting['validate_taxid_insigna'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                    <br/>
                                                    <a href="https://www.insigna.mx" class="text-primary" target="_blank"><i>...@lang('base/setting.text_link_validate_taxid_insigna')</i></a>
                                                </div>
                                            </div>
                                            <div class="hidden form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('validate_taxid_insigna_url', __('base/setting.entry_validate_taxid_insigna_url') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('validate_taxid_insigna_url', old('validate_taxid_insigna_url'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_validate_taxid_insigna_url')]) !!}
                                                </div>
                                            </div>
                                            <div class="hidden form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('validate_taxid_insigna_user', __('base/setting.entry_validate_taxid_insigna_user') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('validate_taxid_insigna_user', old('validate_taxid_insigna_user'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_validate_taxid_insigna_user')]) !!}
                                                </div>
                                            </div>
                                            <div class="hidden form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('validate_taxid_insigna_password', __('base/setting.entry_validate_taxid_insigna_password') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::password('validate_taxid_insigna_password', ['class' => 'form-control', 'placeholder' => __('base/setting.entry_validate_taxid_insigna_password')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('enabled_projects', __('base/setting.entry_enabled_projects') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('enabled_projects', '1',(!empty(old('enabled_projects',$setting['enabled_projects'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('projects_per_taxid', __('base/setting.entry_projects_per_taxid') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('projects_per_taxid', '1',(!empty(old('projects_per_taxid',$setting['projects_per_taxid'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('projects_logo_docs', __('base/setting.entry_projects_logo_docs') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('projects_logo_docs', '1',(!empty(old('projects_logo_docs',$setting['projects_logo_docs'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('disable_pedimento', __('base/setting.entry_disable_pedimento') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('disable_pedimento', '1',(!empty(old('disable_pedimento',$setting['disable_pedimento'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('disable_includes_iva_fix_amount_untaxed', __('base/setting.entry_disable_includes_iva_fix_amount_untaxed') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('disable_includes_iva_fix_amount_untaxed', '1',(!empty(old('disable_includes_iva_fix_amount_untaxed',$setting['disable_includes_iva_fix_amount_untaxed'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm hidden">
                                                {!! html_entity_decode(Form::label('add_cfd_download_to_dashboard', __('base/setting.entry_add_cfd_download_to_dashboard') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('add_cfd_download_to_dashboard', '1',(!empty(old('add_cfd_download_to_dashboard',$setting['add_cfd_download_to_dashboard'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('login_iframe', __('base/setting.entry_login_iframe') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::textarea('login_iframe', str_replace('{--url--}',route('login-iframe'),__('base/setting.text_login_iframe')), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_login_iframe'),'rows' => '4']) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_customer_quotations"
                                         aria-labelledby="customer-quotations-tab">
                                        <div class="row">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('module_customer_quotations', __('base/setting.entry_module_customer_quotations') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('module_customer_quotations', '1',(!empty(old('module_customer_quotations',$setting['module_customer_quotations'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('modulecq_terms_of_sale', __('base/setting.entry_modulecq_terms_of_sale') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    @include('layouts.partials.commons.editor_toolbar')

                                                    <div id="editor-one" class="editor-wrapper" contenteditable="true">
                                                        {!! $setting['modulecq_terms_of_sale'] ?? '' !!}
                                                    </div>
                                                    <textarea name="modulecq_terms_of_sale" id="modulecq_terms_of_sale" style="display:none;"></textarea>
                                                </div>
                                            </div>
                                            <div class="ln_solid"></div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('module_customer_remissions', __('base/setting.entry_module_customer_remissions') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('module_customer_remissions', '1',(!empty(old('module_customer_remissions',$setting['module_customer_remissions'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="ln_solid"></div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('module_payroll', __('base/setting.entry_module_payroll') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('module_payroll', '1',(!empty(old('module_payroll',$setting['module_payroll'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('modulepayr_legend', __('base/setting.entry_modulepayr_legend') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::textarea('modulepayr_legend', old('modulepayr_legend',$setting['modulepayr_legend'] ?? ''), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_modulepayr_legend'),'rows' => '4']) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_pdf_templates"
                                         aria-labelledby="pdf-templates-tab">
                                        <div class="row">
                                            <div class="col-md-2 col-md-offset-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/default.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_default')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/default.png')}}" alt="@lang('base/setting.text_pdf_template_default')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_default') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','default', ((!isset($setting['pdf_template']) || $setting['pdf_template'] == 'default') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/template1.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_template1')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/template1.png')}}" alt="@lang('base/setting.text_pdf_template_template1')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_template1') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','template1', ((isset($setting['pdf_template']) && $setting['pdf_template'] == 'template1') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/template2.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_template2')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/template2.png')}}" alt="@lang('base/setting.text_pdf_template_template2')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_template2') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','template2', ((isset($setting['pdf_template']) && $setting['pdf_template'] == 'template2') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/template3.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_template3')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/template3.png')}}" alt="@lang('base/setting.text_pdf_template_template3')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_template3') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','template3', ((isset($setting['pdf_template']) && $setting['pdf_template'] == 'template3') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-md-offset-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/template4.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_template4')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/template4.png')}}" alt="@lang('base/setting.text_pdf_template_template4')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_template4') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','template4', ((isset($setting['pdf_template']) && $setting['pdf_template'] == 'template4') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/template5.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_template5')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/template5.png')}}" alt="@lang('base/setting.text_pdf_template_template5')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_template5') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','template5', ((isset($setting['pdf_template']) && $setting['pdf_template'] == 'template5') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/template6.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_template6')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/template6.png')}}" alt="@lang('base/setting.text_pdf_template_template6')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_template6') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','template6', ((isset($setting['pdf_template']) && $setting['pdf_template'] == 'template6') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2 col-xs-12 text-center">
                                                <div class="thumbnail" style="border: 0;">
                                                    <div class="img-thumbnail view view-first">
                                                        <a href="{{asset('img/pdf_templates/template7.png')}}" data-fancybox data-caption="@lang('base/setting.text_pdf_template_template7')">
                                                            <img style="height: 180px;" class="img-responsive" src="{{asset('img/pdf_templates/template7.png')}}" alt="@lang('base/setting.text_pdf_template_template7')"/>
                                                        </a>
                                                    </div>
                                                    <br/>
                                                    {!! html_entity_decode(Form::label('pdf_template', __('base/setting.text_pdf_template_template7') . '', ['class' => 'control-label'])) !!}
                                                    <div class="radio">
                                                        <label style="padding-left: 0;">
                                                            {!! Form::radio('pdf_template','template7', ((isset($setting['pdf_template']) && $setting['pdf_template'] == 'template7') ? true : false), ['class' => 'flat']) !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade in" id="tab_complements"
                                         aria-labelledby="complements-tab">
                                        <div class="row">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('complemento_cfdi_iedu', __('base/setting.entry_complemento_cfdi_iedu') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('complemento_cfdi_iedu', '1',(!empty(old('complemento_cfdi_iedu',$setting['complemento_cfdi_iedu'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('complemento_cfdi_foreign_trade', __('base/setting.entry_complemento_cfdi_foreign_trade') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('complemento_cfdi_foreign_trade', '1',(!empty(old('complemento_cfdi_foreign_trade',$setting['complemento_cfdi_foreign_trade'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_dropbox"
                                         aria-labelledby="dropbox-tab">
                                        <div class="row">
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('dropbox_backup', __('base/setting.entry_dropbox_backup') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('dropbox_backup', '1',(!empty(old('dropbox_backup',$setting['dropbox_backup'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('dropbox_access_token', __('base/setting.entry_dropbox_access_token') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::password('dropbox_access_token', ['class' => 'form-control', 'placeholder' => __('base/setting.entry_dropbox_access_token')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('dropbox_folder', __('base/setting.entry_dropbox_folder') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('dropbox_folder', old('dropbox_folder'), ['class' => 'form-control', 'placeholder' => __('base/setting.help_dropbox_folder')]) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div role="tabpanel" class="tab-pane fade" id="tab_system"
                                         aria-labelledby="system-tab">
                                        <div class="row">
                                            @if(Auth::user()->superadmin)
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('cfdi_version', __('base/setting.entry_cfdi_version') . '', ['class' => 'col-md-3 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::select('cfdi_version', $cfdi_versions,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('default_pac_id', __('base/setting.entry_default_pac_id') . '', ['class' => 'col-md-3 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::select('default_pac_id', $pacs,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('disabled_folio_cart', __('base/setting.entry_disabled_folio_cart') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        <label>
                                                            {!! Form::checkbox('disabled_folio_cart', '1',(!empty(old('disabled_folio_cart',$setting['disabled_folio_cart'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('cfdi_download', __('base/setting.entry_cfdi_download') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        <label>
                                                            {!! Form::checkbox('cfdi_download', '1',(!empty(old('cfdi_download',$setting['cfdi_download'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('effective_date_cfdi_download', __('base/setting.entry_effective_date_cfdi_download') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::text('effective_date_cfdi_download', old('effective_date_cfdi_download',!empty($setting['effective_date_cfdi_download']) ? \App\Helpers\Helper::convertSqlToDate($setting['effective_date_cfdi_download']) : ''), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_effective_date_cfdi_download'), 'autocomplete' => 'off']) !!}
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('qty_cfdi_download', __('base/setting.entry_qty_cfdi_download') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::number('qty_cfdi_download', old('qty_cfdi_download'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_qty_cfdi_download')]) !!}
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('bank_reconciliation', __('base/setting.entry_bank_reconciliation') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        <label>
                                                            {!! Form::checkbox('bank_reconciliation', '1',(!empty(old('bank_reconciliation',$setting['bank_reconciliation'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('black_list_sat', __('base/setting.entry_black_list_sat') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        <label>
                                                            {!! Form::checkbox('black_list_sat', '1',(!empty(old('black_list_sat',$setting['black_list_sat'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('diot', __('base/setting.entry_diot') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        <label>
                                                            {!! Form::checkbox('diot', '1',(!empty(old('diot',$setting['diot'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm">
                                                    {!! html_entity_decode(Form::label('folios_to_pay', __('base/setting.entry_folios_to_pay') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        <label>
                                                            {!! Form::checkbox('folios_to_pay', '1',(!empty(old('folios_to_pay',$setting['folios_to_pay'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                        </label>
                                                    </div>
                                                </div>
                                            @endif
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('list_limit', __('base/setting.entry_list_limit') . '', ['class' => 'col-md-3 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::select('list_limit', $limits,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                </div>
                                            </div>
                                            @if(Auth::user()->superadmin)
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('decimal_mark', __('base/setting.entry_decimal_mark') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('decimal_mark', old('decimal_mark'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_decimal_mark')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('thousands_separator', __('base/setting.entry_thousands_separator') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('thousands_separator', old('thousands_separator'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_thousands_separator')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('date_format', __('base/setting.entry_date_format') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('date_format', old('date_format'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_date_format')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('datetime_format', __('base/setting.entry_datetime_format') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('datetime_format', old('datetime_format'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_datetime_format')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('date_picker_format', __('base/setting.entry_date_picker_format') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('date_picker_format', old('date_picker_format'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_date_picker_format')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('datetime_picker_format', __('base/setting.entry_datetime_picker_format') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    {!! Form::text('datetime_picker_format', old('datetime_picker_format'), ['class' => 'form-control', 'placeholder' => __('base/setting.entry_datetime_picker_format')]) !!}
                                                </div>
                                            </div>
                                            <div class="form-group form-group-sm">
                                                {!! html_entity_decode(Form::label('app_demo', __('base/setting.entry_app_demo') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                <div class="col-md-6 col-xs-12">
                                                    <label>
                                                        {!! Form::checkbox('app_demo', '1',(!empty(old('app_demo',$setting['app_demo'] ?? '')) ? true : false),['class' => 'js-switch']); !!}
                                                    </label>
                                                </div>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ln_solid"></div>
                            <div class="">
                                <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                    &nbsp;&nbsp;&nbsp;
                                    <a href="{{route('home',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/iCheck/icheck.min.js') }}"></script>
    <script src="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/bootstrap-wysiwyg/js/bootstrap-wysiwyg.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/jquery.hotkeys/jquery.hotkeys.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/google-code-prettify/src/prettify.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            $("#form input[name='color_primary']").colorpicker();
            $("#form input[name='effective_date_cfdi_download']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false
            }, function (chosen_date) {
                $("#form input[name='effective_date_cfdi_download']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
        });

    </script>
@endsection
