@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('base/tax_mailbox.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('base/tax_mailbox.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('tax-mailbox')}}"
                               class="btn btn-sm btn-success">@lang('general.button_refresh')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('base/tax_mailbox.document_sub_title')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->
                            <div class="filter-data">
                            </div>
                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th class="text-center">
                                            @lang('base/tax_mailbox.column_cfdi_type')
                                        </th>
                                        <th class="text-center">
                                            @lang('base/tax_mailbox.column_date')
                                        </th>
                                        <th class="text-center">
                                            @lang('base/tax_mailbox.column_folio')
                                        </th>
                                        <th class="text-center">
                                            @lang('base/tax_mailbox.column_uuid')
                                        </th>
                                        <th class="text-center">
                                            @lang('base/tax_mailbox.column_rfc_emisor')
                                        </th>
                                        <th class="text-left" style="width: 40%">
                                            @lang('base/tax_mailbox.column_emisor')
                                        </th>
                                        <th class="text-center">
                                            @lang('base/tax_mailbox.column_amount_total')
                                        </th>
                                        <th class="text-center" style="width: 150px;" >@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="">
                                            <td class="text-center">{{$result->cfdi_type}}</td>
                                            <td class="text-center">{{$result->date}}</td>
                                            <td class="text-center">{{$result->folio}}</td>
                                            <td class="text-center">{{$result->uuid}}</td>
                                            <td class="text-center">{{$result->rfc_emisor}}</td>
                                            <td class="text-left">{{$result->emisor}}</td>
                                            <td class="text-right">{{ number_format($result->amount_total,2,'.',',')}}</td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <div class="btn-group btn-group-xs text-center text-nowrap" role="group">
                                                    <a href="{{ route('tax-mailbox/accept-reject',['uuid' => $result->uuid, 'type' => 'A']) }}"
                                                       class="btn btn-xs btn-success">
                                                        @lang('general.button_accept')
                                                    </a>
                                                    <a href="{{ route('tax-mailbox/accept-reject',['uuid' => $result->uuid, 'type' => 'R']) }}"
                                                       class="btn btn-xs btn-danger">
                                                        @lang('general.button_rejected')
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection
