@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/authorization_agent.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/authorization_agent.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('authorization-agents.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'authorization-agents.store','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form']) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('catalogs/authorization_agent.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('catalogs/authorization_agent.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('date_start') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('date_start', __('catalogs/authorization_agent.entry_date_start') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('date_start', old('date_start'), ['class' => 'form-control', 'placeholder' => __('catalogs/authorization_agent.entry_date_start'),'required','autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('date_start'))
                                            <span class="help-block"><small>{{ $errors->first('date_start') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('date_end') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('date_end', __('catalogs/authorization_agent.entry_date_end') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('date_end', old('date_end'), ['class' => 'form-control', 'placeholder' => __('catalogs/authorization_agent.entry_date_end'),'required','autocomplete'=>'off']) !!}
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                        @if ($errors->has('date_end'))
                                            <span class="help-block"><small>{{ $errors->first('date_end') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('catalogs/authorization_agent.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('catalogs/authorization_agent.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('authorization-agents.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            $("#form input[name='date_start']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='date_start']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });
            $("#form input[name='date_end']").daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                locale: {
                    format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
                },
                autoUpdateInput: false,
            }, function (chosen_date) {
                $("#form input[name='date_end']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
            });

        });

    </script>
@endsection
