@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/state.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/state.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('cities.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'cities.store','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form']) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('catalogs/city.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('catalogs/city.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('code') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('code', __('catalogs/city.entry_code') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('code', old('code'), ['class' => 'form-control', 'placeholder' => __('catalogs/city.entry_code')]) !!}
                                        @if ($errors->has('code'))
                                            <span class="help-block"><small>{{ $errors->first('code') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('country_id', __('catalogs/city.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('country_id'))
                                            <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('state_id') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('state_id', __('catalogs/city.entry_state_id') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('state_id', [],old('state_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('state_id'))
                                            <span class="help-block"><small>{{ $errors->first('state_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('catalogs/city.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('catalogs/city.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('cities.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });

            /* Selecciona pais */
            $("#form select[name='country_id']").on("change", function () {
                var id = $(this).val();
                let state_id = $("#form select[name='state_id']");
                state_id.html("<option value=\"\">@lang('general.text_select')</option>");
                if (id) {
                    $.ajax({
                        url: "{{ route('countries/get-states') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id + "&state_id=" + "{{ old('state_id') }}",
                        success: function (data) {
                            if (data.html) {
                                state_id.html(data.html);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            }).trigger("change");
        });

    </script>
@endsection
