@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/payroll_type.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">
    
    </div>
    
    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            
            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/payroll_type.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('payroll-types.create',request()->except('page'))}}"
                               class="btn btn-sm btn-success">@lang('general.button_add')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->
            
            <div class="clearfix"></div>
            
            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->
            
            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_list')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->
                            <div class="filter-data">
                                {!! Form::open(['route' => 'payroll-types.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-8 col-xs-4 text-left">
                                        <div class="form-inline">
                                        <span>
                                            <span class="hidden-xs">@lang('general.text_item_per_page')</span>
                                            {!! Form::select('limit', $limits,request()->input('limit',setting('list_limit','100')), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'onchange' => 'this.form.submit()']) !!}
                                        </span>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xs-8 text-right">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('filter_search', request()->input('filter_search'), ['class' => 'form-control', 'placeholder' => __('general.text_search') . '...']) !!}
                                            <span class="input-group-btn">
                                                {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-default']) !!}
                                        </span>
                                        </div>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th class="text-left">@sortablelink('name',
                                            __('catalogs/payroll_type.column_name'))
                                        </th>
                                        <th class="text-center">@sortablelink('code',
                                            __('catalogs/payroll_type.column_code'))
                                        </th>
                                        <th class="text-center">@sortablelink('sort_order',
                                            __('catalogs/payroll_type.column_sort_order'))
                                        </th>
                                        <th class="text-center">@sortablelink('status',
                                            __('catalogs/payroll_type.column_status'))
                                        </th>
                                        <th class="text-center" width="8%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="{{ (!$result->status ? 'text-muted' : '') }}">
                                            <td class="text-left">
                                                <a href="{{ route('payroll-types.edit',array_merge(['id' => $result->id],request()->except('page'))) }}">{{$result->name}}</a>
                                            </td>
                                            <td class="text-center">{{$result->code}}</td>
                                            <td class="text-center">{{$result->sort_order}}</td>
                                            <td class="text-center">
                                                @if($result->status)
                                                    <label class="label label-success">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @else
                                                    <label class="label label-default">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @endif
                                            </td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <!-- form -->
                                            {!! Form::open(['route' => ['payroll-types.destroy', $result->id],'method' => 'DELETE','class' => 'hidden','role' => 'form','id' => 'form' . $result->id ]) !!}
                                            {!! Form::close() !!}
                                            <!-- /form -->
                                                <div class="btn-group btn-group-xs text-center text-nowrap" role="group">
                                                    <a href="{{ route('payroll-types.edit',array_merge(['id' => $result->id],request()->except('page'))) }}"
                                                       class="btn btn-xs btn-info"
                                                       title="@lang('general.button_edit')">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                    <a href="javascript:;" class="btn btn-xs btn-danger"
                                                       onclick="$('#form{{$result->id}}').submit();"
                                                       title="@lang('general.button_delete')">
                                                        <i class="fa fa-trash-o"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->
        
        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });
    
    </script>
@endsection