@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/product.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/product.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('products.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                        {!! Form::open(['route' => 'products.store','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form','files'=>true]) !!}
                        <!-- input hidden -->
                        {!! Form::hidden('image', old('image')) !!}
                        <!-- /.input hidden -->
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('file_image') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('image', __('catalogs/product.entry_image') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="row">
                                            <div class="col-md-55">
                                                <div class="thumbnail">
                                                    <div class="image view view-first">
                                                        <img style="width: 100%; display: block; height: 100%;"
                                                             class="img-responsive"
                                                             src="{{asset('img/no_imagen_340x150.png')}}"
                                                             data-placeholder="{{asset('img/no_imagen_340x150.png')}}"
                                                             alt="@lang('catalogs/product.entry_image')"
                                                             id="img_image"/>
                                                        <div class="mask">
                                                            <p>&nbsp;</p>
                                                            <div class="tools tools-bottom">
                                                                <a href="#" id="btn_edit_image"
                                                                   title="@lang('general.button_edit')"><i
                                                                            class="fa fa-pencil"></i></a>
                                                                <a href="#" id="btn_delete_image"
                                                                   title="@lang('general.button_delete')"><i
                                                                            class="fa fa-trash-o"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {!! Form::file('file_image', ['class'=> 'hidden']) !!}
                                        @if ($errors->has('file_image'))
                                            <span class="help-block"><small>{{ $errors->first('file_image') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('code') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('code', __('catalogs/product.entry_code') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('code', old('code'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_code'),'','autofocus']) !!}
                                        @if ($errors->has('code'))
                                            <span class="help-block"><small>{{ $errors->first('code') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('catalogs/product.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_name'),'required','']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('description') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('description', __('catalogs/product.entry_description') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::textarea('description', old('description'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_description'),'required','rows' => '3']) !!}
                                        @if ($errors->has('description'))
                                            <span class="help-block"><small>{{ $errors->first('description') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('model', __('catalogs/product.entry_model') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('model', old('model'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_model'),'','']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('manufacturer', __('catalogs/product.entry_manufacturer') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('manufacturer', old('manufacturer'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_manufacturer'),'','']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('unit_measure_id') ? ' has-error' : '' }}">
                                    @php
                                        $tmp_unit_measures = [];
                                        if(!empty(old('unit_measure_id'))){
                                            $tmp_unit_measures = \App\Models\Catalogs\UnitMeasure::where('id','=',old('unit_measure_id'))->get()->pluck('description_select2','id');
                                        }
                                    @endphp
                                    {!! html_entity_decode(Form::label('unit_measure_id', __('catalogs/product.entry_unit_measure_id')  . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::select('unit_measure_id', $tmp_unit_measures,old('unit_measure_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-info btn-unit-measure-search"><i class="fa fa-search"></i></button>
                                            </span>
                                        </div>
                                        <a href="http://pys.sat.gob.mx/PyS/catUnidades.aspx" class="text-primary" target="_blank"><i>...@lang('catalogs/product.text_link_unidades_de_medida_sat')</i></a>
                                        @if ($errors->has('unit_measure_id'))
                                            <span class="help-block"><small>{{ $errors->first('unit_measure_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('sat_product_id') ? ' has-error' : '' }}">
                                    @php
                                        $tmp_sat_products = [];
                                        if(!empty(old('sat_product_id'))){
                                            $tmp_sat_products = \App\Models\Catalogs\SatProduct::where('id','=',old('sat_product_id'))->get()->pluck('description_select2','id');
                                        }
                                    @endphp
                                    {!! html_entity_decode(Form::label('sat_product_id', __('catalogs/product.entry_sat_product_id')  . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="input-group input-group-sm">
                                            {!! Form::select('sat_product_id', $tmp_sat_products,old('sat_product_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-info btn-sat-product-search"><i class="fa fa-search"></i></button>
                                            </span>
                                        </div>
                                        <a href="http://pys.sat.gob.mx/PyS/catPyS.aspx" class="text-primary" target="_blank"><i>...@lang('catalogs/product.text_link_productos_servicios_sat')</i></a>
                                        @if ($errors->has('sat_product_id'))
                                            <span class="help-block"><small>{{ $errors->first('sat_product_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                @if(\App\Helpers\Helper::companyComplementoCfdiForeignTrade())
                                    <div class="form-group form-group-sm{{ $errors->has('tariff_fraction_id') ? ' has-error' : '' }}">
                                        @php
                                            $tmp_tariff_fractions = [];
                                            if(!empty(old('tariff_fraction_id'))){
                                                $tmp_tariff_fractions = \App\Models\Catalogs\TariffFraction::where('id','=',old('tariff_fraction_id'))->get()->pluck('description_select2','id');
                                            }
                                        @endphp
                                        {!! html_entity_decode(Form::label('tariff_fraction_id', __('catalogs/product.entry_tariff_fraction_id')  . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                        <div class="col-md-6 col-xs-12">
                                            <div class="input-group input-group-sm">
                                                {!! Form::select('tariff_fraction_id', $tmp_tariff_fractions,old('tariff_fraction_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                <span class="input-group-btn">
                                                <button type="button" class="btn btn-info btn-tariff-fraction-search"><i class="fa fa-search"></i></button>
                                            </span>
                                            </div>
                                            @if ($errors->has('tariff_fraction_id'))
                                                <span class="help-block"><small>{{ $errors->first('tariff_fraction_id') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group form-group-sm{{ $errors->has('uom_custom_id') ? ' has-error' : '' }}">
                                        @php
                                            $tmp_uom_customs = [];
                                            if(!empty(old('uom_custom_id'))){
                                                $tmp_uom_customs = \App\Models\Catalogs\UomCustom::where('id','=',old('uom_custom_id'))->get()->pluck('description_select2','id');
                                            }
                                        @endphp
                                        {!! html_entity_decode(Form::label('uom_custom_id', __('catalogs/product.entry_uom_custom_id')  . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                        <div class="col-md-6 col-xs-12">
                                            <div class="input-group input-group-sm">
                                                {!! Form::select('uom_custom_id', $tmp_uom_customs,old('uom_custom_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                <span class="input-group-btn">
                                                <button type="button" class="btn btn-info btn-uom-custom-search"><i class="fa fa-search"></i></button>
                                            </span>
                                            </div>
                                            @if ($errors->has('uom_custom_id'))
                                                <span class="help-block"><small>{{ $errors->first('uom_custom_id') }}</small></span>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('price_decimal_place', __('catalogs/product.entry_price_decimal_place') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('price_decimal_place', old('price_decimal_place'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_price_decimal_place'),'','step' => 'any']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('price', __('catalogs/product.entry_price') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('price', old('price'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_price'),'','step' => 'any']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('quota_ieps', __('catalogs/product.entry_quota_ieps') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('quota_ieps', old('quota_ieps'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_quota_ieps'),'','step' => 'any']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('taxes[]', __('catalogs/product.entry_taxes') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('taxes[]', $taxes,old('taxes'), ['class' => 'form-control my-select2','multiple' => 'multiple']) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('comment', __('catalogs/product.entry_comment') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::textarea('comment', old('comment'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_comment'),'rows' => '3']) !!}
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('products.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /* Configura select2 */
            $("#form .my-select2").select2({
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "auto",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            });

            /*File de imagen*/
            $("#form #btn_edit_image").on("click", function (e) {
                e.preventDefault();
                $("input[name='file_image']").trigger('click');
            });
            $("#form #btn_delete_image").on("click", function (e) {
                e.preventDefault();
                $("#form #img_image").attr('src', $("#form #img_image").attr('data-placeholder'));
                $("#form input[name='image']").val('');
            });
            $("#form input[name='file_image']").on("change", function () { //Precarga imagen para visualizar
                if ($(this)[0].files && $(this)[0].files[0]) {
                    let reader = new FileReader();
                    reader.onload = function (e) {
                        $("#form #img_image").attr("src", e.target.result);
                    };
                    reader.readAsDataURL($(this)[0].files[0]);
                }
            });

            /* Configura select2 para buscar unidades de medida*/
            $("#form select[name='unit_measure_id']").select2({
                ajax: {
                    url: "{{route('unit-measures/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 2
            });
            /*Modal para buscar unidades de medida*/
            $(".btn-unit-measure-search").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('unit-measures/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_unit_measure_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar unidad de medida*/
            $(document).on("click", '#form_modal_unit_measure_search #unit_measures .btn-select-unit-measure', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form select[name='unit_measure_id']").append(option).trigger('change');
                $("#modal_unit_measure_search").modal("hide");
            });

            /* Configura select2 para buscar productos del sat*/
            $("#form select[name='sat_product_id']").select2({
                ajax: {
                    url: "{{route('sat-products/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
            /*Modal para buscar productos sat*/
            $(".btn-sat-product-search").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('sat-products/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_sat_product_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar producto del sat*/
            $(document).on("click", '#form_modal_sat_product_search #sat_products .btn-select-sat-product', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form select[name='sat_product_id']").append(option).trigger('change');
                $("#modal_sat_product_search").modal("hide");
            });

            /* Configura select2 para buscar fraccion aracelaria*/
            $("#form select[name='tariff_fraction_id']").select2({
                ajax: {
                    url: "{{route('tariff-fractions/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
            /*Modal para buscar fraccion arancelaria*/
            $(".btn-tariff-fraction-search").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('tariff-fractions/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_tariff_fraction_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar fraccion arancelaria*/
            $(document).on("click", '#form_modal_tariff_fraction_search #tariff_fractions .btn-select-tariff-fraction', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form select[name='tariff_fraction_id']").append(option).trigger('change');
                $("#modal_tariff_fraction_search").modal("hide");
            });

            /* Configura select2 para buscar unidad aduana*/
            $("#form select[name='uom_custom_id']").select2({
                ajax: {
                    url: "{{route('uom-customs/autocomplete')}}",
                    dataType: "JSON",
                    delay: 250,
                    data: function (params) {
                        return {
                            term: $.trim(params.term),
                        };
                    },
                    processResults: function (data, page) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                placeholder: "@lang('general.text_select')",
                theme: "bootstrap",
                width: "100%",
                dropdownAutoWidth: true,
                allowClear: true,
                language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                minimumInputLength: 3
            });
            /*Modal para buscar unidad aduana*/
            $(".btn-uom-custom-search").on("click", function (e) {
                e.preventDefault();
                $.ajax({
                    url: "{{route('uom-customs/modal-search')}}",
                    type: "GET",
                    dataType: "JSON",
                    data: "active_btn_select=1",
                    success: function (data) {
                        $("#modals").html(data.html);
                        $("#modal_uom_custom_search").modal("show");
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
            /*Seleccionar unidad aduana*/
            $(document).on("click", '#form_modal_uom_custom_search #uom_customs .btn-select-uom-custom', function (e) {
                e.preventDefault();
                let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
                $("#form select[name='uom_custom_id']").append(option).trigger('change');
                $("#modal_uom_custom_search").modal("hide");
            });
        });

    </script>
@endsection
