@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/product.document_title'))
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('vendor/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/product.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('products.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible alert-important" role="alert">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        @lang('general.error_upload_file')
                        <ul>
                            @foreach ($errors->all() as $key => $error)
                                <li>{!! $error  !!}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('catalogs/product.text_import_title')</h2>
                            <div class="clearfix"></div>
                            <p>@lang('catalogs/product.text_import_subtitle')</p>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'products/download-template-import','method' => 'POST','class' => '','role' => 'form','id'=>'form1']) !!}
                            <!-- input hidden -->
                            <!-- /.input hidden -->
                                <div class="table-responsive table-data">
                                    <table class="table table-striped table-hover table-condensed">
                                        <thead>
                                        <tr class="mini">
                                            <th class="text-center">@lang('catalogs/product.entry_code')</th>
                                            <th class="text-left">@lang('catalogs/product.entry_name')<span class="required text-danger">*</span></th>
                                            <th class="text-left">@lang('catalogs/product.entry_description')<span class="required text-danger">*</span></th>
                                            <th class="text-left">@lang('catalogs/product.entry_model')</th>
                                            <th class="text-left">@lang('catalogs/product.entry_manufacturer')</th>
                                            <th class="text-left">@lang('catalogs/product.entry_unit_measure_id')</th>
                                            <th class="text-center">@lang('catalogs/product.entry_sat_product_id')</th>
                                            <th class="text-right">@lang('catalogs/product.entry_price')</th>
                                            <th class="text-center">@lang('catalogs/product.entry_taxes')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($import_results as $result)
                                            <tr class="">
                                                <td class="text-center">{{$result->code}}</td>
                                                <td class="text-left">{{$result->name}}</td>
                                                <td class="text-left">{{$result->description}}</td>
                                                <td class="text-left">{{$result->model}}</td>
                                                <td class="text-left">{{$result->manufacturer}}</td>
                                                <td class="text-left">{{$result->unit_measure}}</td>
                                                <td class="text-center">{{$result->sat_product}}</td>
                                                <td class="text-right">{{$result->price}}</td>
                                                <td class="text-center">{{$result->taxes}}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            @php
                                                $tmp_unit_measures = [];
                                                if(!empty(old('unit_measure_id'))){
                                                    $tmp_unit_measures = \App\Models\Catalogs\UnitMeasure::where('id','=',old('unit_measure_id'))->get()->pluck('text_select2','id');
                                                }
                                            @endphp
                                            {!! html_entity_decode(Form::label('unit_measure_id', __('catalogs/product.entry_unit_measure_id')  . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::select('unit_measure_id', $tmp_unit_measures,old('unit_measure_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                <span class="input-group-btn">
                                                    <button type="button" class="btn btn-info btn-unit-measure-search"><i class="fa fa-search"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            @php
                                                $tmp_sat_products = [];
                                                if(!empty(old('sat_product_id'))){
                                                    $tmp_sat_products = \App\Models\Catalogs\SatProduct::where('id','=',old('sat_product_id'))->get()->pluck('text_select2','id');
                                                }
                                            @endphp
                                            {!! html_entity_decode(Form::label('sat_product_id', __('catalogs/product.entry_sat_product_id')  . '', ['class' => 'control-label'])) !!}
                                            <div class="input-group input-group-sm">
                                                {!! Form::select('sat_product_id', $tmp_sat_products,old('sat_product_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                                                <span class="input-group-btn">
                                                    <button type="button" class="btn btn-info btn-sat-product-search"><i class="fa fa-search"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('price', __('catalogs/product.entry_price') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::number('price', old('price'), ['class' => 'form-control', 'placeholder' => __('catalogs/product.entry_price'), 'step' => 'any']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-xs-12">
                                        <div class="form-group form-group-sm">
                                            {!! html_entity_decode(Form::label('taxes[]', __('catalogs/product.entry_taxes') . '', ['class' => 'control-label'])) !!}
                                            {!! Form::select('taxes[]', $taxes,old('taxes'), ['class' => 'form-control my-select2','multiple' => 'multiple','id' => 'taxes']) !!}
                                        </div>
                                    </div>
                                </div>

                                <div class="ln_solid"></div>
                                <div class="row">
                                    <div class="col-md-12 col-xs-12 text-right footer-form">
                                        {!! Form::button(__('general.button_download_template_import'),['type' => 'submit', 'class' => 'btn btn-sm btn-success']) !!}
                                    </div>
                                </div>
                            {!! Form::close() !!}
                            {!! Form::open(['route' => 'products/import','method' => 'POST','class' => '','role' => 'form','id'=>'form','files' => true]) !!}
                                <input name="file_products_import" type="file" class="hidden"/>
                                <div class="dropzone mt-3" style="cursor: pointer; position: relative; min-height: 150px; padding-top: 15px;">
                                    <div class="fallback text-center">
                                        <label id="file_products_import_upload" style="font-size: 12px;"></label>
                                    </div>
                                    <div class="dz-message needsclick text-center" style="padding-top: 10px;">
                                        <i class="fa fa-cloud-upload" style="font-size: 50px;"></i>
                                        <h4 style="">@lang('general.help_upload_file')</h4>
                                    </div>
                                </div>
                            <!-- Footer form -->
                            <div class="ln_solid"></div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-right footer-form">
                                    {!! Form::button(__('general.button_importar'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary ladda-button']) !!}
                                    &nbsp;&nbsp;
                                    <a href="{{route('products.index',request()->except('page'))}}"
                                       class="btn btn-sm btn-default">@lang('general.button_discard')</a>
                                </div>
                            </div>
                            <!-- /Footer form -->
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('vendor/sweetalert2/sweetalert2.min.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">
        $("#form1 .my-select2").select2({
            placeholder: "@lang('general.text_select')",
            theme: "bootstrap",
            width: "auto",
            dropdownAutoWidth: true,
            allowClear: true,
            language: "{{ str_replace('_', '-', app()->getLocale()) }}",
        });
        /* Configura select2 para buscar unidad de medida*/
        $("#form1 select[name='unit_measure_id']").select2({
            ajax: {
                url: "{{route('unit-measures/autocomplete')}}",
                dataType: "JSON",
                delay: 250,
                data: function (params) {
                    return {
                        term: $.trim(params.term),
                    };
                },
                processResults: function (data, page) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            templateResult: formatRepoCode,
            templateSelection: formatRepoCodeSelection,
            placeholder: "@lang('general.text_select')",
            theme: "bootstrap",
            width: "100%",
            dropdownAutoWidth: true,
            allowClear: true,
            language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            minimumInputLength: 2
        });
        /* Configura select2 para buscar productos sat*/
        $("#form1 select[name='sat_product_id']").select2({
            ajax: {
                url: "{{route('sat-products/autocomplete')}}",
                dataType: "JSON",
                delay: 250,
                data: function (params) {
                    return {
                        term: $.trim(params.term),
                    };
                },
                processResults: function (data, page) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            templateResult: formatRepoCode,
            templateSelection: formatRepoCodeSelection,
            placeholder: "@lang('general.text_select')",
            theme: "bootstrap",
            width: "100%",
            dropdownAutoWidth: true,
            allowClear: true,
            language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            minimumInputLength: 3
        });
        /*Modal para buscar unidades de medida*/
        $('#form1 .btn-unit-measure-search').on('click', function (e) {
            e.preventDefault();
            let row = $(this).attr('data-row');
            $.ajax({
                url: "{{route('unit-measures/modal-search')}}",
                type: "GET",
                dataType: "JSON",
                data: "active_btn_select=1&row_origin="+ row,
                success: function (data) {
                    $("#modals").html(data.html);
                    $("#modal_unit_measure_search").modal("show");
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        });
        /*Seleccionar unidad de medida*/
        $(document).on("click", '#form_modal_unit_measure_search #unit_measures .btn-select-unit-measure', function (e) {
            e.preventDefault();
            let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
            $("#form1 select[name='unit_measure_id']").append(option).trigger('change');
            $("#modal_unit_measure_search").modal("hide");
        });
        /*Modal para buscar productos del sat*/
        $('#form1 .btn-sat-product-search').on('click', function (e) {
            e.preventDefault();
            let row = $(this).attr('data-row');
            $.ajax({
                url: "{{route('sat-products/modal-search')}}",
                type: "GET",
                dataType: "JSON",
                data: "active_btn_select=1&row_origin="+ row,
                success: function (data) {
                    $("#modals").html(data.html);
                    $("#modal_sat_product_search").modal("show");
                },
                error: function (error, textStatus, errorThrown) {
                    if (error.status == 422) {
                        var message = error.responseJSON.error;
                        $("#general_messages").html(alertMessage("danger", message));
                    } else if (error.status == 403 || error.status == 401) {
                        location.href = "{{ route('login') }}";
                    } else {
                        alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                    }
                }
            });
        });
        /*Seleccionar producto del sat*/
        $(document).on("click", '#form_modal_sat_product_search #sat_products .btn-select-sat-product', function (e) {
            e.preventDefault();
            let option = new Option($(this).attr('data-description-select2'), $(this).attr('data-id'), false, true);
            $("#form1 select[name='sat_product_id']").append(option).trigger('change');
            $("#modal_sat_product_search").modal("hide");
        });
        $(".dropzone").on("click", function (e) {
            e.preventDefault();
            $("#form input[name='file_products_import']").trigger("click");
        });
        $("#form input[name='file_products_import']").change(function(e){
            let fileName = e.target.files[0].name;
            $("#form #file_products_import_upload").text(fileName).addClass('label label-success font-14');
        });
        $("#form button[type='submit']").on('click',function(e){
            e.preventDefault();
            Pace.track(function () {
                $.ajax({
                    url: "{{ route('products/before-import') }}",
                    type: "POST",
                    dataType: "JSON",
                    data: new FormData($("#form").get(0)),
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (data) {
                        if (data.success) {
                            Swal.fire({
                                title: "{{__('general.text_are_you_sure')}}",
                                html: data.total_import_products,
                                type: 'warning',
                                showCancelButton: true,
                                confirmButtonText: "{{__('general.button_yes_import')}}",
                                cancelButtonText: "{{__('general.button_no_cancel')}}",
                                confirmButtonClass: 'btn btn-primary mt-2',
                                cancelButtonClass: 'btn btn-secondary ml-2 mt-2',
                                buttonsStyling: false,
                                onClose: () => {
                                    Ladda.stopAll();
                                }
                            }).then(function (result) {
                                if (result.value) {
                                    $("#form").submit();
                                } else if (
                                    // Read more about handling dismissals
                                    result.dismiss === Swal.DismissReason.cancel
                                ) {
                                    //Cancelar
                                }
                            });
                        }
                    },
                    error: function (error, textStatus, errorThrown) {
                        Ladda.stopAll();
                        if (error.status == 422) {
                            let message = error.responseJSON.error;
                            $("#general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            });
        });
    </script>
@endsection
