@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/product.document_title'))
@section('css_specific')
    <link href="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/product.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('products.create',request()->except('page'))}}"
                               class="btn btn-sm btn-success">@lang('general.button_add')
                            </a>
                            &nbsp;
                            <a href="{{route('products/import')}}"
                               class="btn btn-sm btn-default">@lang('general.button_importar')
                            </a>
                            &nbsp;
                            <a href="{{route('products/export-to-excel',request()->except('page'))}}" class="btn btn-sm btn-excel">
                                @lang('general.button_export_to_excel')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_list')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!-- Filtros -->
                            <div class="filter-data">
                                {!! Form::open(['route' => 'products.index','method' => 'GET','class' => '','role' => 'form','id'=>'form']) !!}
                                <div class="row">
                                    <div class="col-md-7 text-left">
                                        <div class="form-inline">
                                        <span>
                                            <span class="hidden-xs">@lang('general.text_item_per_page')</span>
                                            {!! Form::select('limit', $limits,request()->input('limit',setting('list_limit','100')), ['class' => 'form-control input-sm', 'placeholder' => __('general.text_select'),'onchange' => 'this.form.submit()']) !!}
                                        </span>
                                        </div>
                                    </div>
                                    <div class="col-md-1 text-right">
                                        <div class="form-group form-group-sm">
                                            {!! Form::select('filter_status',['all' => __('general.text_all'), '1' => __('general.text_enableds'),'0' => __('general.text_disableds')], request()->input('filter_status','1'), ['class' => 'form-control','onchange' => '$(\'#form\').submit();' ]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-4 text-right">
                                        <div class="input-group input-group-sm">
                                            {!! Form::text('filter_search', request()->input('filter_search'), ['class' => 'form-control', 'placeholder' => __('general.text_search') . '...']) !!}
                                            <span class="input-group-btn">
                                                {!! Form::button(__('general.button_search'),['type' => 'submit', 'class' => 'btn btn-default']) !!}
                                        </span>
                                        </div>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- /Filtros -->
                            <!-- Datos -->
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th class="text-center">@lang('catalogs/product.column_image')</th>
                                        <th class="text-center">@sortablelink('code',
                                            __('catalogs/product.column_code'))
                                        </th>
                                        <th class="text-left">@sortablelink('name',
                                            __('catalogs/product.column_name'))
                                        </th>
                                        <th class="text-center">@sortablelink('manufacturer',
                                            __('catalogs/product.column_manufacturer'))
                                        </th>
                                        <th class="text-center">@sortablelink('unitMeasure.name',
                                            __('catalogs/product.column_unit_measure'))
                                        </th>
                                        <th class="text-center">@sortablelink('satProduct.name',
                                            __('catalogs/product.column_sat_product'))
                                        </th>
                                        <th class="text-center">
                                            @sortablelink('price', __('catalogs/product.column_price'))
                                        </th>
                                        <th class="text-center">@sortablelink('status',
                                            __('catalogs/product.column_status'))
                                        </th>
                                        <th class="text-center" width="8%">@lang('general.column_actions')</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($results as $result)
                                        <tr class="{{ (!$result->status ? 'text-muted' : '') }}">
                                            <td class="text-center" align="center">
                                                <a href="{{!empty($result->image) ? $result->pathImage() : asset('img/no_imagen_340x150.png')}}"
                                                   class="text-center" data-fancybox data-caption="{{$result->name}}">
                                                    <img style=""
                                                         class="mini text-center"
                                                         src="{{!empty($result->image) ? $result->pathImage() : asset('img/no_imagen_340x150.png')}}"
                                                         alt="@lang('catalogs/product.entry_image')"/>
                                                </a>
                                            </td>
                                            <td class="text-center">{{$result->code}}</td>
                                            <td class="text-left">
                                                <a href="{{ route('products.edit',array_merge(['id' => $result->id],request()->except('page'))) }}">{{$result->name}}</a>
                                            </td>
                                            <td class="text-center">{{$result->manufacturer}}</td>
                                            <td class="text-center small">{{$result->unitMeasure->name_sat ?? ''}}</td>
                                            <td class="text-center small">{{$result->satProduct->name_sat ?? ''}}</td>
                                            <td class="text-center">
                                                {{ \App\Helpers\Helper::numberFormatMoney($result->price,!empty($result->price_decimal_place) ? $result->price_decimal_place : \App\Helpers\Helper::companyProductPriceDecimalPlace()) }}
                                            </td>
                                            <td class="text-center">
                                                @if($result->status)
                                                    <label class="label label-success">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @else
                                                    <label class="label label-default">{{ \App\Helpers\Helper::statusHuman($result->status) }}</label>
                                                @endif
                                            </td>
                                            <!-- Acciones -->
                                            <td class="text-center nowrap">
                                                <!-- form -->
                                            {!! Form::open(['route' => ['products.destroy', $result->id],'method' => 'DELETE','class' => 'hidden','role' => 'form','id' => 'form' . $result->id ]) !!}
                                            {!! Form::close() !!}
                                            <!-- /form -->
                                                <div class="btn-group btn-group-xs text-center text-nowrap" role="group">
                                                    <a href="{{ route('products.edit',array_merge(['id' => $result->id],request()->except('page'))) }}"
                                                       class="btn btn-xs btn-info"
                                                       title="@lang('general.button_edit')">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                    <a href="javascript:;" class="btn btn-xs btn-danger"
                                                       onclick="$('#form{{$result->id}}').submit();"
                                                       title="@lang('general.button_delete')">
                                                        <i class="fa fa-trash-o"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="9" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <!-- /Datos -->
                            <div class="ln_solid"></div>
                            <!-- Pie de pagina -->
                            <div class="row">
                                @if($results->total() > 0)
                                    <div class="col-md-5 col-xs-12 text-left hidden-xs">
                                    <span class="btn btn-sm btn-default">{{ $results->firstItem() }}
                                        - {{ $results->lastItem() }} @lang('general.text_of') {{ $results->total() }}</span>
                                    </div>
                                    <div class="col-md-7 col-xs-12 text-right">
                                        {{ $results->appends(request()->except('page'))->links() }}
                                    </div>
                                @endif
                            </div>
                            <!-- /Pie de pagina -->
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection
