@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/project.document_title'))
@section('css_specific')
    <link href="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/project.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('projects.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $project->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($project,['route' => ['projects.update',$project->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form','files' => true]) !!}
                            <!-- input hidden -->
                            {!! Form::hidden('logo_docs', old('logo_docs')) !!}
                            <!-- /.input hidden -->
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('catalogs/project.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('catalogs/project.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('description') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('description', __('catalogs/project.entry_description') . ' ', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::textarea('description', old('description'), ['class' => 'form-control', 'placeholder' => __('catalogs/project.entry_description'),'cols' => '4','style'=>'height: 100px;']) !!}
                                        @if ($errors->has('description'))
                                            <span class="help-block"><small>{{ $errors->first('description') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('file_logo_docs') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('logo_docs', __('catalogs/project.entry_logo_docs') . ' ', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <div class="" style="width: 250px;">
                                            <div class="thumbnail" style="margin-bottom: 5px;">
                                                <div class="image view view-first">
                                                    <img style="width: 100%; display: block; height: 100%;"
                                                         class="img-responsive"
                                                         src="{{!empty($project->logo_docs) ? $project->pathLogoDocs() : asset('img/no_imagen_340x150.png')}}"
                                                         data-placeholder="{{asset('img/no_imagen_340x150.png')}}"
                                                         alt="@lang('catalogs/project.entry_logo_docs')"
                                                         id="img_logo_docs"/>
                                                    <div class="mask">
                                                        <p>&nbsp;</p>
                                                        <div class="tools tools-bottom">
                                                            <a href="#" id="btn_edit_logo_docs"
                                                               title="@lang('general.button_edit')"><i
                                                                    class="fa fa-pencil"></i></a>
                                                            <a href="{{!empty($project->logo_docs) ? $project->pathLogoDocs() : asset('img/no_imagen_340x150.png')}}"
                                                               id="btn_view_logo_docs"
                                                               title="@lang('general.button_view')" data-fancybox><i
                                                                    class="fa fa-search"></i></a>
                                                            <a href="#" id="btn_delete_logo_docs"
                                                               title="@lang('general.button_delete')"><i
                                                                    class="fa fa-trash-o"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {!! Form::file('file_logo_docs', ['class'=> 'hidden']) !!}
                                        <small class="text-muted">@lang('catalogs/project.help_logo_docs')</small>
                                        @if ($errors->has('file_logo_docs'))
                                            <span class="help-block"><small>{{ $errors->first('file_logo_docs') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('catalogs/project.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('catalogs/project.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('status', __('catalogs/project.entry_status') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('status', '1',(!empty(old('status',$project->status)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('projects.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('vendor/fancybox-master/dist/jquery.fancybox.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            /*File de logo docs*/
            $("#form #btn_edit_logo_docs").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_logo_docs']").trigger('click');
            });
            $("#form #btn_delete_logo_docs").on("click", function (e) {
                e.preventDefault();
                $("#form #img_logo_docs").attr('src', $("#form #img_logo_docs").attr('data-placeholder'));
                $("#form input[name='logo_docs']").val('');
            });
            $("#form input[name='file_logo_docs']").on("change", function () { //Precarga imagen para visualizar
                if ($(this)[0].files && $(this)[0].files[0]) {
                    let reader = new FileReader();
                    reader.onload = function (e) {
                        $("#form #img_logo_docs").attr("src", e.target.result);
                    };
                    reader.readAsDataURL($(this)[0].files[0]);
                }
            });
        });

    </script>
@endsection
