@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/rights_way.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/rights_way.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('rights-ways.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $rights_way->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($rights_way,['route' => ['rights-ways.update',$rights_way->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form']) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('catalogs/rights_way.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('catalogs/rights_way.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('code') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('code', __('catalogs/rights_way.entry_code') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('code', old('code'), ['class' => 'form-control', 'placeholder' => __('catalogs/rights_way.entry_code'),'required']) !!}
                                        @if ($errors->has('code'))
                                            <span class="help-block"><small>{{ $errors->first('code') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('from') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('from', __('catalogs/rights_way.entry_from') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('from', old('from'), ['class' => 'form-control', 'placeholder' => __('catalogs/rights_way.entry_from')]) !!}
                                        @if ($errors->has('from'))
                                            <span class="help-block"><small>{{ $errors->first('from') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('to') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('to', __('catalogs/rights_way.entry_to') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('to', old('to'), ['class' => 'form-control', 'placeholder' => __('catalogs/rights_way.entry_to')]) !!}
                                        @if ($errors->has('to'))
                                            <span class="help-block"><small>{{ $errors->first('to') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('grant_receive') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('grant_receive', __('catalogs/rights_way.entry_grant_receive') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('grant_receive', old('grant_receive'), ['class' => 'form-control', 'placeholder' => __('catalogs/rights_way.entry_grant_receive')]) !!}
                                        @if ($errors->has('grant_receive'))
                                            <span class="help-block"><small>{{ $errors->first('grant_receive') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('concessionaire') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('concessionaire', __('catalogs/rights_way.entry_concessionaire') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('concessionaire', old('concessionaire'), ['class' => 'form-control', 'placeholder' => __('catalogs/rights_way.entry_concessionaire')]) !!}
                                        @if ($errors->has('concessionaire'))
                                            <span class="help-block"><small>{{ $errors->first('concessionaire') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('catalogs/rights_way.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('catalogs/rights_way.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! html_entity_decode(Form::label('status', __('catalogs/rights_way.entry_status') , ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        <label>
                                            {!! Form::checkbox('status', '1',(!empty(old('status',$rights_way->status)) ? true : false),['class' => 'js-switch']); !!}
                                        </label>
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('rights-ways.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection
