@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('catalogs/station.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('catalogs/station.document_title')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                            <a href="{{route('stations.index',request()->except('page'))}}"
                               class="btn btn-sm btn-default">@lang('general.button_discard')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>@lang('general.text_add')</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::open(['route' => 'stations.store','method' => 'POST','class' => 'form-horizontal','role' => 'form','id'=>'form']) !!}
                            <div class="row">
                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('name', __('catalogs/station.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('catalogs/station.entry_name'),'required','autofocus']) !!}
                                        @if ($errors->has('name'))
                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('code') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('code', __('catalogs/station.entry_code') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('code', old('code'), ['class' => 'form-control', 'placeholder' => __('catalogs/station.entry_code'),'required']) !!}
                                        @if ($errors->has('code'))
                                            <span class="help-block"><small>{{ $errors->first('code') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('transport_type_id') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('transport_type_id', __('catalogs/station.entry_transport_type_id') . ' <span class="required text-danger">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::select('transport_type_id', $transport_types,old('transport_type_id'), ['class' => 'form-control my-select2', 'placeholder' => __('general.text_select'),'required']) !!}
                                        @if ($errors->has('transport_type_id'))
                                            <span class="help-block"><small>{{ $errors->first('transport_type_id') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('nationality') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('nationality', __('catalogs/station.entry_nationality') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('nationality', old('nationality'), ['class' => 'form-control', 'placeholder' => __('catalogs/station.entry_nationality')]) !!}
                                        @if ($errors->has('nationality'))
                                            <span class="help-block"><small>{{ $errors->first('nationality') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('designator') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('designator', __('catalogs/station.entry_designator') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('designator', old('designator'), ['class' => 'form-control', 'placeholder' => __('catalogs/station.entry_designator')]) !!}
                                        @if ($errors->has('designator'))
                                            <span class="help-block"><small>{{ $errors->first('designator') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm{{ $errors->has('railway_line') ? ' has-error' : '' }}">
                                    {!! html_entity_decode(Form::label('railway_line', __('catalogs/station.entry_railway_line') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::text('railway_line', old('railway_line'), ['class' => 'form-control', 'placeholder' => __('catalogs/station.entry_railway_line')]) !!}
                                        @if ($errors->has('railway_line'))
                                            <span class="help-block"><small>{{ $errors->first('railway_line') }}</small></span>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    {!! Form::label('sort_order', __('catalogs/station.entry_sort_order'), ['class' => 'col-md-3 col-xs-12 control-label']) !!}
                                    <div class="col-md-6 col-xs-12">
                                        {!! Form::number('sort_order', old('sort_order'), ['class' => 'form-control', 'placeholder' => __('catalogs/station.entry_sort_order')]) !!}
                                    </div>
                                </div>
                                <div class="ln_solid"></div>
                                <div class="">
                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="{{route('stations.index',request()->except('page'))}}"
                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {

        });

    </script>
@endsection
