@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . 'Dashboard')
@section('css_specific')
    <link href="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet"/>
    <link href="{{ asset('gentelella/plugins/google-code-prettify/bin/prettify.min.css') }}" rel="stylesheet"/>
@endsection
@section('css')

@endsection


@section('content')
    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>
                                @lang('general.text_instruction_migration')
                            </h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <div class="col-md-12 col-xs-12">
                                <p>@lang('general.text_instruction_migration_bd')</p>
                                <code>
                                    @foreach($dbs_instruction as $element)
                                        {{$element}} <br/>
                                    @endforeach
                                </code>
                            </div>
                        </div>
                        <div class="x_content">
                            <div class="col-md-12 col-xs-12">
                                <p>@lang('general.text_instruction_migration_backup_bd')</p>
                                <code>
                                    @foreach($dbs_backup_instruction as $element)
                                        {{$element}} <br/>
                                    @endforeach
                                </code>
                            </div>
                        </div>
                        <div class="x_content">
                            <div class="col-md-12 col-xs-12">
                                <p>@lang('general.text_instruction_migration_restore_bd')</p>
                                <code>
                                    @foreach($dbs_restore_instruction as $element)
                                        {{$element}} <br/>
                                    @endforeach
                                </code>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /page content -->
@endsection
@section('scripts_specific')
    <script src="{{ asset('gentelella/plugins/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/Chart.js/dist/Chart.min.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/Chart.js/dist/Chart.bundle.js') }}"></script>
    <script src="{{ asset('gentelella/plugins/DateJS/build/date.js') }}"></script>
    <script src="{{ asset('vendor/numeral/min/numeral.min.js') }}"></script>
@endsection
@section('scripts')
    <script type="text/javascript">
        $(function () {
            /*Fechas*/
            moment.locale("{{ substr(app()->getLocale(),0,2) }}");


        });
    </script>
@endsection
