<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

    @section('smartsupp_chat')
        @if(!empty(config('app.smartsupp_key')))
            <script type="text/javascript">
                var _smartsupp = _smartsupp || {};
                _smartsupp.key = '{{config('app.smartsupp_key')}}';
                window.smartsupp||(function(d) {
                    var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
                    s=d.getElementsByTagName('script')[0];c=d.createElement('script');
                    c.type='text/javascript';c.charset='utf-8';c.async=true;
                    c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
                })(document);
            </script>
        @elseif(!empty(config('app.tawk_key')))
            <script type="text/javascript">
                var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
                (function(){
                    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
                    s1.async=true;
                    s1.src='https://embed.tawk.to/{{config('app.tawk_key')}}';
                    s1.charset='UTF-8';
                    s1.setAttribute('crossorigin','*');
                    s0.parentNode.insertBefore(s1,s0);
                })();
            </script>
        @endif
    @endsection

    {{--Head--}}
    @include('layouts.partials.head')

    <body class="nav-sm">
        @if (App::environment('development'))
            <div class="env-local"><span>@lang('general.text_environment_development')</span></div>
        @endif
        @if(setting('app_demo',0))
            <div class="env-demo"><span>@lang('general.text_environment_demo')</span></div>
        @endif
        <div class="container body" id="app">
            <div class="main_container">

                @include('layouts.partials.sidebar')

                @include('layouts.partials.top_nav')

                {{--Content--}}
                @yield('content')

                @include('layouts.partials.footer')

            </div>
        </div>

        @include('layouts.partials.modal_about')

        {{--Scripts--}}
        @include('layouts.partials.scripts')

        <script type="text/javascript">
            $("div.alert").not(".alert-important").delay(40000).fadeOut(350);

            $(document).ajaxStart(function() { Pace.restart(); });
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $(function () {
                Ladda.bind(".ladda-button");

                /*Redimension textarea*/
                ymAutoResizeTextArea();

                /**/
                $('body').bind('keydown', function(e) {
                    if (e.keyCode == 13 && $(e.target).is('input')) {
                        e.preventDefault();
                    }
                });

                @if(Auth::user()->superadmin || Auth::user()->distributor)
                /* Configura select2 para buscar cliente sistema*/
                $(".top_nav select[name='user_sys_customer_id']").select2({
                    ajax: {
                        url: "{{route('sys-customers/autocomplete')}}",
                        dataType: "JSON",
                        delay: 250,
                        data: function (params) {
                            return {
                                term: $.trim(params.term),
                            };
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    },
                    placeholder: "@lang('general.text_default')",
                    theme: "bootstrap",
                    width: "100%",
                    dropdownAutoWidth: true,
                    allowClear: true,
                    language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                    minimumInputLength: 3
                }).on("change", function () {
                    let id = $(this).val();
                    $.ajax({
                        url: "{{route('users/update-sys-customer',['id' => \Auth::user()->id])}}",
                        type: "POST",
                        dataType: "JSON",
                        data: "sys_customer_id=" + id,
                        success: function (data) {
                            location.href = "{{ route('home') }}";
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                });
                /*Modal para buscar clientes sistema*/
                $(".btn-user-sys-customer-search").on("click", function (e) {
                    e.preventDefault();
                    $.ajax({
                        url: "{{route('sys-customers/modal-user-search')}}",
                        type: "GET",
                        dataType: "JSON",
                        data: "active_btn_select=1",
                        success: function (data) {
                            $("#user_modals").html(data.html);
                            $("#modal_user_sys_customer_search").modal("show");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                });
                /*Seleccionar cliente sistema*/
                $(document).on("click", '#form_modal_user_sys_customer_search #user_sys_customers .btn-select-sys-customer', function (e) {
                    e.preventDefault();
                    let option = new Option($(this).attr('data-name'), $(this).attr('data-id'), false, true);
                    $(".top_nav select[name='user_sys_customer_id']").append(option).trigger('change');
                    $("#modal_user_sys_customer_search").modal("hide");

                });
                @endif

                @if(!empty(setting('multi_taxid')))
                /*Modal para buscar empresas*/
                $(".btn-user-company-search").on("click", function (e) {
                    e.preventDefault();
                    $.ajax({
                        url: "{{route('companies/modal-user-search')}}",
                        type: "GET",
                        dataType: "JSON",
                        data: "active_btn_select=1",
                        success: function (data) {
                            $("#user_modals").html(data.html);
                            $("#modal_user_company_search").modal("show");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                });
                /*Seleccionar empresas*/
                $(document).on("click", '#form_modal_user_company_search #user_companies .btn-select-company', function (e) {
                    e.preventDefault();
                    let id = $(this).attr('data-id');
                    $("#modal_user_company_search").modal("hide");
                    $.ajax({
                        url: "{{route('users/update-company',['id' => \Auth::user()->id])}}",
                        type: "POST",
                        dataType: "JSON",
                        data: "company_id=" + id,
                        success: function (data) {
                            location.href = "{{ route('login') }}";
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                });
                @endif
            });
        </script>
    </body>
</html>
