<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

    {{--Head--}}
    @include('layouts.partials.head')

    <body class="nav-sm">
        @if (App::environment('development'))
            <div class="env-local"><span>@lang('general.text_environment_development')</span></div>
        @endif
        @if(setting('app_demo',0))
            <div class="env-demo"><span>@lang('general.text_environment_demo')</span></div>
        @endif
        <div class="container body" id="app">
            <div class="main_container">

                @include('layouts.partials.installation_top_nav')

                {{--Content--}}
                @yield('content')

                @include('layouts.partials.installation_footer')

            </div>
        </div>

        @include('layouts.partials.modal_about')

        {{--Scripts--}}
        @include('layouts.partials.scripts')

        <script type="text/javascript">
            $("div.alert").not(".alert-important").delay(40000).fadeOut(350);

            $(document).ajaxStart(function() { Pace.restart(); });
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $(function () {
                Ladda.bind(".ladda-button");

                /*Redimension textarea*/
                ymAutoResizeTextArea();

                /**/
                $('body').bind('keydown', function(e) {
                    if (e.keyCode == 13 && $(e.target).is('input')) {
                        e.preventDefault();
                    }
                });

                @if(Auth::user()->superadmin || Auth::user()->distributor)
                /* Configura select2 para buscar cliente sistema*/
                $(".top_nav select[name='user_sys_customer_id']").select2({
                    ajax: {
                        url: "{{route('sys-customers/autocomplete')}}",
                        dataType: "JSON",
                        delay: 250,
                        data: function (params) {
                            return {
                                term: $.trim(params.term),
                            };
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    },
                    placeholder: "@lang('general.text_default')",
                    theme: "bootstrap",
                    width: "100%",
                    dropdownAutoWidth: true,
                    allowClear: true,
                    language: "{{ str_replace('_', '-', app()->getLocale()) }}",
                    minimumInputLength: 3
                }).on("change", function () {
                    let id = $(this).val();
                    $.ajax({
                        url: "{{route('users/update-sys-customer',['id' => \Auth::user()->id])}}",
                        type: "POST",
                        dataType: "JSON",
                        data: "sys_customer_id=" + id,
                        success: function (data) {
                            location.href = "{{ route('home') }}";
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                });
                /*Modal para buscar clientes sistema*/
                $(".btn-user-sys-customer-search").on("click", function (e) {
                    e.preventDefault();
                    $.ajax({
                        url: "{{route('sys-customers/modal-user-search')}}",
                        type: "GET",
                        dataType: "JSON",
                        data: "active_btn_select=1",
                        success: function (data) {
                            $("#user_modals").html(data.html);
                            $("#modal_user_sys_customer_search").modal("show");
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                });
                /*Seleccionar cliente sistema*/
                $(document).on("click", '#form_modal_user_sys_customer_search #user_sys_customers .btn-select-sys-customer', function (e) {
                    e.preventDefault();
                    let option = new Option($(this).attr('data-name'), $(this).attr('data-id'), false, true);
                    $(".top_nav select[name='user_sys_customer_id']").append(option).trigger('change');
                    $("#modal_user_sys_customer_search").modal("hide");

                });
                @endif
            });
        </script>
    </body>
</html>
