<!-- modal about -->
<div class="modal fade" id="modal_cfdi_download_deposit_create" role="dialog">
    <div class="modal-dialog modal-lg">
        {!! Form::open(['route' => 'cfdi-downloads/store-deposit','method' => 'POST','class' => '','role' => 'form','id'=>'form_modal_cfdi_download_deposit_create']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-save"></i> {!! __('base/cfdi_download.text_modal_cfdi_download_deposit_create') !!}</h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('date') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('date', __('base/cfdi_download.entry_date') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            <div class="input-group input-group-sm">
                                {!! Form::text('date', old('date',\App\Helpers\Helper::dateTime(Date::now())), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_date'),'required','autofocus','autocomplete'=>'off']) !!}
                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                            </div>
                            @if ($errors->has('date'))
                                <span class="help-block"><small>{{ $errors->first('date') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('name', __('base/cfdi_download.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_name'),'required']) !!}
                            @if ($errors->has('name'))
                                <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('expense_type_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('expense_type_id', __('base/cfdi_download.entry_expense_type_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('expense_type_id', $expense_types,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                            @if ($errors->has('expense_type_id'))
                                <span class="help-block"><small>{{ $errors->first('expense_type_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-8 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('receptor') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('receptor', __('base/cfdi_download.entry_receptor') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('receptor', old('receptor'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_receptor'),'required']) !!}
                            @if ($errors->has('receptor'))
                                <span class="help-block"><small>{{ $errors->first('receptor') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('operational_type_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('operational_type_id', __('base/cfdi_download.entry_operational_type_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('operational_type_id', $operational_types,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                            @if ($errors->has('operational_type_id'))
                                <span class="help-block"><small>{{ $errors->first('operational_type_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('payment_way_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('payment_way_id', __('base/cfdi_download.entry_payment_way_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('payment_way_id', $payment_ways,old('payment_way_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                            @if ($errors->has('payment_way_id'))
                                <span class="help-block"><small>{{ $errors->first('payment_way_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-7">
                        <div class="form-group form-group-sm{{ $errors->has('currency_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('currency_id', __('base/cfdi_download.entry_currency_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::select('currency_id', $currencies,old('currency_id',\App\Models\Catalogs\Currency::first()->id), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                            @if ($errors->has('currency_id'))
                                <span class="help-block"><small>{{ $errors->first('currency_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-5">
                        <div class="form-group form-group-sm{{ $errors->has('currency_value') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('currency_value', __('base/cfdi_download.entry_currency_value') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::number('currency_value', old('currency_value'), ['class' => 'form-control text-center', 'placeholder' => __('base/cfdi_download.entry_currency_value'),'required','step' => 'any']) !!}
                            @if ($errors->has('currency_value'))
                                <span class="help-block"><small>{{ $errors->first('currency_value') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('amount_total') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('amount_total', __('base/cfdi_download.entry_amount_total_2') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::number('amount_total', old('amount_total'), ['class' => 'form-control text-right', 'placeholder' => __('base/cfdi_download.entry_amount_total_2'),'required', 'step' => 'any', 'autocomplete' => 'off']) !!}
                            @if ($errors->has('amount_total'))
                                <span class="help-block"><small>{{ $errors->first('amount_total') }}</small></span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('comment') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('comment', __('base/cfdi_download.entry_comment_0') . '', ['class' => 'control-label'])) !!}
                            {!! Form::textarea('comment', old('comment'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_comment_0'), 'rows' => '2']) !!}
                            @if ($errors->has('comment'))
                                <span class="help-block"><small>{{ $errors->first('comment') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('comment_2') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('comment_2', __('base/cfdi_download.entry_comment_2') . '', ['class' => 'control-label'])) !!}
                            {!! Form::textarea('comment_2', old('comment_2'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_comment_2'), 'rows' => '2']) !!}
                            @if ($errors->has('comment_2'))
                                <span class="help-block"><small>{{ $errors->first('comment_2') }}</small></span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                    &nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-default"
                            data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">
    $(function () {
        moment.locale("{{ substr(app()->getLocale(),0,2) }}");
        $("#form_modal_cfdi_download_deposit_create input[name='date']").daterangepicker({
            singleDatePicker: true,
            timePicker: true,
            timePicker24Hour: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('datetime_picker_format','DD-MM-YYYY HH:mm:ss') }}"
            },
            autoUpdateInput: false
        }, function (chosen_date) {
            $("#form_modal_cfdi_download_deposit_create input[name='date']").val(chosen_date.format("{{ setting('datetime_picker_format','DD-MM-YYYY HH:mm:ss') }}"));
        });
        $("#form_modal_cfdi_download_deposit_create input[name='date_payment']").daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
            },
            autoUpdateInput: false,
        }, function (chosen_date) {
            $("#form_modal_cfdi_download_deposit_create input[name='date_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
        });
        /* Selecciona moneda */
        $("#form_modal_cfdi_download_deposit_create select[name='currency_id']").on("change", function () {
            let id = $(this).val();
            if (id) {
                $.ajax({
                    url: "{{ route('currencies/get-currency') }}",
                    type: "GET",
                    dataType: "JSON",
                    data: "id=" + id,
                    success: function (data) {
                        $("#form_modal_cfdi_download_deposit_create input[name='currency_value']").val(data.rate);
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#modal_general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            }
        }).trigger("change");

    });
</script>
