<!-- modal about -->
<div class="modal fade" id="modal_cfdi_download_edit" role="dialog">
    <div class="modal-dialog">
        {!! Form::model($cfdi_download,['route' => ['cfdi-downloads.update',$cfdi_download->id],'method' => 'PUT','class' => '','role' => 'form','id' => 'form_modal_cfdi_download_edit']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">{!! sprintf(__('base/cfdi_download.text_modal_edit'),$cfdi_download->name) !!}</h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('expense_type_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('expense_type_id', __('base/cfdi_download.entry_expense_type_id') . ' ', ['class' => 'control-label'])) !!}
                            {!! Form::select('expense_type_id', $expense_types,old('expense_type_id'), ['class' => 'form-control', 'placeholder' => __('general.text_none')]) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('operational_type_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('operational_type_id', __('base/cfdi_download.entry_operational_type_id') . ' ', ['class' => 'control-label'])) !!}
                            {!! Form::select('operational_type_id', $operational_types,old('operational_type_id'), ['class' => 'form-control', 'placeholder' => __('general.text_none')]) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('comment_2') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('comment_2', __('base/cfdi_download.entry_comment_2') . '', ['class' => 'control-label'])) !!}
                            {!! Form::textarea('comment_2', old('comment_2'), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_comment_2'), 'rows' => '2']) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <h5>{{__('base/cfdi_download.text_cfdi_products')}}</h4>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="table-responsive table-data">
                            <table class="table table-striped table-hover table-condensed">
                                <thead>
                                <tr class="mini">
                                    <th class="text-center">{{__('base/cfdi_download.entry_ClaveProdServ')}}</th>
                                    <th class="text-left">{{__('base/cfdi_download.entry_descripcion')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @forelse($data_xml_conceptos as $result)
                                    <tr class="">
                                        <td class="text-center">{{$result['ClaveProdServ']}}</td>
                                        <td class="text-left">{{$result['descripcion']}}</td>
                                    </tr>
                                    @empty
                                        <tr>
                                            <td colspan="2" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    <button type="submit" class="btn btn-sm btn-primary">@lang('general.button_save')</button>
                    <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">
    $(function () {
        moment.locale("{{ substr(app()->getLocale(),0,2) }}");
        $("#form_modal_cfdi_download_edit input[name='date_payment']").daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
            },
            autoUpdateInput: false,
        }, function (chosen_date) {
            $("#form_modal_cfdi_download_edit input[name='date_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
        });
    });
</script>
