<!-- modal about -->
<div class="modal fade" id="modal_cfdi_download_payments" role="dialog">
    <div class="modal-dialog modal-lg">
        {!! Form::model($cfdi_download,['route' => 'cfdi-downloads/store-payment','method' => 'PUT','class' => '','role' => 'form','id' => 'form_modal_cfdi_download_payments']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">{!! sprintf(__('base/cfdi_download.text_modal_payments'),$cfdi_download->name) !!}</h4>
            </div>
            <div class="modal-body">
            {!! Form::hidden('cfdi_download_id', old('cfdi_download_id',$cfdi_download->id), ['class' => 'form-control']) !!}
            {!! Form::hidden('currency_id', old('currency_id',$cfdi_download->currency_id), ['class' => 'form-control']) !!}
            {!! Form::hidden('currency_value', old('currency_value',$cfdi_download->currency_value), ['class' => 'form-control']) !!}
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="col-md-4 col-xs-12">
                        <b>{{__('base/cfdi_download.entry_amount_total')}}: <span id="txt_amount_total">{{money($cfdi_download->amount_total,$cfdi_download->currency->code ?? 'MXN',true)}}</span></b>
                    </div>
                    <div class="col-md-4 col-xs-12 text-center">
                        <b>{{__('base/cfdi_download.entry_amount_payment_2')}}: <span id="txt_amount_payment">{{money($cfdi_download->cfdiDownloadPayments->sum('amount_payment'),$cfdi_download->currency->code ?? 'MXN',true)}}</span></b>
                    </div>
                    <div class="col-md-4 col-xs-12 text-right">
                        <b>{{__('base/cfdi_download.entry_balance')}}: <span id="txt_balance">{{money($cfdi_download->balance,$cfdi_download->currency->code ?? 'MXN',true)}}</span></b>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 col-xs-12">
                        <hr>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('date_payment') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('date_payment', __('base/cfdi_download.entry_date_payment') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            <div class="input-group input-group-sm">
                                {!! Form::text('date_payment', old('date_payment',\App\Helpers\Helper::date(Date::now())), ['class' => 'form-control', 'placeholder' => __('base/cfdi_download.entry_date_payment'),'required','autocomplete'=>'off']) !!}
                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                            </div>
                            @if ($errors->has('date_payment'))
                                <span class="help-block"><small>{{ $errors->first('date_payment') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('payment_way_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('payment_way_id', __('base/cfdi_download.entry_payment_way_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::select('payment_way_id',$payment_ways,old('payment_way_id'), ['class' => 'form-control', 'placeholder' =>  __('general.text_select'),'required']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-7">
                        <div class="form-group form-group-sm{{ $errors->has('currency_code') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('currency_code', __('base/cfdi_download.entry_currency_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('currency_code',old('currency_code',$cfdi_download->currency->code ?? 'MXN'), ['class' => 'form-control text-center', 'placeholder' => __('general.text_select'),'required','readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('amount_payment') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('amount_payment', __('base/cfdi_download.entry_amount_payment') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('amount_payment',old('amount_payment'), ['class' => 'form-control text-right', 'placeholder' =>  __('base/cfdi_download.entry_amount_payment'),'required', 'step' => 'any', 'autocomplete' => 'off']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12 text-center">
                        {!! html_entity_decode(Form::label('amount_payment', '&nbsp;' . ' ', ['class' => 'control-label'])) !!}<br/>
                        <button type="submit" class="btn btn-sm btn-primary">@lang('general.button_save')</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 col-xs-12">
                        <hr>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="table-responsive">
                            <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                   id="payments">
                                <thead>
                                <tr>
                                    <th class="text-center">@lang('base/cfdi_download.column_date_payment')</th>
                                    <th class="text-left">@lang('base/cfdi_download.column_payment_way')</th>
                                    <th class="text-center">@lang('base/cfdi_download.column_currency')</th>
                                    <th class="text-center">@lang('base/cfdi_download.column_amount_payment')</th>
                                    <th class="text-center"></th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 col-xs-12">
                        <hr>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="table-responsive">
                            <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                   id="bank_reconciliations">
                                <thead>
                                <tr>
                                    <th class="text-left">@lang('base/cfdi_download.column_bank_reconciliation')</th>
                                    <th class="text-center">@lang('base/cfdi_download.column_date_payment')</th>
                                    <th class="text-center">@lang('base/cfdi_download.column_currency')</th>
                                    <th class="text-center">@lang('base/cfdi_download.column_amount_payment')</th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">
    function payments(){
        $("#form_modal_cfdi_download_payments #payments tbody").html("");
        $.ajax({
            url: "{{route('cfdi-downloads/payments')}}",
            type: "GET",
            dataType: "JSON",
            data: "id=" + $("#form_modal_cfdi_download_payments input[name='cfdi_download_id']").val(),
            success: function (data) {
                $("#form_modal_cfdi_download_payments #payments tbody").html(data.html);
            },
            error: function (error, textStatus, errorThrown) {
                if (error.status == 422) {
                    var message = error.responseJSON.error;
                    $("#form_modal_cfdi_download_payments #modal_general_messages").html(alertMessage("danger", message));
                } else if (error.status == 403 || error.status == 401) {
                    location.href = "{{ route('login') }}";
                } else {
                    alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                }
            }
        });
    }
    function bank_reconciliations(){
        $("#form_modal_cfdi_download_payments #bank_reconciliations tbody").html("");
        $.ajax({
            url: "{{route('cfdi-downloads/bank-reconciliations')}}",
            type: "GET",
            dataType: "JSON",
            data: "id=" + $("#form_modal_cfdi_download_payments input[name='cfdi_download_id']").val(),
            success: function (data) {
                $("#form_modal_cfdi_download_payments #bank_reconciliations tbody").html(data.html);
            },
            error: function (error, textStatus, errorThrown) {
                if (error.status == 422) {
                    var message = error.responseJSON.error;
                    $("#form_modal_cfdi_download_payments #modal_general_messages").html(alertMessage("danger", message));
                } else if (error.status == 403 || error.status == 401) {
                    location.href = "{{ route('login') }}";
                } else {
                    alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                }
            }
        });
    }
    $(function () {
        moment.locale("{{ substr(app()->getLocale(),0,2) }}");
        $("#form_modal_cfdi_download_payments input[name='date_payment']").daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: "{{ setting('date_picker_format','DD-MM-YYYY') }}"
            },
            autoUpdateInput: false,
        }, function (chosen_date) {
            $("#form_modal_cfdi_download_payments input[name='date_payment']").val(chosen_date.format("{{ setting('date_picker_format','DD-MM-YYYY') }}"));
        });

        //
        payments();
        bank_reconciliations();

        //Eliminar pago
        $(document).on("click", '#form_modal_cfdi_download_payments .link-delete-payment', function (e) {
            e.preventDefault();
            let id = $(this).attr('data-id');
            let url = $(this).attr('data-url');
            let link = $(this);
            if (id && url) {
                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "JSON",
                    data: "",
                    success: function (data) {
                        $("#form_modal_cfdi_download_payments #txt_amount_payment").html(data.amount_payment);
                        $("#form_modal_cfdi_download_payments #txt_balance").html(data.balance);
                        $("#txt_balance_" + $("#form_modal_cfdi_download_payments input[name='cfdi_download_id']").val()).html(data.balance);
                        $("#form_modal_cfdi_download_payments #modal_general_messages").html(alertMessage("success", data.success));
                        setTimeout(function () {
                            $("#form_modal_cfdi_download_payments #modal_general_messages").html("");
                        }, 3000);
                        link.parent().parent().remove();
                    },
                    error: function (error, textStatus, errorThrown) {
                        if (error.status == 422) {
                            var message = error.responseJSON.error;
                            $("#form_modal_cfdi_download_payments #modal_general_messages").html(alertMessage("danger", message));
                        } else if (error.status == 403 || error.status == 401) {
                            location.href = "{{ route('login') }}";
                        } else {
                            alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                        }
                    }
                });
            }
        });
    });
</script>
