<!-- modal about -->
<div class="modal fade" id="modal_customer_fee_payment_history" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-history"></i> {!! sprintf(__('sales/customer_fee.text_modal_payment_history')) !!}
                </h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <!-- input hidden -->
                <!-- /.input hidden -->
                <div class="row">
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('name', __('sales/customer_fee.entry_name') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('name', old('name',$customer_fee->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_fee.entry_name'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-6 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('customer', __('sales/customer_fee.entry_customer_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('customer', old('customer',$customer_fee->customer->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_fee.entry_customer_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('branch_office', __('sales/customer_fee.entry_branch_office_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('branch_office', old('branch_office',$customer_fee->branchOffice->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_fee.entry_branch_office_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('currency', __('sales/customer_fee.entry_currency_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('currency', old('currency',$customer_fee->currency->name_sat), ['class' => 'form-control', 'placeholder' => __('sales/customer_fee.entry_currency_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('currency_value', __('sales/customer_fee.entry_currency_value') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('currency_value', old('currency_value',round($customer_fee->currency_value,4)), ['class' => 'form-control text-center', 'placeholder' => __('sales/customer_fee.entry_currency_value'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('amount_total', __('sales/customer_fee.entry_amount_total') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('amount_total', old('amount_total',money($customer_fee->amount_total, $customer_fee->currency->code, true)->format()), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_fee.entry_amount_total'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('balance', __('sales/customer_fee.entry_balance') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('balance', old('balance',money($customer_fee->balance, $customer_fee->currency->code, true)->format()), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_fee.entry_balance'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('reconciled', __('sales/customer_fee.entry_reconciled') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('reconciled', old('reconciled',money($customer_fee->amount_total-$customer_fee->balance, $customer_fee->currency->code, true)->format()), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_fee.entry_reconciled'),'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="" role="tabpanel" data-example-id="togglable-tabs">
                    <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#tab_payments" id="payments-tab" role="tab" data-toggle="tab"
                               aria-expanded="true">@lang('sales/customer_fee.tab_payments')</a>
                        </li>
                    </ul>
                    <div id="myTabContent" class="tab-content">
                        <div role="tabpanel" class="tab-pane fade active in" id="tab_payments"
                             aria-labelledby="payments-tab">
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr class="mini">
                                        <th class="text-center">{{__('sales/customer_payment.column_name')}}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_currency') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_date') }}
                                        </th>
                                        <th class="text-left">{{__('sales/customer_payment.column_payment_way') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_reconciled_amount_reconciled2') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_reconciled_amount_reconciled') }}
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($customer_fee->customerPaymentHistory as $result)
                                        <tr class="">
                                            <td class="text-center">{{$result->customerPayment->name}}</td>
                                            <td class="text-center">{{$result->customerPayment->currency->code}}</td>
                                            <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDateTime($result->customerPayment->date) }}</td>
                                            <td class="text-left">{{ $result->customerPayment->paymentWay->name ?? '' }}</td>
                                            <td class="text-center">
                                                @if($customer_fee->currency->code != $result->customerPayment->currency->code)
                                                    {{ money($result->amount_reconciled,$result->customerPayment->currency->code,true) }}
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                @if($customer_fee->currency->code != $result->customerPayment->currency->code)
                                                    {{ money($result->amount_reconciled/$result->currency_value,$customer_fee->currency->code,true) }}
                                                @else
                                                    {{ money($result->amount_reconciled,$customer_fee->currency->code,true) }}
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="12" class="text-center">@lang('general.text_no_results')</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    <button type="button" class="btn btn-sm btn-default"
                            data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>

    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">
    $(function () {

    });
</script>