<!-- modal about -->
<div class="modal fade" id="modal_customer_invoice_cancel" role="dialog">
    <div class="modal-dialog">
        {!! Form::open(['route' => ['customer-invoices.destroy',$customer_invoice->id],'method' => 'DELETE','class' => '','role' => 'form','id'=>'form_modal_customer_invoice_cancel']) !!}
        {!! Form::hidden('cancelable', old('cancelable',$data_status_sat['cancelable']), ['class' => 'form-control']) !!}
        {!! Form::hidden('cancel_state', old('cancel_state',$data_status_sat['pac_is_cancelable']), ['class' => 'form-control']) !!}
        {!! Form::hidden('customer_id', old('customer_id',$customer_invoice->customer_id), ['class' => 'form-control']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">{!! sprintf(__('sales/customer_invoice.text_modal_cancel'),$customer_invoice->name) !!}</h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="text-center">
                        <h1 class="modal-icon">
                            @if($is_cancelable)
                                <i class="fa fa-question-circle-o green"></i>
                            @else
                                <i class="fa fa-exclamation-triangle green"></i>
                            @endif
                        </h1>
                    </div>
                    @if($is_cancelable)
                        <h4 class="text-center">{!! sprintf(__('sales/customer_invoice.text_modal_cancel_help1'),$customer_invoice->documentType->name) !!}</h4>
                        <p class="text-center">@lang('sales/customer_invoice.text_modal_cancel_help2')</p>
                    @else
                        <h4 class="text-center">{!! sprintf(__('sales/customer_invoice.text_modal_cancel_help1_1'),$customer_invoice->documentType->name) !!}</h4>
                    @endif
                </div>
                @if($is_cancelable)
                <div class="row">
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm text-center">
                            {!! html_entity_decode(Form::label('reason_cancellation_id', __('sales/customer_invoice.entry_reason_cancellation_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('reason_cancellation_id', $reason_cancellations,old('reason_cancellation_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                        </div>
                    </div>
                </div>
                <div class="row hidden" id="cancellation_cfdi">
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm text-center">
                            {!! html_entity_decode(Form::label('reason_cancellation_cfdi', __('sales/customer_invoice.entry_reason_cancellation_cfdi') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('reason_cancellation_cfdi', [],old('reason_cancellation_cfdi'), ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                        </div>
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <div class="form-group form-group-sm text-center">
                            {!! html_entity_decode(Form::label('reason_cancellation_uuid', __('sales/customer_invoice.entry_reason_cancellation_uuid') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('reason_cancellation_uuid',old('reason_cancellation_uuid'), ['class' => 'form-control text-center', 'placeholder' => __('sales/customer_invoice.entry_reason_cancellation_uuid')]) !!}
                        </div>
                    </div>
                </div>
                @endif
                <div class="row" style="margin-top: 15px;">
                    <div class="col-md-6 col-xs-12 text-center">
                        <div class="well" style="padding: 10px;">
                            <strong>@lang('general.text_is_cancelable_cfdi')</strong><br/>
                            {!! !empty($data_status_sat['pac_is_cancelable']) ? $data_status_sat['pac_is_cancelable'] : '&nbsp;' !!}
                        </div>
                    </div>
                    <div class="col-md-6 col-xs-12 text-center">
                        <div class="well" style="padding: 10px;">
                            <strong>@lang('general.text_status_cfdi')</strong><br/>
                            {!! !empty($data_status_sat['pac_status']) ? $data_status_sat['pac_status'] : '&nbsp;' !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    @if($is_cancelable)
                        {!! Form::button(__('general.button_confirm'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                    @endif
                    <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">
    $(function () {
        $(document).on("change", "#modal_customer_invoice_cancel select[name='reason_cancellation_id']", function (e) {
            if($(this).val() == 1){
                $("#cancellation_cfdi").removeClass("hidden")
            }else{
                $("#cancellation_cfdi").addClass("hidden")
            }
        })
        $("#modal_customer_invoice_cancel select[name='reason_cancellation_cfdi']").select2({
            ajax: {
                url: "{{route('customer-invoices/autocomplete-cfdi')}}",
                dataType: "JSON",
                delay: 250,
                data: function (params) {
                    return {
                        term: $.trim(params.term),
                        customer_id: $("#modal_customer_invoice_cancel input[name='customer_id']").val(),
                    };
                },
                processResults: function (data, page) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            placeholder: "@lang('general.text_select')",
            theme: "bootstrap",
            width: "auto",
            dropdownAutoWidth: true,
            language: "{{ str_replace('_', '-', app()->getLocale()) }}",
            minimumInputLength: 2
        });

        $(document).on("select2:select", "#modal_customer_invoice_cancel select[name='reason_cancellation_cfdi']", function (e) {
                let id = $(this).val();
                let row = $(this).attr('data-row');
                if (id) {
                    $.ajax({
                        url: "{{ route('customer-invoices/get-customer-invoice') }}",
                        type: "GET",
                        dataType: "JSON",
                        data: "id=" + id,
                        success: function (data) {
                            $("#modal_customer_invoice_cancel input[name='reason_cancellation_uuid']").val(data.uuid);
                        },
                        error: function (error, textStatus, errorThrown) {
                            if (error.status == 422) {
                                var message = error.responseJSON.error;
                                $("#general_messages").html(alertMessage("danger", message));
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    });
                }
            });
    });
</script>
