<!-- modal about -->
<div class="modal fade" id="modal_customer_invoice_payment_history" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-history"></i> {!! sprintf(__('sales/customer_invoice.text_modal_payment_history')) !!}
                </h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <!-- input hidden -->
                <!-- /.input hidden -->
                <div class="row">
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('name', __('sales/customer_invoice.entry_name') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('name', old('name',$customer_invoice->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_invoice.entry_name'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-6 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('customer', __('sales/customer_invoice.entry_customer_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('customer', old('customer',$customer_invoice->customer->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_invoice.entry_customer_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('branch_office', __('sales/customer_invoice.entry_branch_office_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('branch_office', old('branch_office',$customer_invoice->branchOffice->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_invoice.entry_branch_office_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('currency', __('sales/customer_invoice.entry_currency_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('currency', old('currency',$customer_invoice->currency->name_sat), ['class' => 'form-control', 'placeholder' => __('sales/customer_invoice.entry_currency_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('currency_value', __('sales/customer_invoice.entry_currency_value') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('currency_value', old('currency_value',round($customer_invoice->currency_value,4)), ['class' => 'form-control text-center', 'placeholder' => __('sales/customer_invoice.entry_currency_value'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('amount_total', __('sales/customer_invoice.entry_amount_total') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('amount_total', old('amount_total',money($customer_invoice->amount_total, $customer_invoice->currency->code, true)->format()), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_invoice.entry_amount_total'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('balance', __('sales/customer_invoice.entry_balance') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('balance', old('balance',money($customer_invoice->balance, $customer_invoice->currency->code, true)->format()), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_invoice.entry_balance'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('reconciled', __('sales/customer_invoice.entry_reconciled') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('reconciled', old('reconciled',money($customer_invoice->amount_total-$customer_invoice->balance, $customer_invoice->currency->code, true)->format()), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_invoice.entry_reconciled'),'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="" role="tabpanel" data-example-id="togglable-tabs">
                    <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#tab_payments" id="payments-tab" role="tab" data-toggle="tab"
                               aria-expanded="true">@lang('sales/customer_invoice.tab_payments')</a>
                        </li>
                        <li role="presentation" class="">
                            <a href="#tab_credit_notes" id="credit-notes-tab" role="tab" data-toggle="tab"
                               aria-expanded="true">@lang('sales/customer_invoice.tab_credit_notes')</a>
                        </li>
                    </ul>
                    <div id="myTabContent" class="tab-content">
                        <div role="tabpanel" class="tab-pane fade active in" id="tab_payments"
                             aria-labelledby="payments-tab">
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr class="mini">
                                        <th class="text-center">{{__('sales/customer_payment.column_name')}}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_currency') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_date') }}
                                        </th>
                                        <th class="text-left">{{__('sales/customer_payment.column_payment_way') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_date_payment') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_reconciled_currency_value') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_reconciled_amount_reconciled3') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_payment.column_reconciled_amount_reconciled') }}
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($customer_invoice->customerPaymentHistory as $result)
                                            <tr class="">
                                                <td class="text-center">{{$result->customerPayment->name}}</td>
                                                <td class="text-center">{{$result->customerPayment->currency->code}}</td>
                                                <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDateTime($result->customerPayment->date) }}</td>
                                                <td class="text-left">{{ $result->customerPayment->paymentWay->name ?? '' }}</td>
                                                <td class="text-center">{{ $result->customerPayment->date_payment ? \App\Helpers\Helper::convertSqlToDateTime($result->customerPayment->date_payment) : '' }}</td>
                                                <td class="text-center">
                                                    @if($customer_invoice->currency->code != $result->customerPayment->currency->code)
                                                        {{ \App\Helpers\Helper::numberFormatMoney($result->currency_value,4) }}
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    @if($customer_invoice->currency->code != $result->customerPayment->currency->code)
                                                        {{ money($result->amount_reconciled*$result->currency_value,$customer_invoice->currency->code,true) }}
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    {{ money($result->amount_reconciled,$customer_invoice->currency->code,true) }}
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="12" class="text-center">@lang('general.text_no_results')</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane fade in" id="tab_credit_notes"
                             aria-labelledby="payments-tab">
                            <div class="table-responsive table-data">
                                <table class="table table-striped table-hover table-condensed">
                                    <thead>
                                    <tr class="mini">
                                        <th class="text-center">{{__('sales/customer_credit_note.column_name')}}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_credit_note.column_currency') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_credit_note.column_date') }}
                                        </th>
                                        <th class="text-left">{{__('sales/customer_credit_note.column_payment_way') }}
                                        </th>
                                        <th class="text-center">{{__('sales/customer_credit_note.column_reconciled_amount_reconciled') }}
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($customer_invoice->customerCreditNoteHistory as $result)
                                            <tr class="">
                                                <td class="text-center">{{$result->customerInvoice->name}}</td>
                                                <td class="text-center">{{$result->customerInvoice->currency->code}}</td>
                                                <td class="text-center">{{ \App\Helpers\Helper::convertSqlToDateTime($result->customerInvoice->date) }}</td>
                                                <td class="text-left">{{ $result->customerInvoice->paymentWay->name ?? '' }}</td>
                                                <td class="text-center">
                                                    {{ money($result->amount_reconciled,$customer_invoice->currency->code,true) }}
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="12" class="text-center">@lang('general.text_no_results')</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    <button type="button" class="btn btn-sm btn-default"
                            data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>

    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">
    $(function () {

    });
</script>
