<!-- modal about -->
<div class="modal fade" id="modal_customer_invoice_send_mail" role="dialog">
    <div class="modal-dialog modal-lg">
        {!! Form::open(['route' => ['customer-invoices/send-mail',$customer_invoice->id],'method' => 'POST','class' => '','role' => 'form','id'=>'form_modal_customer_invoice_send_mail']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i
                            class="fa fa-envelope-o"></i> {!! sprintf(__('sales/customer_invoice.text_modal_send_mail'),$customer_invoice->name) !!}
                </h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('subject', __('general.entry_mail_subject') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('subject', old('subject',$customer_invoice->documentType->name .' ('.$customer_invoice->name.') - ' . $customer_invoice->company->name), ['class' => 'form-control', 'placeholder' => __('general.entry_mail_subject'), 'required']) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('to', __('general.entry_mail_to') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::select('to[]', $to,old('to',$to_selected), ['class' => 'form-control','multiple']) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('reply', __('general.entry_mail_reply') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('reply[]', $reply,old('reply',$reply), ['class' => 'form-control','multiple']) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('attach', __('general.entry_mail_attach') . ' ', ['class' => 'control-label'])) !!}
                            {!! Form::select('attach[]', $files,old('attach',$files_selected), ['class' => 'form-control','multiple']) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('message', __('general.entry_mail_message') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                        </div>

                        @include('layouts.partials.commons.editor_toolbar')

                        <div id="editor-one" class="editor-wrapper" contenteditable="true"></div>
                        <textarea name="message" id="message" style="display:none;"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    {!! Form::button(__('general.button_send'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                    <button type="button" class="btn btn-sm btn-default"
                            data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
