@php
    $item_reconciled_row = 1;
@endphp
@forelse($results as $result)
    <tr class="">
        <td class="text-center align-middle">
            <!-- input hidden -->
            <input type="hidden" id="item_reconciled_id_{{ $item_reconciled_row }}"
                   name="item_reconciled[{{ $item_reconciled_row }}][id]"
                   value="{{ old('item.' . $item_reconciled_row . '.id') }}">
            <input type="hidden" id="item_reconciled_reconciled_id_{{ $item_reconciled_row }}"
                   name="item_reconciled[{{ $item_reconciled_row }}][reconciled_id]"
                   value="{{ old('item.' . $item_reconciled_row . '.reconciled_id',$result->id) }}">
            <input type="hidden" id="item_reconciled_name_{{ $item_reconciled_row }}"
                   name="item_reconciled[{{ $item_reconciled_row }}][name]"
                   value="{{ old('item.' . $item_reconciled_row . '.name',$result->name) }}">
            <input type="hidden" id="item_reconciled_balance_{{ $item_reconciled_row }}"
                   name="item_reconciled[{{ $item_reconciled_row }}][balance]"
                   value="{{ old('item.' . $item_reconciled_row . '.balance',$result->balance) }}">
            <input type="hidden" id="item_reconciled_currency_code_{{ $item_reconciled_row }}"
                   name="item_reconciled[{{ $item_reconciled_row }}][currency_code]"
                   value="{{ old('item.' . $item_reconciled_row . '.currency_code',$result->currency->code) }}">
            <!-- /.input hidden -->
            {{$result->name}}
        </td>
        <td class="text-center align-middle">{{ \App\Helpers\Helper::convertSqlToDateTime($result->date) }}</td>
        <td class="text-center align-middle">{{ \App\Helpers\Helper::convertSqlToDate($result->date_due) }}</td>
        <td class="text-center align-middle">{{ $result->paymentMethod->code ?? '' }}</td>
        <td class="text-center align-middle">{{ $result->currency->code }}</td>
        <td class="text-right align-middle">{{ money($result->amount_total,$result->currency->code,true) }}</td>
        <td class="text-right align-middle">
            <span id="item_reconciled_txt_balance_{{ $item_reconciled_row }}">{{ money(\App\Helpers\Helper::convertBalanceCurrency($currency,$result->balance,$result->currency->code,$result->currency_value),$result->currency->code,true)}}</span>
        </td>
        @if(empty($filter_currency_id))
        <td class="text-center align-middle">
            @if(!empty($currency) && $currency->code == 'MXN' && $result->currency->code != 'MXN')
                <div class="form-group form-group-sm">
                    {!! Form::number('item_reconciled[' . $item_reconciled_row . '][currency_value]', old('item.' . $item_reconciled_row . '.currency_value',round($result->currency_value,4)), ['class' => 'form-control input-sm text-center col-currency-value', 'required','id' => 'item_currency_value_' . $item_reconciled_row, 'step' => 'any']) !!}
                </div>
            @else
                ---
            @endif
        </td>
        @endif
        <td class="text-right align-middle">
            <div class="form-group form-group-sm">
                {!! Form::number('item_reconciled[' . $item_reconciled_row . '][amount_reconciled]', old('item.' . $item_reconciled_row . '.amount_reconciled'), ['class' => 'form-control input-sm text-right col-amount-reconciled','id' => 'item_amount_reconciled_' . $item_reconciled_row, 'step' => 'any']) !!}
            </div>
        </td>
</tr>
@php
    $item_reconciled_row++;
@endphp
@empty
<tr>
    <td colspan="8" class="text-center">@lang('general.text_no_results')</td>
</tr>
@endforelse