<!-- modal about -->
<div class="modal fade" id="modal_customer_payment_reconciled" role="dialog">
    <div class="modal-dialog modal-lg">
        {!! Form::open(['route' => ['customer-payments/reconciled',$customer_payment->id],'method' => 'POST','class' => '','role' => 'form','id'=>'form_modal_customer_payment_reconciled']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-refresh"></i> {!! sprintf(__('sales/customer_payment.text_modal_reconciled'),$customer_payment->name) !!}
                </h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <!-- input hidden -->
                {!! Form::hidden('currency_id', old('currency_id',$customer_payment->currency_id)) !!}
                {!! Form::hidden('amount_reconciled', old('amount_reconciled',$customer_payment->amount-$customer_payment->balance)) !!}
                {!! Form::hidden('amount', old('amount',$customer_payment->amount)) !!}
                <!-- /.input hidden -->
                <div class="row">
                    <div class="col-md-8 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('customer', __('sales/customer_payment.entry_customer_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('customer', old('customer',$customer_payment->customer->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_payment.entry_customer_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('payment_way', __('sales/customer_payment.entry_payment_way_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('payment_way', old('payment_way',$customer_payment->paymentWay->name_sat), ['class' => 'form-control', 'placeholder' => __('sales/customer_payment.entry_payment_way_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('branch_office', __('sales/customer_payment.entry_branch_office_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('branch_office', old('branch_office',$customer_payment->branchOffice->name), ['class' => 'form-control', 'placeholder' => __('sales/customer_payment.entry_branch_office_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('currency', __('sales/customer_payment.entry_currency_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('currency', old('currency',$customer_payment->currency->name_sat), ['class' => 'form-control', 'placeholder' => __('sales/customer_payment.entry_currency_id'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('currency_value', __('sales/customer_payment.entry_currency_value') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('currency_value', old('currency_value',round($customer_payment->currency_value,4)), ['class' => 'form-control text-center', 'placeholder' => __('sales/customer_payment.entry_currency_value'),'readonly']) !!}
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('amount_x', __('sales/customer_payment.entry_amount') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('amount_x', old('amount_x',money($customer_payment->amount, $customer_payment->currency->code, true)->format()), ['class' => 'form-control text-right', 'placeholder' => __('sales/customer_payment.entry_amount'),'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="" role="tabpanel" data-example-id="togglable-tabs">
                    <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#tab_reconcileds" id="reconcileds-tab" role="tab" data-toggle="tab"
                               aria-expanded="true">@lang('sales/customer_payment.tab_reconcileds')</a>
                        </li>
                    </ul>
                    <div id="myTabContent" class="tab-content">
                        <div role="tabpanel" class="tab-pane fade active in" id="tab_reconcileds"
                             aria-labelledby="reconcileds-tab">
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="well alert-important" style="margin: 10px 0 20px 0; padding: 5px 19px;">
                                        <p class="text-center" style="margin: 0;">
                                            @lang('sales/customer_payment.entry_amount'): <span id="reconciled_txt_amount">{{ money($customer_payment->amount, $customer_payment->currency->code, true)->format() }}</span>
                                            &nbsp;&nbsp;&nbsp;
                                            @lang('sales/customer_payment.text_reconciled'): <span id="reconciled_txt_amount_reconciled">{{ money($customer_payment->amount-$customer_payment->balance, $customer_payment->currency->code, true)->format() }}</span>
                                            &nbsp;&nbsp;&nbsp;
                                            @lang('sales/customer_payment.text_per_reconciled'): <span id="reconciled_txt_amount_per_reconciled">{{ money($customer_payment->balance, $customer_payment->currency->code, true)->format() }}</span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-xs-12">
                                    <div class="table-responsive">
                                        <table class="table table-items table-condensed table-hover table-bordered table-striped"
                                               id="items_reconciled">
                                            <thead>
                                            <tr>
                                                <th class="text-center">@lang('sales/customer_payment.column_reconciled_name')</th>
                                                <th width="17%" class="text-center">@lang('sales/customer_payment.column_reconciled_date')</th>
                                                <th width="13%" class="text-center">@lang('sales/customer_payment.column_reconciled_date_due')</th>
                                                <th width="10%" class="text-center">@lang('sales/customer_payment.column_reconciled_payment_method')</th>
                                                <th width="8%" class="text-center">@lang('sales/customer_payment.column_reconciled_currency')</th>
                                                <th width="12%" class="text-center">
                                                    @lang('sales/customer_payment.column_reconciled_amount_total')
                                                </th>
                                                <th width="12%" class="text-center">
                                                    @lang('sales/customer_payment.column_reconciled_balance')
                                                    <span id="info_reconciled_balance_currency"></span>
                                                </th>
                                                <th width="10%" class="text-center">@lang('sales/customer_payment.column_reconciled_currency_value')</th>
                                                <th width="14%" class="text-center">@lang('sales/customer_payment.column_reconciled_amount_reconciled')</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            {!! $result_balances !!}
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                    <button type="button" class="btn btn-sm btn-default"
                            data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
<script type="text/javascript">

    function totalItemReconciled() {
        $.ajax({
            url: "{{ route('customer-payments/total-reconciled-lines') }}",
            type: "POST",
            dataType: "JSON",
            data: $("#form_modal_customer_payment_reconciled").serialize(),
            success: function (data) {
                if (data) {
                    $.each(data.items_reconciled, function (key, value) {
                        $("#form_modal_customer_payment_reconciled #item_reconciled_txt_balance_" + key).html(value);
                    });
                    $("#form_modal_customer_payment_reconciled #reconciled_txt_amount").html(data.amount);
                    $("#form_modal_customer_payment_reconciled #reconciled_txt_amount_reconciled").html(data.amount_reconciled);
                    $("#form_modal_customer_payment_reconciled #reconciled_txt_amount_per_reconciled").html(data.amount_per_reconciled);
                }
            },
            error: function (error, textStatus, errorThrown) {
                if (error.status == 422) {
                    var message = error.responseJSON.error;
                    $("#modal_general_messages").html(alertMessage("danger", message));
                } else if (error.status == 403 || error.status == 401) {
                    location.href = "{{ route('login') }}";
                } else {
                    alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                }
            }
        });
    }

    $(function () {
        /* Eventos en items */
        $(document).on("keyup", "#form_modal_customer_payment_reconciled #items_reconciled tbody .col-amount-reconciled,#form_modal_customer_payment_reconciled #items_reconciled tbody .col-currency-value", function () {
            totalItemReconciled();
        });
    });
</script>