<!-- modal about -->
<div class="modal fade" id="modal_customer_create" role="dialog">
    <div class="modal-dialog modal-lg">
        {!! Form::open(['route' => 'customers.store','method' => 'POST','class' => '','role' => 'form','id'=>'form_modal_customer_create']) !!}
        {!! Form::hidden('status', old('status','1'), ['class' => 'form-control']) !!}
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-save"></i> {!! __('sales/customer.text_modal_create') !!}</h4>
            </div>
            <div class="modal-body">
                <!-- Mensajes -->
                <div id="modal_general_messages">
                </div>
                <div class="row">
                    <div class="col-md-8 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('name', __('sales/customer.entry_name') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_name'),'required','autofocus']) !!}
                            @if ($errors->has('name'))
                                <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('taxid') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('taxid', __('sales/customer.entry_taxid') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('taxid', old('taxid'), ['class' => 'form-control text-uppercase', 'placeholder' => __('sales/customer.entry_taxid'),'required']) !!}
                            @if ($errors->has('taxid'))
                                <span class="help-block"><small>{{ $errors->first('taxid') }}</small></span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('tax_regimen_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('tax_regimen_id', __('sales/customer.entry_tax_regimen_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('tax_regimen_id', $tax_regimens,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                            @if ($errors->has('tax_regimen_id'))
                                <span class="help-block"><small>{{ $errors->first('tax_regimen_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('payment_term_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('payment_term_id', __('sales/customer.entry_payment_term_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::select('payment_term_id', $payment_terms,null, ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                            @if ($errors->has('payment_term_id'))
                                <span class="help-block"><small>{{ $errors->first('payment_term_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('payment_way_id', __('sales/customer.entry_payment_way_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('payment_way_id', $payment_ways,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('payment_method_id', __('sales/customer.entry_payment_method_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('payment_method_id', $payment_methods,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                        </div>
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <div class="form-group form-group-sm">
                            {!! html_entity_decode(Form::label('cfdi_use_id', __('sales/customer.entry_cfdi_use_id') . '', ['class' => 'control-label'])) !!}
                            {!! Form::select('cfdi_use_id', $cfdi_uses,null, ['class' => 'form-control', 'placeholder' => __('general.text_select')]) !!}
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('email', __('sales/customer.entry_email') . '', ['class' => 'control-label'])) !!}
                            {!! Form::text('email', old('email'), ['class' => 'form-control', 'placeholder' => __('sales/customer.help_email')]) !!}
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('country_id') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('country_id', __('sales/customer.entry_country_id') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::select('country_id', $countries,old('country_id'), ['class' => 'form-control', 'placeholder' => __('general.text_select'),'required']) !!}
                            @if ($errors->has('country_id'))
                                <span class="help-block"><small>{{ $errors->first('country_id') }}</small></span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group form-group-sm{{ $errors->has('postcode') ? ' has-error' : '' }}">
                            {!! html_entity_decode(Form::label('postcode', __('sales/customer.entry_postcode') . ' <span class="required text-danger">*</span>', ['class' => 'control-label'])) !!}
                            {!! Form::text('postcode', old('postcode'), ['class' => 'form-control', 'placeholder' => __('sales/customer.entry_postcode')]) !!}
                            @if ($errors->has('postcode'))
                                <span class="help-block"><small>{{ $errors->first('postcode') }}</small></span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="pull-right">
                    {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                    &nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-default"
                            data-dismiss="modal">{{ __('general.button_close') }}</button>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
<!-- /modal about -->
